/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanClustersInfo;
import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.streamline.barman.BarmanProcessorCounters;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.IBarmanHeaderProcessor;
import com.arm.streamline.barman.IBarmanProcessorInformation;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barman.v1.BarmanHeaderProcessorV1;
import com.arm.streamline.barman.v1.BarmanProtocolStateV3;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanHeaderV1
extends BarmanHeaderDataV1
implements IBarmanHeader<IBarmanRecord> {
    public static final long VMUID = 0L;
    private final @NonNull BarmanClustersInfo clustersInfo;
    private final @NonNull BarmanProcessorCounters counters;
    private final int headerLength;

    public BarmanHeaderV1(@NonNull BarmanTypeAndVersion typeAndVersion, @NonNull BarmanHeaderDataV1.ClockInfo clockInfo, @NonNull BarmanHeaderDataV1.ConfigConstants configConstants, @NonNull List<@NonNull CustomChart> customCharts, @NonNull BarmanDataStoreParameters dataStoreParameters, @NonNull BarmanHeaderDataV1.DataStoreType dataStoreType, long lastTimestamp, @NonNull BarmanHeaderDataV1.MmapLayout @NonNull [] mmapLayout, @NonNull BarmanHeaderDataV1.PmuSettings @NonNull [] perCorePmuSettings, @NonNull String targetName, @NonNull BarmanHeaderDataV1.TaskInfo @NonNull [] taskInfo, int timerSampleRate, @NonNull BarmanClustersInfo clustersInfo, @NonNull BarmanProcessorCounters counters, int headerLength) {
        super(typeAndVersion, clockInfo, configConstants, customCharts, dataStoreParameters, dataStoreType, lastTimestamp, mmapLayout, perCorePmuSettings, targetName, taskInfo, timerSampleRate);
        this.clustersInfo = clustersInfo;
        this.counters = counters;
        this.headerLength = headerLength;
    }

    public BarmanHeaderV1(@NonNull Map<Integer, ProcessorPmu> pmus, @NonNull Events events, @NonNull BarmanTypeAndVersion typeAndVersion, @NonNull BarmanDataInput<?> dataInput) throws IOException, BarmanDataError {
        super(typeAndVersion, dataInput);
        this.headerLength = (int)dataInput.getOffset();
        @NonNull List<@NonNull IBarmanProcessorInformation> validProcessors = Stream.of(this.getPerCorePmuSettings()).filter(BarmanHeaderDataV1.PmuSettings::isValid).collect(Collectors.toList());
        this.clustersInfo = new BarmanClustersInfo(pmus, validProcessors);
        this.counters = new BarmanProcessorCounters(this.clustersInfo, pmus, events, validProcessors, this.getCustomCharts());
    }

    @Override
    public @NonNull BarmanProtocolStateV3 createInitialProtocolState() {
        return new BarmanProtocolStateV3(this.getPerCorePmuSettings(), 0);
    }

    @Override
    public @NonNull IBarmanHeaderProcessor<IBarmanRecord> createNewHeaderProcessor(@NonNull Map<@NonNull String, @NonNull File> imagesMap) {
        return new BarmanHeaderProcessorV1(this, imagesMap);
    }

    @Override
    public @NonNull BarmanClustersInfo getClustersInfo() {
        return this.clustersInfo;
    }

    @Override
    public int getCoreCount() {
        return this.clustersInfo.getCoreCount();
    }

    @Override
    public @NonNull BarmanProcessorCounters getCounters() {
        return this.counters;
    }

    @Override
    public long getCreatedUnixTimestampSeconds() {
        return this.getClockInfo().getUnixBaseNs() / 1000000000L;
    }

    @Override
    public int getHeaderLength() {
        return this.headerLength;
    }

    public long getVmUID() {
        return 0L;
    }

    @Override
    public boolean isMmapInformationProvided() {
        return this.getMmapLayout().length > 0;
    }

    public static class ClusterMap {
        private final @NonNull TIntIntMap clusterIdMap = new TIntIntHashMap(10, 0.5f, -1, -1);

        public int mapClusterId(int clusterId) {
            int result = this.clusterIdMap.get(clusterId);
            if (result == this.clusterIdMap.getNoEntryValue()) {
                result = this.clusterIdMap.size();
                this.clusterIdMap.put(clusterId, result);
            }
            return result;
        }
    }
}

