/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.BarmanSeekableDataInput;
import com.arm.streamline.barman.IBarmanHeaderProcessor;
import com.arm.streamline.barman.IBarmanProcessorInformation;
import com.arm.streamline.barman.pass_two.BarmanUniqueChildThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueProcessThread;
import com.arm.streamline.barman.pass_two.BarmanUniqueThreadTracker;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThreadTracker;
import com.arm.streamline.barman.recordstream.IBarmanCoreAndTimestampFactory;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanRecordFactory;
import com.arm.streamline.barman.recordstream.IBarmanSeekableRecordStreamReader;
import com.arm.streamline.barman.v1.BarmanCoreAndTimestampFactoryV1;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barman.v1.BarmanHeaderV1;
import com.arm.streamline.barman.v1.BarmanRecordFactoryV1;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.MIDRUtilities;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.elfdwarf.ElfDwarfParser;
import com.arm.streamline.jni.elfdwarf.SectionRecord;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.utils.NullChecking;
import com.arm.utils.datainput.SeekableInputStream;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanHeaderProcessorV1
implements IBarmanHeaderProcessor<IBarmanRecord> {
    private final @NonNull BarmanHeaderV1 header;
    private final int idleTaskId;
    private final @NonNull Map<@NonNull String, @NonNull File> imagesMap;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static @NonNull BarmanUniqueThreadTracker createBarmanUniqueThreadTrackerFor(long vmUID, @NonNull BarmanHeaderV1 header, int idleTaskId, @NonNull Map<@NonNull String, @NonNull File> imagesMap, @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> uniqueThreadsMap, @NonNull IntSupplier uidSupplier, @NonNull Consumer<@NonNull WarningItem> warningConsumer, @NonNull BiFunction<@NonNull String, @NonNull File, @NonNull Collection<@NonNull BarmanHeaderDataV1.MmapLayout>> elfDwarfParser) {
        if (vmUID != 0L) {
            throw new AssertionError();
        }
        @NonNull BarmanHeaderDataV1.MmapLayout @NonNull [] mmaps = header.getMmapLayout();
        @NonNull BarmanHeaderDataV1.TaskInfo @NonNull [] taskInfos = header.getTaskInfo();
        @NonNull BarmanHeaderDataV1.ClockInfo clockInfo = header.getClockInfo();
        boolean supportsTaskInfo = header.getConfigConstants().getMaxTaskInfos() > 0;
        @NonNull TIntObjectHashMap taskInfosByTaskId = new TIntObjectHashMap(10, 0.5f, 0);
        taskInfosByTaskId.put(idleTaskId, (Object)new BarmanHeaderDataV1.TaskInfo(clockInfo.getTimestampBase(), idleTaskId, "idle"));
        taskInfosByTaskId.put(0, (Object)new BarmanHeaderDataV1.TaskInfo(clockInfo.getTimestampBase(), 0, DocumentsMessages.BARMAN_DEFAULT_PROCESS_NAME));
        BarmanHeaderDataV1.TaskInfo[] taskInfoArray = taskInfos;
        int n = taskInfos.length;
        int n2 = 0;
        while (n2 < n) {
            BarmanHeaderDataV1.TaskInfo taskInfo = taskInfoArray[n2];
            taskInfosByTaskId.put(taskInfo.getTaskId(), (Object)taskInfo);
            ++n2;
        }
        if (mmaps.length == 0) {
            @NonNull ArrayList<@NonNull E> elfDwarfMMaps = new ArrayList();
            imagesMap.forEach((name, path) -> ((Collection)elfDwarfParser.apply((String)name, (File)path)).forEach(mmap -> {
                elfDwarfMMaps.stream().filter(mmap::overlaps).forEach(other -> {
                    String text = mmap.toString() + ":" + other.toString();
                    warningConsumer.accept(new WarningItem(WarningType.ELF_DWARF, WarningSeverity.MEDIUM, BarmanMessages.SECTION_OVERLAP_TITLE, BarmanMessages.SECTION_OVERLAP_DESCRIPTION, text));
                });
                elfDwarfMMaps.add(mmap);
            }));
            @NonNull List<@NonNull ExecutablePathMapping> elfDwarfMappings = elfDwarfMMaps.stream().map(mmap -> new ExecutablePathMapping(IExecutablePath.createFromPath((String)mmap.getImageName()), mmap.getImageOffset(), mmap.getBaseAddress(), mmap.getLength())).collect(Collectors.toList());
            elfDwarfMappings.sort(Comparator.naturalOrder());
            ExecutablePathMapping firstElfDwarfMapping = !elfDwarfMappings.isEmpty() ? (ExecutablePathMapping)elfDwarfMappings.get(0) : null;
            IExecutablePath executablePath = firstElfDwarfMapping != null ? firstElfDwarfMapping.executablePath : null;
            @NonNull HashSet<@NonNull Object> threads = new HashSet<Object>();
            @NonNull BarmanHeaderDataV1.TaskInfo processInfo = (BarmanHeaderDataV1.TaskInfo)NullChecking.neverNull((Object)((BarmanHeaderDataV1.TaskInfo)taskInfosByTaskId.get(0)));
            @NonNull BarmanUniqueProcessThread processThread = BarmanHeaderProcessorV1.newBarmanUniqueThread(uidSupplier, clockInfo, vmUID, processInfo, idleTaskId, elfDwarfMappings, executablePath);
            threads.add(processThread);
            int[] taskIds = taskInfosByTaskId.keys();
            Arrays.sort(taskIds);
            int[] nArray = taskIds;
            int n3 = taskIds.length;
            int n4 = 0;
            while (n4 < n3) {
                int taskId = nArray[n4];
                BarmanHeaderDataV1.TaskInfo taskInfo = (BarmanHeaderDataV1.TaskInfo)taskInfosByTaskId.get(taskId);
                assert (taskInfo != null);
                if (taskInfo != processInfo) {
                    threads.add(BarmanHeaderProcessorV1.newBarmanUniqueThread(uidSupplier, clockInfo, processThread, taskInfo, idleTaskId));
                }
                ++n4;
            }
            return new BarmanUniqueThreadTracker(uniqueThreadsMap, uidSupplier, vmUID, threads, processThread);
        }
        @NonNull @NonNull TIntObjectHashMap taskIdToExecutablePathMapping = new TIntObjectHashMap(10, 0.5f, 0);
        @NonNull TIntLongHashMap taskIdToEarliestMappingTimestamp = new TIntLongHashMap(10, 0.5f, 0, Long.MAX_VALUE);
        BarmanHeaderDataV1.MmapLayout[] processThread = mmaps;
        int processInfo = mmaps.length;
        int threads = 0;
        while (threads < processInfo) {
            BarmanHeaderDataV1.MmapLayout mmap2 = processThread[threads];
            @Nullable Integer rawTaskId = mmap2.getTaskId();
            int taskId = rawTaskId != null ? rawTaskId : 0;
            ArrayList<@NonNull ExecutablePathMapping> set = (ArrayList<ExecutablePathMapping>)taskIdToExecutablePathMapping.get(taskId);
            if (set == null) {
                set = new ArrayList<ExecutablePathMapping>();
                taskIdToExecutablePathMapping.put(taskId, set);
            }
            set.add(new ExecutablePathMapping(IExecutablePath.createFromPath((String)mmap2.getImageName()), mmap2.getImageOffset(), mmap2.getBaseAddress(), mmap2.getLength()));
            long timestamp = taskIdToEarliestMappingTimestamp.get(taskId);
            taskIdToEarliestMappingTimestamp.put(taskId, Math.max(timestamp, mmap2.getTimestamp()));
            ++threads;
        }
        @NonNull TIntObjectIterator it = taskIdToExecutablePathMapping.iterator();
        while (it.hasNext()) {
            it.advance();
            int taskId = it.key();
            @NonNull List mappings = (List)it.value();
            mappings.sort(Comparator.naturalOrder());
            if (taskInfosByTaskId.containsKey(taskId)) continue;
            long timestamp = taskIdToEarliestMappingTimestamp.get(taskId);
            taskInfosByTaskId.put(taskId, (Object)new BarmanHeaderDataV1.TaskInfo(timestamp, taskId, ""));
        }
        @NonNull HashSet<@NonNull BarmanUniqueProcessThread> threads2 = new HashSet<BarmanUniqueProcessThread>();
        int[] taskIds = taskInfosByTaskId.keys();
        Arrays.sort(taskIds);
        BarmanUniqueProcessThread processThread2 = null;
        int[] nArray = taskIds;
        int n5 = taskIds.length;
        int n6 = 0;
        while (n6 < n5) {
            int taskId = nArray[n6];
            BarmanHeaderDataV1.TaskInfo taskInfo = (BarmanHeaderDataV1.TaskInfo)taskInfosByTaskId.get(taskId);
            assert (taskInfo != null);
            @Nullable @NonNull List mappings = (List)taskIdToExecutablePathMapping.get(taskInfo.getTaskId());
            IExecutablePath executablePath = mappings != null && !mappings.isEmpty() ? ((ExecutablePathMapping)mappings.get((int)0)).executablePath : null;
            @NonNull BarmanUniqueProcessThread thread = BarmanHeaderProcessorV1.newBarmanUniqueThread(uidSupplier, clockInfo, vmUID, taskInfo, idleTaskId, mappings, executablePath);
            threads2.add(thread);
            if (!supportsTaskInfo && taskIds.length == 1) {
                processThread2 = thread;
            }
            ++n6;
        }
        return new BarmanUniqueThreadTracker(uniqueThreadsMap, uidSupplier, vmUID, threads2, processThread2);
    }

    private static @NonNull BarmanUniqueChildThread newBarmanUniqueThread(@NonNull IntSupplier uidSupplier, @NonNull BarmanHeaderDataV1.ClockInfo clockInfo, @NonNull BarmanUniqueProcessThread processThread, @NonNull BarmanHeaderDataV1.TaskInfo taskInfo, int idleTaskId) {
        long timestamp = clockInfo.convertTimestampToNs(taskInfo.getTimestamp());
        int taskId = taskInfo.getTaskId();
        String name = !taskInfo.getTaskName().isEmpty() ? taskInfo.getTaskName() : null;
        boolean idle = idleTaskId == taskId;
        return new BarmanUniqueChildThread(uidSupplier.getAsInt(), timestamp, taskId, processThread, name, idle);
    }

    private static @NonNull BarmanUniqueProcessThread newBarmanUniqueThread(@NonNull IntSupplier uidSupplier, @NonNull BarmanHeaderDataV1.ClockInfo clockInfo, long vmUID, @NonNull BarmanHeaderDataV1.TaskInfo taskInfo, int idleTaskId, @Nullable List<@NonNull ExecutablePathMapping> mmaps, @Nullable IExecutablePath executablePath) {
        long timestamp = clockInfo.convertTimestampToNs(taskInfo.getTimestamp());
        int taskId = taskInfo.getTaskId();
        String name = !taskInfo.getTaskName().isEmpty() ? taskInfo.getTaskName() : null;
        boolean idle = idleTaskId == taskId;
        return new BarmanUniqueProcessThread(uidSupplier.getAsInt(), uidSupplier.getAsInt(), vmUID, timestamp, taskId, name, mmaps, executablePath, idle);
    }

    public BarmanHeaderProcessorV1(@NonNull BarmanHeaderV1 header, @NonNull Map<@NonNull String, @NonNull File> imagesMap) {
        this.header = header;
        this.imagesMap = imagesMap;
        TIntSet taskIds = (TIntSet)Stream.of(header.getTaskInfo()).mapToInt(BarmanHeaderDataV1.TaskInfo::getTaskId).collect(TIntHashSet::new, TIntSet::add, TIntSet::addAll);
        int tmpTaskId = -1;
        while (taskIds.contains(tmpTaskId)) {
            --tmpTaskId;
        }
        this.idleTaskId = tmpTaskId;
    }

    @Override
    public @NonNull IBarmanUniqueThreadTracker createBarmanUniqueThreadTrackerFor(long vmUID, @NonNull Map<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> uniqueThreadsMap, @NonNull IntSupplier uidSupplier, @NonNull Consumer<@NonNull WarningItem> warningConsumer) {
        return BarmanHeaderProcessorV1.createBarmanUniqueThreadTrackerFor(vmUID, this.header, this.idleTaskId, this.imagesMap, uniqueThreadsMap, uidSupplier, warningConsumer, (name, file) -> {
            SectionRecord[] sections;
            try {
                sections = ElfDwarfParser.getSections((File)file, (boolean)false);
            }
            catch (CodecException | IOException e) {
                throw new RuntimeException("Unexpected error from ELF/DWARF parser", e);
            }
            ArrayList<@NonNull BarmanHeaderDataV1.MmapLayout> result = new ArrayList<BarmanHeaderDataV1.MmapLayout>();
            SectionRecord[] sectionRecordArray = sections;
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                SectionRecord section = sectionRecordArray[n2];
                if (section.isExec()) {
                    @NonNull BarmanHeaderDataV1.MmapLayout mmap = new BarmanHeaderDataV1.MmapLayout(0L, section.getAddress(), section.getSize(), section.getFileOffset(), (String)name);
                    result.add(mmap);
                }
                ++n2;
            }
            return result;
        });
    }

    @Override
    public @NonNull IBarmanCoreAndTimestampFactory createNewCoreAndTimestampFactory() {
        return new BarmanCoreAndTimestampFactoryV1(this.header.getPerCorePmuSettings().length);
    }

    @Override
    public @NonNull IBarmanRecordFactory<IBarmanRecord> createNewRecordFactory() {
        return new BarmanRecordFactoryV1(this.header, this.idleTaskId);
    }

    @Override
    public @NonNull IBarmanSeekableRecordStreamReader createNewRecordStreamInput(@NonNull SeekableInputStream seekableInputStream) throws IOException, BarmanDataError {
        BarmanSeekableDataInput wrappedStream = this.header.getTypeAndVersion().wrapStream(seekableInputStream);
        try {
            wrappedStream.seek(this.header.getHeaderLength());
            return this.header.getDataStoreType().createStreamInput(wrappedStream, this.header.getDataStoreParameters());
        }
        catch (Throwable t) {
            wrappedStream.close();
            throw t;
        }
    }

    public @NonNull BarmanHeaderV1 getHeader() {
        return this.header;
    }

    @Override
    public int getIdleTaskId() {
        return this.idleTaskId;
    }

    @Override
    public @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> getProcessingElementProperties(@NonNull ProcessingElementReferenceSet peReferenceSet) {
        @NonNull HashMap<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> result = new HashMap<ProcessingElementReference, ProcessingElementDescriptor>();
        for (IBarmanProcessorInformation processor : this.header.getClustersInfo().getProcessors()) {
            @NonNull String clusterName = (String)NullChecking.neverNull((Object)((String)this.header.getClustersInfo().getClusterNames().get(processor.getClusterId())));
            @NonNull ProcessingElementTopology topology = new ProcessingElementTopology(processor.getProcessorId(), processor.getClusterId(), processor.getClusterIndex(), 0);
            @NonNull ProcessingElementReference peReference = peReferenceSet.get(DeviceType.CPU, 0L, processor.getProcessorId());
            @NonNull ProcessingElementDescriptor descriptor = new ProcessingElementDescriptor(MIDRUtilities.makeGatorCpuid((int)processor.getMIDR()), clusterName, topology);
            result.put(peReference, descriptor);
        }
        return result;
    }

    @Override
    public boolean shouldShowProcesses() {
        return false;
    }

    @Override
    public long convertTimestampToNs(long rawTimestamp) {
        return this.header.getClockInfo().convertTimestampToNs(rawTimestamp);
    }
}

