/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.recordstream.AbstractBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanHaltEventRecordV2
extends AbstractBarmanRecord {
    private final int core;
    private final boolean enteredHalt;
    private final int taskId;
    private final  @NonNull BarmanTaskSwitchRecordV1.Reason taskSwitchReason;

    public BarmanHaltEventRecordV2(long timestamp, int core, boolean enteredHalt, int taskId,  @NonNull BarmanTaskSwitchRecordV1.Reason taskSwitchReason) {
        super(timestamp);
        this.core = core;
        this.enteredHalt = enteredHalt;
        this.taskId = taskId;
        this.taskSwitchReason = taskSwitchReason;
    }

    @Override
    public void process(@NonNull IBarmanEventStream eventStream) throws IOException {
        if (this.enteredHalt) {
            eventStream.schedSwitch(this.timestamp, this.core, this.taskId, this.taskSwitchReason.getDatabaseValue());
            eventStream.idle(this.timestamp, this.core, true);
        } else {
            eventStream.idle(this.timestamp, this.core, false);
            eventStream.schedSwitch(this.timestamp, this.core, this.taskId, this.taskSwitchReason.getDatabaseValue());
        }
    }

    public String toString() {
        return String.format("HaltEventV2 %s {core: %s, timestamp : %s, lastActiveTaskId: %s, lastTaskSwitchReason: %s}", new Object[]{this.enteredHalt ? "[entry]" : "[exit] ", this.core, this.timestamp, this.taskId, this.taskSwitchReason});
    }
}

