/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.recordstream.AbstractBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanAnnotationRecordV2
extends AbstractBarmanRecord {
    private final int taskId;
    private final @NonNull Type type;
    private final int channel;
    private final int group;
    private final int color;
    private final byte[] data;

    public BarmanAnnotationRecordV2(long timestamp, int taskId, @NonNull Type type, int channel, int group, int color, byte[] data) {
        super(timestamp);
        this.taskId = taskId;
        this.type = type;
        this.channel = channel;
        this.group = group;
        this.color = color;
        this.data = data;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getColor() {
        return this.color;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getGroup() {
        return this.group;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public @NonNull Type getType() {
        return this.type;
    }

    @Override
    public void process(@NonNull IBarmanEventStream eventStream) throws IOException {
        String msg = this.data != null ? new String(this.data) : "";
        switch (this.type) {
            case BOOKMARK: {
                eventStream.annotationMarker(this.timestamp, this.taskId, this.color, msg);
                break;
            }
            case CHANNEL_NAME: {
                eventStream.annotationTextNameChannel(this.timestamp, this.taskId, this.channel, this.group, msg);
                break;
            }
            case GROUP_NAME: {
                eventStream.annotationTextNameGroup(this.timestamp, this.taskId, this.group, msg);
                break;
            }
            case STRING: {
                boolean isEnd = (this.data == null || this.data.length == 0) && this.group == 0;
                int overrideColor = isEnd || this.color == 0 ? -3092272 : this.color;
                eventStream.annotationText(this.timestamp, this.taskId, this.channel, overrideColor, msg);
                break;
            }
        }
    }

    public String toString() {
        return String.format("AnnotationV2 {timestamp: %s, taskId: %s, type: %s, channel: %s, group: %s, color: %s, text: %s}", new Object[]{this.timestamp, this.taskId, this.type, this.channel, this.group, this.color, new String(this.data)});
    }

    public static enum Type {
        STRING(0),
        BOOKMARK(1),
        CHANNEL_NAME(2),
        GROUP_NAME(3);

        private final byte protocolValue;

        public static @NonNull Type findType(byte protocolValue) throws BarmanDataError {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type value = typeArray[n2];
                if (value.protocolValue == protocolValue) {
                    return value;
                }
                ++n2;
            }
            throw new BarmanDataError();
        }

        private Type(byte protocolValue) {
            this.protocolValue = protocolValue;
        }
    }
}

