/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.recordstream.IBarmanCoreAndTimestampFactory;
import com.arm.streamline.barman.recordstream.IBarmanRecordStreamReader;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.utils.ListUtils;
import gnu.trove.map.hash.TLongLongHashMap;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanRecordStreamProducer {
    private static final int BACKWARD_STEP_THRESHOLD = 10;

    public static <T extends Comparable<? super T>> @NonNull List<@NonNull T> getFrameAddresses(@NonNull IBarmanRecordStreamReader dataInput, @NonNull IBarmanCoreAndTimestampFactory coreAndTimestampFactory, @NonNull IEntryMapper<T> entryMapper, @NonNull Consumer<@NonNull WarningItem> warningConsumer, @NonNull BooleanSupplier interrupt) throws InterruptedException, BarmanDataError, IOException {
        @NonNull ArrayList<@NonNull E> addresses = new ArrayList();
        int numberOfBackwardSteps = 0;
        @NonNull TLongLongHashMap timestamps = new TLongLongHashMap();
        try {
            while (!interrupt.getAsBoolean()) {
                IBarmanRecordStreamReader.Block block = dataInput.readBlock();
                if (block.data == null) continue;
                @NonNull ByteBuffer data = block.data;
                IBarmanCoreAndTimestampFactory.CoreTimestampAndVm coreAndTimestamp = coreAndTimestampFactory.getCoreAndTimestamp(data);
                long timestamp = timestamps.adjustOrPutValue(coreAndTimestamp.vmUID, 0L, 0L);
                if (coreAndTimestamp.timestamp != -1L) {
                    timestamp = coreAndTimestamp.timestamp;
                }
                timestamps.put(coreAndTimestamp.vmUID, timestamp);
                @NonNull Comparable entry = (Comparable)entryMapper.map(coreAndTimestamp.vmUID, timestamp, block.offset, data.limit());
                numberOfBackwardSteps += ListUtils.appendInOrder(addresses, (Comparable)entry);
            }
            throw new InterruptedException();
        }
        catch (EOFException eOFException) {
            if (numberOfBackwardSteps > 10 * addresses.size()) {
                warningConsumer.accept(new WarningItem(WarningType.CORRUPTION, WarningSeverity.MEDIUM, BarmanMessages.HIGHLY_UNORDERED_TIMESTAMPS_TITLE, BarmanMessages.HIGHLY_UNORDERED_TIMESTAMPS_DESCRIPTION));
            }
            return addresses;
        }
    }

    @FunctionalInterface
    public static interface IEntryMapper<T> {
        public @NonNull T map(long var1, long var3, long var5, int var7);
    }
}

