/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.streamline.barman.BarmanSeekableDataInput;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barman.recordstream.IBarmanBlockLength;
import com.arm.streamline.barman.recordstream.IBarmanSeekableRecordStreamReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanGenericRecordStreamInput
implements IBarmanSeekableRecordStreamReader {
    private final @NonNull BarmanDataInput<?> dataInput;
    private final long initialOffset;

    public BarmanGenericRecordStreamInput(@NonNull BarmanDataInput<?> dataInput, @NonNull BarmanDataStoreParameters dataStoreParameters) throws IOException, BarmanDataError {
        this.dataInput = dataInput;
        this.initialOffset = dataInput.getOffset();
    }

    @Override
    public void close() throws IOException {
        this.dataInput.close();
    }

    @Override
    public long getFrameOffset() throws IOException {
        return this.dataInput.getOffset() - this.initialOffset;
    }

    @Override
    public @NonNull IBarmanBlockLength readBlockLength() throws IOException {
        long result = this.dataInput.readMachineWord();
        return this.dataInput.getMachineWordLength() == 8 ? new IBarmanBlockLength.EigthByte(result) : new IBarmanBlockLength.FourByte(result);
    }

    @Override
    public @NonNull ByteBuffer readBytes(int length) throws IOException {
        return this.dataInput.readBytes(length);
    }

    @Override
    public void seekFrame(long offset) throws IOException {
        if (!(this.dataInput instanceof BarmanSeekableDataInput)) {
            throw new AssertionError();
        }
        BarmanSeekableDataInput seekable = (BarmanSeekableDataInput)this.dataInput;
        seekable.seek(this.initialOffset + offset);
    }
}

