/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames.objects;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.streamline.barman.v1.BarmanWarningType;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WarningFrame
implements IBarmanSerializableFrame {
    private final int core;
    private final long timestamp;
    private final @NonNull BarmanWarningType type;

    public WarningFrame(long timestamp, int core, @NonNull BarmanWarningType type) {
        this.timestamp = timestamp;
        this.core = core;
        this.type = type;
    }

    public int getCore() {
        return this.core;
    }

    @Override
    public byte @Nullable [] getRawFrameData() {
        return null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public @Nullable Long getTimestampOverride() {
        return null;
    }

    public @NonNull BarmanWarningType getType() {
        return this.type;
    }

    @Override
    public byte @NonNull [] serializeRecord(@NonNull BarmanTypeAndVersion typeAndVersion) {
        ByteOrder byteOrder = typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int length = 20;
        ByteBuffer buffer = ByteBuffer.allocate(20).order(byteOrder);
        buffer.putInt(BarmanRecordType.WARNING.getValue());
        buffer.putInt(this.core);
        buffer.putLong(this.timestamp);
        buffer.putInt(this.type.getProtocolValue());
        return (byte[])NullChecking.neverNull((Object)buffer.array());
    }
}

