/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames.objects;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.frames.objects.SimpleFrame;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimestampedSimpleFrame
extends SimpleFrame {
    private final long timestamp;

    public TimestampedSimpleFrame(long timestamp, byte @NonNull [] data) {
        super(data);
        this.timestamp = timestamp;
    }

    @Override
    public byte @NonNull [] serializeRecord(BarmanTypeAndVersion typeAndVersion) {
        ByteOrder byteOrder = typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return (byte[])NullChecking.neverNull((Object)ByteBuffer.wrap(this.data).order(byteOrder).putLong(8, this.timestamp).array());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public @Nullable Long getTimestampOverride() {
        return this.timestamp;
    }
}

