/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.authentication;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.authentication.AuthenticationMessages;
import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.authentication.TargetAuthenticationConfig;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.AndroidRow;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import com.arm.streamline.deviceconn.adb.utils.AdbDeviceEnumeration;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.VariableResolver;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.TextField;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class TargetAuthenticationDialog
extends TitleAreaDialog
implements SelectionListener,
ISelectionChangedListener,
PaintListener {
    private TargetAuthenticationConfig mConfig;
    private Composite mContent;
    private Thread mAndroidBrowsingThread;
    private Button mAndroidRadio;
    private Outline<SimpleColumn> mAndroidChoices;
    private String mAndroidSelection;
    private Button mLinuxRadio;
    private TextField mLinuxAddressField;
    private TextField mLinuxUserNameField;
    private TextField mLinuxUserPasswordField;
    private TextField mLinuxRootPasswordField;
    private TextField mSetupScriptField;
    private TargetAuthentication mResult;
    private boolean mAllowTargetChange;

    private static TextField createField(Composite parent, String title, String tooltip, String initialValue, boolean isPassword, TextField.IFieldModifiedListener listener) {
        Label label = new Label(parent, 16384);
        label.setText(title);
        label.setToolTipText(tooltip);
        TextField field = new TextField(parent, isPassword ? 0x400000 : 0);
        field.setText(initialValue);
        field.setToolTipText(tooltip);
        field.addFieldModifiedListener(listener);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)field);
        return field;
    }

    public TargetAuthenticationDialog(TargetAuthentication authentication, TargetAuthenticationConfig config, boolean allowTargetChange) {
        super(WorkspaceUtils.getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mResult = authentication.clone();
        this.mConfig = config;
        this.mAllowTargetChange = allowTargetChange;
    }

    public boolean close() {
        this.mAndroidBrowsingThread.interrupt();
        return super.close();
    }

    public TargetAuthentication getResult() {
        return this.mResult;
    }

    public void paintControl(PaintEvent event) {
        if (this.mAndroidChoices.getModel().getRowCount() == 0) {
            GC gc = event.gc;
            Font font = Fonts.getNormalStandout();
            gc.setFont(font);
            gc.setForeground(Colors.getGray());
            Rectangle clientArea = this.mAndroidChoices.getClientArea();
            FontInfo fontInfo = FontInfo.get(font);
            Point size = fontInfo.getExtent(AuthenticationMessages.NO_ANDROID_DEVICES);
            TextDrawing.drawText(gc, AuthenticationMessages.NO_ANDROID_DEVICES, clientArea.x + clientArea.width / 2, clientArea.y + (clientArea.height - size.y) / 2, 0x1000000);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.adjustAcceptance();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.mAndroidRadio) {
            this.setAndroidFieldEnablement(true);
            this.setLinuxFieldEnablement(false);
            this.adjustAcceptance();
        } else if (widget == this.mLinuxRadio) {
            this.setAndroidFieldEnablement(false);
            this.setLinuxFieldEnablement(true);
            this.adjustAcceptance();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.mConfig.getDialogTitle());
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.getButton(0).setText(this.mConfig.getDialogOKButtonTitle());
        this.adjustAcceptance();
        return buttons;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.mConfig.getDialogTitle());
        this.setMessage(this.mConfig.getDialogMessage());
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        this.createAndroidPanel();
        this.createLinuxPanel();
        if (this.mConfig.showTargetSetupPath()) {
            this.createTargetSetupPathPanel();
        }
        boolean isAndroid = this.mResult.getAddress().android;
        this.setAndroidFieldEnablement(isAndroid);
        this.setLinuxFieldEnablement(!isAndroid);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, this.mConfig.getDialogHelpId());
        return this.mContent;
    }

    protected @Nullable File getPathToAdb() {
        return this.mConfig.getPathToAdb();
    }

    protected void okPressed() {
        if (this.mAndroidRadio.getSelection()) {
            this.mResult.setAddress(new CredentialsAddress(true, this.getAndroidAddress()));
        } else {
            this.mResult.setAddress(new CredentialsAddress(false, this.mLinuxAddressField.getText()));
            this.mResult.setUserName(this.mLinuxUserNameField.getText());
            this.mResult.setPassword(this.mLinuxUserPasswordField.getText());
            if (this.mConfig.showRootPasswordField()) {
                this.mResult.setRootPassword(this.mLinuxRootPasswordField.getText());
            }
        }
        if (this.mConfig.showTargetSetupPath()) {
            StreamlinePreferences.setTargetSetupScriptPath(this.mSetupScriptField.getText().trim());
        }
        super.okPressed();
    }

    protected void updateAndroidDevices(List<String> devices) {
        if (this.mAndroidChoices != null && !this.mAndroidChoices.isDisposed()) {
            HashSet<String> available = new HashSet<String>(devices);
            OutlineModel<SimpleColumn> model = this.mAndroidChoices.getModel();
            SimpleColumn column = (SimpleColumn)NullChecking.neverNull((Object)model.getColumnWithID(0));
            ArrayList<@NonNull AndroidRow> remove = new ArrayList<AndroidRow>();
            AndroidRow select = null;
            boolean isAndroid = this.mAndroidRadio.getSelection();
            for (AndroidRow androidRow : model.getRows()) {
                String device = androidRow.getDataAsText((SimpleColumn)column);
                if (available.contains(device)) {
                    available.remove(device);
                    if (!isAndroid || select != null || !this.mAndroidSelection.equals(device)) continue;
                    select = androidRow;
                    continue;
                }
                remove.add(androidRow);
            }
            if (!remove.isEmpty()) {
                model.removeRows(remove);
            }
            if (!available.isEmpty()) {
                for (String string : available) {
                    AndroidRow row = new AndroidRow(string);
                    model.addRow(row);
                    if (!isAndroid || select != null || !this.mAndroidSelection.equals(string)) continue;
                    select = row;
                }
            }
            column.setSortCriteria(0, true);
            model.sort();
            this.mAndroidChoices.sizeColumnsToFit();
            this.mAndroidChoices.adjustScrollBarsForContent();
            if (select != null) {
                model.select(select, false);
            } else {
                this.mAndroidSelection = "";
                model.deselect();
            }
            this.mAndroidChoices.redraw();
        }
    }

    private void adjustAcceptance() {
        String script;
        String msg = null;
        if (this.mAndroidRadio.getSelection()) {
            if (this.mAndroidChoices.getSelection().size() != 1) {
                msg = AuthenticationMessages.MUST_SELECT_ONE_DEVICE;
            } else {
                this.mAndroidSelection = this.getAndroidAddress();
            }
        } else if (this.mLinuxAddressField.getText().trim().isEmpty()) {
            msg = AuthenticationMessages.MUST_HAVE_ADDRESS;
        } else if (this.mLinuxUserNameField.getText().trim().isEmpty()) {
            msg = AuthenticationMessages.MUST_HAVE_USER_NAME;
        }
        if (msg == null && this.mConfig.showTargetSetupPath() && !(script = this.mSetupScriptField.getText().trim()).isEmpty() && !new File(script).isFile()) {
            msg = AuthenticationMessages.SCRIPT_MUST_EXIST;
        }
        this.setErrorMessage(msg);
        this.getButton(0).setEnabled(msg == null);
    }

    private void createAndroidPanel() {
        boolean isAndroid = this.mResult.getAddress().android;
        this.mAndroidRadio = this.createRadioButton(this.mContent, AuthenticationMessages.ANDROID, isAndroid);
        this.mAndroidSelection = isAndroid ? this.mResult.getAddress().address : "";
        BorderedComposite group = new BorderedComposite(this.mContent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).indent(20, 0).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().applyTo((Composite)group);
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.setShowOutline(false);
        SimpleColumn column = new SimpleColumn(0, "");
        column.setPrimary(true);
        column.setNoMaxWidth();
        column.setSortCriteria(0, true);
        model.addColumn(column);
        this.mAndroidChoices = new Outline(group, model, true, false);
        this.mAndroidChoices.setPermitDragSelect(false);
        this.mAndroidChoices.setAllowColumnResize(false);
        this.mAndroidChoices.setShowColumnLines(false);
        this.mAndroidChoices.addSelectionChangedListener(this);
        this.mAndroidChoices.addPaintListener(this);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(-1, 68).applyTo(this.mAndroidChoices);
        this.mAndroidBrowsingThread = new Thread(new Runnable(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        File pathToAdb = TargetAuthenticationDialog.this.getPathToAdb();
                        @NonNull @NonNull Set devices = pathToAdb != null ? AdbDeviceEnumeration.enumerate((IAdbProcessRunner)AdbRunnerFactory.SINGLETON.create(pathToAdb)) : Collections.emptySet();
                        final List serials = devices.stream().filter(d -> d.getState() == AdbDevice.AdbDeviceState.AVAILABLE).map(AdbDevice::getSerialNo).collect(Collectors.toList());
                        Task.callOnUIThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TargetAuthenticationDialog.this.updateAndroidDevices(serials);
                            }
                        });
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }, "Android Device Scanner");
        this.mAndroidBrowsingThread.start();
    }

    private void createLinuxPanel() {
        boolean isAndroid = this.mResult.getAddress().android;
        this.mLinuxRadio = this.createRadioButton(this.mContent, AuthenticationMessages.LINUX, !isAndroid);
        BorderedComposite group = new BorderedComposite(this.mContent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).indent(20, 0).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)group);
        this.mLinuxAddressField = TargetAuthenticationDialog.createField(group, AuthenticationMessages.ADDRESS, AuthenticationMessages.ADDRESS_TOOLTIP, isAndroid ? "" : this.mResult.getAddress().toString(), false, textField -> {
            CredentialsAddress address = new CredentialsAddress(false, textField.getText().trim());
            if (TargetAuthentication.isCached(address)) {
                TargetAuthentication fromCache = TargetAuthentication.getFromCache(address);
                assert (fromCache != null);
                this.mLinuxUserNameField.setText(fromCache.getUsername());
                this.mLinuxUserPasswordField.setText(fromCache.getPassword());
                if (this.mLinuxRootPasswordField != null) {
                    this.mLinuxRootPasswordField.setText(fromCache.getRootPassword());
                }
            }
            this.adjustAcceptance();
        });
        this.mLinuxUserNameField = TargetAuthenticationDialog.createField(group, AuthenticationMessages.USER_NAME, AuthenticationMessages.USER_NAME_TOOLTIP, isAndroid ? "" : this.mResult.getUsername(), false, textField -> this.adjustAcceptance());
        this.mLinuxUserPasswordField = TargetAuthenticationDialog.createField(group, AuthenticationMessages.USER_PASSWORD, AuthenticationMessages.USER_PASSWORD_TOOLTIP, isAndroid ? "" : this.mResult.getPassword(), true, textField -> this.adjustAcceptance());
        if (this.mConfig.showRootPasswordField()) {
            this.mLinuxRootPasswordField = TargetAuthenticationDialog.createField(group, AuthenticationMessages.ROOT_PASSWORD, AuthenticationMessages.ROOT_PASSWORD_TOOLTIP, isAndroid ? "" : this.mResult.getRootPassword(), true, textField -> this.adjustAcceptance());
        }
    }

    private Button createRadioButton(Composite parent, String title, boolean selected) {
        Button button = new Button(parent, 16);
        button.setSelection(selected);
        button.setText(title);
        button.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)button);
        return button;
    }

    private void createTargetSetupPathPanel() {
        Composite panel = new Composite(this.mContent, 0x20000000);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)panel);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(panel);
        Label label = new Label(panel, 16384);
        label.setText(AuthenticationMessages.SCRIPT);
        label.setToolTipText(AuthenticationMessages.SCRIPT_TOOLTIP);
        this.mSetupScriptField = new TextField(panel, StreamlinePlugin.getImage("Browse.png"));
        this.mSetupScriptField.setWatermark(StreamlinePlugin.getDefaultTargetSetupScriptPath());
        this.mSetupScriptField.setToolTipText(AuthenticationMessages.SCRIPT_TOOLTIP);
        this.mSetupScriptField.setImageToolTipText(AuthenticationMessages.BROWSE_SCRIPT_TOOLTIP);
        this.mSetupScriptField.setText(StreamlinePreferences.getTargetSetupScriptPath());
        this.mSetupScriptField.addClickListener(textField -> {
            FileDialog dialog = new FileDialog(this.getShell(), 69632);
            String path = VariableResolver.resolve(this.mSetupScriptField.getText().trim());
            if (path != null && path.length() > 0) {
                dialog.setFilterPath(FilePath.getParent((String)path));
                dialog.setFileName(FilePath.getLeafName((String)path));
            }
            dialog.setText(AuthenticationMessages.BROWSE_SCRIPT_TOOLTIP);
            path = dialog.open();
            if (path != null) {
                this.mSetupScriptField.setText(VariableResolver.reverseResolve(FilePath.getPathForPlatform((String)path.trim())));
            }
        });
        this.mSetupScriptField.addFieldModifiedListener(field -> this.adjustAcceptance());
        GridDataFactory.fillDefaults().minSize(50, -1).grab(true, false).applyTo((Control)this.mSetupScriptField);
    }

    private String getAndroidAddress() {
        OutlineModel<SimpleColumn> model = this.mAndroidChoices.getModel();
        @NonNull SimpleColumn column = (SimpleColumn)NullChecking.neverNull((Object)model.getColumnWithID(0));
        Row row = (Row)this.mAndroidChoices.getSelection().getFirstElement();
        return row.getDataAsText(column);
    }

    private void setAndroidFieldEnablement(boolean enabled) {
        this.mAndroidRadio.setEnabled(this.mAllowTargetChange);
        this.mAndroidRadio.setSelection(enabled);
        this.mAndroidChoices.setEnabled(enabled && this.mAllowTargetChange);
    }

    private void setLinuxFieldEnablement(boolean enabled) {
        this.mLinuxRadio.setEnabled(this.mAllowTargetChange);
        this.mLinuxRadio.setSelection(enabled);
        this.mLinuxAddressField.setEnabled(enabled && this.mAllowTargetChange);
        this.mLinuxUserNameField.setEnabled(enabled);
        this.mLinuxUserPasswordField.setEnabled(enabled);
        if (this.mConfig.showRootPasswordField()) {
            this.mLinuxRootPasswordField.setEnabled(enabled);
        }
    }
}

