/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.astf.xml;

import com.arm.streamline.astf.ASTFClusterInfo;
import com.arm.streamline.astf.ASTFCorenfo;
import com.arm.streamline.astf.xml.ASTFXml;
import com.arm.streamline.astf.xml.Messages;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ASTFXmlUtility {
    private static final @NonNull String TAG_ASTF = "astf-trace";
    private static final @NonNull String ATTR_CREATED_ON = "created-on";
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String ATTR_ID = "id";
    private static final @NonNull String TAG_CLUSTERS = "clusters";
    private static final @NonNull String TAG_CLUSTER = "cluster";
    private static final @NonNull String TAG_CORE = "core";
    private static final @NonNull String ATTR_CPU_ID = "cpuid";
    private static final @NonNull String TAG_DATA_FILES = "data-files";
    private static final @NonNull String TAG_DATA_FILE = "data-file";
    public static final @NonNull String ASTF_TRACE_XML = "astf-trace.xml";

    public static void save(@NonNull OutputStream stream, long createdOn, @NonNull String astfCapturepath, @NonNull List<@NonNull ASTFClusterInfo> clusters) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try (XMLGenerator xml = new XMLGenerator(stream);){
            xml.startDocument();
            xml.startTag(TAG_ASTF);
            xml.addAttribute(ATTR_CREATED_ON, createdOn);
            xml.addAttribute(ATTR_NAME, Paths.get(astfCapturepath, new String[0]).getFileName().toString());
            xml.startTag(TAG_CLUSTERS);
            for (ASTFClusterInfo cluster : clusters) {
                xml.startTag(TAG_CLUSTER);
                xml.addAttribute(ATTR_ID, cluster.getId());
                xml.addAttribute(ATTR_NAME, cluster.getName());
                int coreId = 0;
                for (ASTFCorenfo core : cluster.getCores()) {
                    xml.startTag(TAG_CORE);
                    xml.addAttribute(ATTR_ID, coreId++);
                    xml.addAttribute(ATTR_CPU_ID, core.getCpuId());
                    xml.addAttribute(ATTR_NAME, core.getName());
                    xml.startTag(TAG_DATA_FILES);
                    for (String filePath : core.getASTFDataFilePaths()) {
                        xml.startTag(TAG_DATA_FILE);
                        xml.addText(filePath);
                        xml.endTag();
                    }
                    xml.endTag();
                    xml.endTag();
                }
                xml.endTag();
            }
            xml.endTag();
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ASTFXml load(@NonNull XMLParser astfXmlParser) {
        long creationDate = -1L;
        String astfFolderName = null;
        @NonNull ArrayList<@NonNull ASTFClusterInfo> clusters = new ArrayList<ASTFClusterInfo>();
        try {
            String tag;
            while ((tag = astfXmlParser.nextTag()) != null) {
                if (!TAG_ASTF.equals(tag)) continue;
                if ((creationDate = astfXmlParser.getLongAttribute(ATTR_CREATED_ON, creationDate)) == -1L) {
                    CommonPlugin.error((String)Messages.Error_ASTF_CreatedOn);
                    return null;
                }
                if (astfXmlParser.hasAttribute(ATTR_NAME)) {
                    astfFolderName = astfXmlParser.getAttribute(ATTR_NAME);
                }
                if (astfFolderName == null) {
                    CommonPlugin.error((String)Messages.Error_ASTF_Name);
                    return null;
                }
                String clustesrMarker = astfXmlParser.getMarker();
                while ((tag = astfXmlParser.nextTag(clustesrMarker)) != null) {
                    ASTFClusterInfo astfClusterInfo = null;
                    if (!TAG_CLUSTERS.equals(tag)) continue;
                    String clusterMarker = astfXmlParser.getMarker();
                    while ((tag = astfXmlParser.nextTag(clusterMarker)) != null) {
                        if (!TAG_CLUSTER.equals(tag)) continue;
                        String clusterName = astfXmlParser.getAttribute(ATTR_NAME);
                        if (clusterName == null) {
                            CommonPlugin.error((String)Messages.Error_Cluster_Name);
                            return null;
                        }
                        int id = astfXmlParser.getIntegerAttribute(ATTR_ID);
                        astfClusterInfo = new ASTFClusterInfo(clusterName, id);
                        clusters.add(astfClusterInfo);
                        String coreMarkers = astfXmlParser.getMarker();
                        while ((tag = astfXmlParser.nextTag(coreMarkers)) != null) {
                            ASTFCorenfo coreinfo = null;
                            if (!TAG_CORE.equals(tag)) continue;
                            String coreName = astfXmlParser.getAttribute(ATTR_NAME);
                            if (coreName == null) {
                                CommonPlugin.error((String)Messages.Error_Core_Name);
                                return null;
                            }
                            String cpuId = astfXmlParser.getAttribute(ATTR_CPU_ID);
                            if (cpuId == null) {
                                CommonPlugin.error((String)Messages.Error_CPU_Id);
                                return null;
                            }
                            int coreId = astfXmlParser.getIntegerAttribute(ATTR_ID);
                            coreinfo = new ASTFCorenfo(coreName, coreId, cpuId);
                            String dataFilesMarker = astfXmlParser.getMarker();
                            while ((tag = astfXmlParser.nextTag(dataFilesMarker)) != null) {
                                if (!TAG_DATA_FILES.equals(tag)) continue;
                                String dataFileMarker = astfXmlParser.getMarker();
                                while ((tag = astfXmlParser.nextTag(dataFileMarker)) != null) {
                                    String text;
                                    if (!TAG_DATA_FILE.equals(tag) || (text = astfXmlParser.getText()) == null) continue;
                                    coreinfo.addAstfDataFile((String)NullChecking.neverNull((Object)text));
                                }
                            }
                            astfClusterInfo.addCore(coreinfo);
                        }
                    }
                }
            }
            return new ASTFXml(creationDate, (String)NullChecking.neverNull(astfFolderName), clusters);
        }
        catch (IOException e) {
            CommonPlugin.error((String)e.getMessage());
            return null;
        }
    }
}

