/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences.editors;

import com.arm.streamline.application.preferences.PreferencesMessages;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.List;

public class EditablePathEditor
extends PathEditor {
    private @Nullable Button editButton;

    public EditablePathEditor(String name, String labelText, String dirChooserLabelText, Composite parent) {
        super(name, labelText, dirChooserLabelText, parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        List list = this.getList();
        list.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                EditablePathEditor.this.editSelection();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Composite buttonBox = this.getButtonBoxControl(parent);
        Button editButton = new Button(buttonBox, 8);
        editButton.setText(PreferencesMessages.DATA_LOCATIONS_EDIT_DIR_LABEL);
        editButton.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)editButton, 61);
        data.widthHint = Math.max(widthHint, editButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        editButton.setLayoutData((Object)data);
        this.editButton = editButton;
        Control[] bbChildren = buttonBox.getChildren();
        assert (bbChildren.length > 0);
        assert (bbChildren[0] instanceof Button);
        editButton.moveBelow(bbChildren[0]);
        buttonBox.addDisposeListener(e -> {
            Button button = this.editButton = null;
        });
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditablePathEditor.this.editSelection();
            }
        });
        this.selectionChanged();
    }

    protected void editSelection() {
        String originalPath;
        String newPath;
        List list = this.getList();
        int selectionIndex = list.getSelectionIndex();
        if (selectionIndex >= 0 && (newPath = this.getEditPath(originalPath = (String)NullChecking.neverNull((Object)list.getItem(selectionIndex)))) != null) {
            list.setItem(selectionIndex, newPath);
        }
    }

    protected void selectionChanged() {
        super.selectionChanged();
        @Nullable Button editButton = this.editButton;
        if (editButton != null) {
            List list = this.getList();
            editButton.setEnabled(list.getSelectionIndex() >= 0);
        }
    }

    private @Nullable String getEditPath(@NonNull String currentValue) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setMessage(PreferencesMessages.DATA_LOCATIONS_SELECT_DIR_TITLE);
        dialog.setFilterPath(currentValue);
        return (String)NullChecking.applyIfNonNull((Object)dialog.open(), p -> !p.trim().isEmpty() ? p : null);
    }
}

