/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences;

import com.arm.streamline.application.preferences.PreferencesMessages;
import java.io.File;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MgdDirectoryEditor
extends DirectoryFieldEditor {
    public MgdDirectoryEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setErrorMessage(PreferencesMessages.MGD_DIRECTORY_ERROR);
    }

    public void setWatermark(String mark) {
        Text text = this.getTextControl();
        text.setMessage(mark);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, 2);
        Text text = this.getTextControl();
        GridData gd = (GridData)text.getLayoutData();
        gd.widthHint = 1;
    }

    protected boolean doCheckState() {
        return super.doCheckState() && this.isPathValid();
    }

    private boolean isPathValid() {
        String path = this.getTextControl().getText();
        if (path.trim().isEmpty()) {
            return true;
        }
        File file = new File(path);
        if (path.endsWith(".app")) {
            file = new File(file, "Contents/MacOS/aga");
            return file.exists();
        }
        return false;
    }
}

