/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.actions;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.actions.ActionsMessages;
import com.arm.streamline.barmancfg.BarmanGenerator;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanGeneratorWizard;
import com.arm.streamline.barmancfg.xml.BarmanConfigurationXML;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class BarmanGeneratorAction
extends Action {
    public static final String ID_NEW = "streamline.bare_metal.generate_action.new_agent";
    public static final String ID_OPEN = "streamline.bare_metal.generate_action.open_agent";
    private final boolean open;

    public BarmanGeneratorAction(boolean open) {
        this.setId(open ? ID_OPEN : ID_NEW);
        this.open = open;
    }

    public void run() {
        BarmanConfiguration configuration = null;
        File defaultOutputPath = null;
        @NonNull Shell shell = (Shell)NullChecking.neverNull((Object)WorkspaceUtils.getShell());
        if (this.open) {
            FileDialog dialog = new FileDialog(shell);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            dialog.setFilterNames(new String[]{ActionsMessages.ALL_XML_FILES});
            String file = dialog.open();
            if (file == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    configuration = BarmanConfigurationXML.parse(stream, EventsAndPmusXml.getPmus(null), msg -> StdLog.warn((Plugin)StreamlinePlugin.getInstance(), (String)msg));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)(ActionsMessages.COULD_NOT_GENERATE_BARMAN_FILES + exception.getMessage()), (Throwable)exception);
                MessageDialog msg2 = new MessageDialog(shell, ActionsMessages.BARMAN_FAILURE_TITLE, null, ActionsMessages.BARMAN_FAILURE_MESSAGE, 1, new String[]{ActionsMessages.BARMAN_FAILURE_OK}, 0);
                msg2.open();
                return;
            }
            defaultOutputPath = new File(file).getParentFile();
        }
        BarmanGeneratorWizard wizard = new BarmanGeneratorWizard(defaultOutputPath, configuration);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        int SIZE_X = 800;
        int SIZE_Y = 500;
        dialog.setMinimumPageSize(800, 500);
        dialog.setPageSize(800, 500);
        if (dialog.open() == 0) {
            BarmanConfiguration config = wizard.getBarmanConfiguration();
            File outputPath = (File)NullChecking.neverNull((Object)wizard.getOutputPath());
            try {
                BarmanGenerator.generateBarmanFiles(wizard.isGenerateSourceFiles(), wizard.isSaveConfigFile(), config, outputPath);
                MessageDialog msg3 = new MessageDialog(shell, ActionsMessages.BARMAN_SUCCESS_TITLE, null, ActionsMessages.BARMAN_SUCCESS_MESSAGE, 2, new String[]{ActionsMessages.BARMAN_SUCCESS_OK}, 0);
                msg3.open();
            }
            catch (IOException exception) {
                StdLog.error((Plugin)StreamlinePlugin.getInstance(), (String)("Could not generated barman files: " + exception.getMessage()), (Throwable)exception);
                MessageDialog msg4 = new MessageDialog(shell, ActionsMessages.BARMAN_FAILURE_TITLE, null, ActionsMessages.BARMAN_FAILURE_MESSAGE, 1, new String[]{ActionsMessages.BARMAN_FAILURE_OK}, 0);
                msg4.open();
            }
        }
    }
}

