/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.widget.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public enum StreamlineTheme {
    DARK(PluginMessages.THEME_DARK, -0.5f),
    LIGHT(PluginMessages.THEME_LIGHT, 0.1f);

    private RGB[] HEATMAPCOLORS_DARK;
    private RGB[] HEATMAPCOLORS_LIGHT;
    private String mDescription;
    private float mBrightnessAdjustment;

    public static final StreamlineTheme get(String key) {
        StreamlineTheme[] streamlineThemeArray = StreamlineTheme.values();
        int n = streamlineThemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StreamlineTheme one = streamlineThemeArray[n2];
            if (one.name().equalsIgnoreCase(key)) {
                return one;
            }
            ++n2;
        }
        return DARK;
    }

    private StreamlineTheme(String description, float brightnessAdjustment) {
        this.mDescription = description;
        this.mBrightnessAdjustment = brightnessAdjustment;
    }

    public final Color desaturate(Color color) {
        return Colors.create(this.desaturate(color.getRGB()));
    }

    public final RGB desaturate(RGB rgb) {
        RGB result = RGBUtils.adjust(rgb, 0.0f, -1.0f, this.mBrightnessAdjustment);
        if (this.mBrightnessAdjustment > 0.0f && result.red > 224) {
            result = new RGB(224, 224, 224);
        } else if (this.mBrightnessAdjustment < 0.0f && result.red < 64) {
            result = new RGB(64, 64, 64);
        }
        return result;
    }

    public final String getDescription() {
        return this.mDescription;
    }

    public final StreamlineTheme next() {
        StreamlineTheme[] values = StreamlineTheme.values();
        int i = this.ordinal() + 1;
        return values[i >= values.length ? 0 : i];
    }

    public RGB getHeatMapColor(int seriesIndex) {
        if (this.HEATMAPCOLORS_DARK == null) {
            this.HEATMAPCOLORS_DARK = new RGB[]{Colors.getGreen().getRGB(), Colors.getRed().getRGB(), Colors.getBlue().getRGB(), Colors.getYellow().getRGB(), Colors.getCyan().getRGB(), Colors.getMagenta().getRGB()};
        }
        if (this.HEATMAPCOLORS_LIGHT == null) {
            this.HEATMAPCOLORS_LIGHT = new RGB[]{Colors.getDarkGreen().getRGB(), Colors.getDarkRed().getRGB(), Colors.getDarkBlue().getRGB(), Colors.getDarkYellow().getRGB(), Colors.getDarkCyan().getRGB(), Colors.getDarkMagenta().getRGB()};
        }
        return this.mDescription.equals(PluginMessages.THEME_DARK) ? this.HEATMAPCOLORS_DARK[seriesIndex % this.HEATMAPCOLORS_DARK.length] : this.HEATMAPCOLORS_LIGHT[seriesIndex % this.HEATMAPCOLORS_LIGHT.length];
    }
}

