/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.actions.BarmanGeneratorAction;
import com.arm.streamline.application.actions.MemoryMonitorAction;
import com.arm.streamline.application.actions.ResetWindowAction;
import com.arm.streamline.application.actions.ShowPreferencesAction;
import com.arm.streamline.application.actions.ShowViewAction;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class StreamlineActionBarAdvisor
extends ActionBarAdvisor {
    public static final String MENU_PREFIX = "streamline.";
    public static final String GROUP_PREFIX = "group.";
    public static final String FILE_ID = "streamline.file";
    public static final String FILE_START_GROUP_ID = "group.streamline.filestart";
    public static final String FILE_END_GROUP_ID = "group.streamline.fileend";
    public static final String FILE_CLOSE_GROUP_ID = "group.close";
    public static final String FILE_QUIT_GROUP_ID = "group.quit";
    public static final String EDIT_ID = "edit";
    public static final String EDIT_START_GROUP_ID = "group.editstart";
    public static final String EDIT_END_GROUP_ID = "group.editend";
    public static final String EDIT_CLIPBOARD_GROUP_ID = "group.clipboard";
    public static final String EDIT_SELECTION_GROUP_ID = "group.selection";
    public static final String EDIT_PREFERENCES_GROUP_ID = "group.preferences";
    public static final String WINDOW_ID = "streamline.window";
    public static final String WINDOW_START_GROUP_ID = "group.streamline.windowstart";
    public static final String WINDOW_END_GROUP_ID = "group.streamline.windowend";
    public static final String WINDOW_VIEW_GROUP_ID = "group.views";
    public static final String HELP_ID = "streamline.help";
    public static final String HELP_START_GROUP_ID = "group.streamline.helpstart";
    public static final String HELP_END_GROUP_ID = "group.streamline.helpend";
    public static final String HELP_ABOUT_GROUP_ID = "group.about";
    public static final String HELP_HELP_GROUP_ID = "group.help";
    private ActionFactory.IWorkbenchAction mCloseAction;
    private ActionFactory.IWorkbenchAction mCloseAllAction;
    private ActionFactory.IWorkbenchAction mQuitAction;
    private ActionFactory.IWorkbenchAction mCutAction;
    private ActionFactory.IWorkbenchAction mCopyAction;
    private ActionFactory.IWorkbenchAction mPasteAction;
    private ActionFactory.IWorkbenchAction mDeleteAction;
    private ActionFactory.IWorkbenchAction mSelectAllAction;
    private ResetWindowAction mResetWindowAction;
    private MemoryMonitorAction mMemoryMonitorAction;
    private ActionFactory.IWorkbenchAction mAboutAction;
    private ActionFactory.IWorkbenchAction mHelpContentsAction;
    private ActionFactory.IWorkbenchAction mHelpSearchAction;
    private ActionFactory.IWorkbenchAction mDynamicHelpAction;
    private ActionFactory.IWorkbenchAction mImportAction;
    public static @NonNull Map<@NonNull String, @NonNull IAction> ACTION_MAP_INSTANCE = new HashMap<String, IAction>();

    static {
        StreamlineActionBarAdvisor.registerAction((IAction)new BarmanGeneratorAction(false));
        StreamlineActionBarAdvisor.registerAction((IAction)new BarmanGeneratorAction(true));
    }

    public static void registerAction(@NonNull IAction action) {
        @NonNull String id = (String)NullChecking.neverNull((Object)action.getId());
        ACTION_MAP_INSTANCE.put(id, action);
    }

    public StreamlineActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    public MemoryMonitorAction getMemoryMonitorAction() {
        return this.mMemoryMonitorAction;
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.mCloseAction = this.create(window, ActionFactory.CLOSE);
        this.mCloseAllAction = this.create(window, ActionFactory.CLOSE_ALL);
        this.mImportAction = this.create(window, ActionFactory.IMPORT);
        this.mQuitAction = this.create(window, ActionFactory.QUIT);
        this.mCutAction = this.create(window, ActionFactory.CUT);
        this.mCopyAction = this.create(window, ActionFactory.COPY);
        this.mPasteAction = this.create(window, ActionFactory.PASTE);
        this.mDeleteAction = this.create(window, ActionFactory.DELETE);
        this.mSelectAllAction = this.create(window, ActionFactory.SELECT_ALL);
        this.mMemoryMonitorAction = new MemoryMonitorAction();
        this.mResetWindowAction = new ResetWindowAction(window);
        this.mAboutAction = this.create(window, ActionFactory.ABOUT);
        this.mHelpContentsAction = this.create(window, ActionFactory.HELP_CONTENTS);
        this.mHelpSearchAction = this.create(window, ActionFactory.HELP_SEARCH);
        this.mDynamicHelpAction = this.create(window, ActionFactory.DYNAMIC_HELP);
    }

    private ActionFactory.IWorkbenchAction create(IWorkbenchWindow window, ActionFactory factory) {
        ActionFactory.IWorkbenchAction action = factory.create(window);
        this.register((IAction)action);
        return action;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(PluginMessages.EDIT, EDIT_ID);
        menu.add((IContributionItem)new GroupMarker(EDIT_START_GROUP_ID));
        menu.add((IContributionItem)new Separator(EDIT_CLIPBOARD_GROUP_ID));
        menu.add((IAction)this.mCutAction);
        menu.add((IAction)this.mCopyAction);
        menu.add((IAction)this.mPasteAction);
        menu.add((IContributionItem)new Separator(EDIT_SELECTION_GROUP_ID));
        menu.add((IAction)this.mDeleteAction);
        menu.add((IAction)this.mSelectAllAction);
        menu.add((IContributionItem)new GroupMarker(EDIT_END_GROUP_ID));
        return menu;
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(PluginMessages.FILE, FILE_ID);
        menu.add((IContributionItem)new GroupMarker(FILE_START_GROUP_ID));
        menu.add((IContributionItem)new Separator(FILE_CLOSE_GROUP_ID));
        menu.add((IAction)this.mCloseAction);
        menu.add((IAction)this.mCloseAllAction);
        menu.add((IAction)this.mImportAction);
        if (!Platform.isMacintosh()) {
            menu.add((IContributionItem)new Separator(FILE_QUIT_GROUP_ID));
            menu.add((IAction)this.mQuitAction);
        }
        menu.add((IContributionItem)new GroupMarker(FILE_END_GROUP_ID));
        return menu;
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(PluginMessages.HELP, HELP_ID);
        menu.add((IContributionItem)new GroupMarker(HELP_START_GROUP_ID));
        if (!Platform.isMacintosh()) {
            menu.add((IContributionItem)new Separator(HELP_ABOUT_GROUP_ID));
            menu.add((IAction)this.mAboutAction);
        }
        menu.add((IContributionItem)new Separator(HELP_HELP_GROUP_ID));
        menu.add((IAction)this.mHelpContentsAction);
        menu.add((IAction)this.mHelpSearchAction);
        menu.add((IAction)this.mDynamicHelpAction);
        menu.add((IContributionItem)new GroupMarker(HELP_END_GROUP_ID));
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(PluginMessages.WINDOW, WINDOW_ID);
        menu.add((IContributionItem)new GroupMarker(WINDOW_START_GROUP_ID));
        menu.add((IAction)this.mResetWindowAction);
        menu.add((IContributionItem)new Separator(WINDOW_VIEW_GROUP_ID));
        menu.add((IAction)new ShowViewAction("org.eclipse.pde.runtime.LogView"));
        menu.add((IAction)new ShowViewAction("org.eclipse.ui.views.ProgressView"));
        menu.add((IAction)this.mMemoryMonitorAction);
        menu.add((IContributionItem)new Separator(EDIT_PREFERENCES_GROUP_ID));
        menu.add((IAction)new ShowPreferencesAction());
        menu.add((IContributionItem)new GroupMarker(WINDOW_END_GROUP_ID));
        return menu;
    }
}

