/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlineWorkbenchWindowAdvisor;
import com.arm.streamline.application.preferences.MainPreferencePage;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.cmdline.CmdLine;
import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.hacks.FixWin32MouseBehavior;
import com.arm.utils.NullChecking;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.wizards.ImportWizardRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class Streamline
extends WorkbenchAdvisor
implements IApplication {
    public static @Nullable Job scheduledJob = null;
    private boolean mNeedShutdown;

    private static void removeAllNonStreamlineImportItems() {
        ImportWizardRegistry wizardRegistry = (ImportWizardRegistry)PlatformUI.getWorkbench().getImportWizardRegistry();
        Streamline.removeAllNonStreamlineImportItemsInCategory(wizardRegistry, wizardRegistry.getRootCategory());
    }

    private static void removeAllNonStreamlineImportItemsInCategory(ImportWizardRegistry registry, IWizardCategory category) {
        if (!category.getId().startsWith("com.arm.streamline")) {
            IWizardDescriptor[] wizards;
            int n;
            IWizardCategory[] children = category.getCategories();
            if (children != null) {
                IWizardCategory[] iWizardCategoryArray = children;
                n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardCategory child = iWizardCategoryArray[n2];
                    Streamline.removeAllNonStreamlineImportItemsInCategory(registry, child);
                    ++n2;
                }
            }
            if ((wizards = category.getWizards()) != null) {
                IWizardDescriptor[] iWizardDescriptorArray = wizards;
                int n3 = wizards.length;
                n = 0;
                while (n < n3) {
                    IWizardDescriptor wizard = iWizardDescriptorArray[n];
                    WorkbenchWizardElement element = (WorkbenchWizardElement)wizard;
                    registry.removeExtension(element.getConfigurationElement().getDeclaringExtension(), new Object[]{element});
                    ++n;
                }
            }
        }
    }

    private static void removeAllNonStreamlinePreferencePages() {
        @NonNull IWorkbench currentWorkBench = (IWorkbench)NullChecking.neverNull((Object)PlatformUI.getWorkbench());
        @NonNull PreferenceManager manager = (PreferenceManager)NullChecking.neverNull((Object)currentWorkBench.getPreferenceManager());
        @NonNull List nodes = (List)NullChecking.neverNull((Object)manager.getElements(0));
        for (IPreferenceNode node : nodes) {
            String nodeId;
            if (node == null || (nodeId = (String)NullChecking.neverNull((Object)node.getId())).equals(MainPreferencePage.ID)) continue;
            manager.remove(node);
        }
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new StreamlineWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "streamline.perspective";
    }

    public String getMainPreferencePageId() {
        return MainPreferencePage.ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        super.initialize(configurer);
    }

    public void postStartup() {
        Streamline.removeAllNonStreamlinePreferencePages();
        Streamline.removeAllNonStreamlineImportItems();
        if (scheduledJob != null) {
            scheduledJob.schedule();
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args;
        StreamlinePreferences.watchNewNativeBackendProperty(AnalysisDatabaseFactory::updateDBV3EnableFlag);
        Integer result = null;
        boolean isWindowsGui = "true".equals(System.getProperty("streamline.iswindowsgui"));
        if (!isWindowsGui && (result = CmdLine.processCommandLine(args = (String[])NullChecking.neverNull((Object[])((String[])context.getArguments().get("application.args"))))) != null && result != IApplication.EXIT_OK) {
            System.setProperty("eclipse.exitdata", "");
        }
        if (result == null) {
            result = IApplication.EXIT_OK;
            this.mNeedShutdown = true;
            Display.setAppName((String)PluginMessages.TITLE);
            Display display = PlatformUI.createDisplay();
            if ("root".equals(System.getProperty("user.name"))) {
                MessageBox msgBox = new MessageBox(new Shell(display), 1);
                msgBox.setMessage(CmdLineMessages.NOT_ROOT);
                msgBox.open();
                return CmdLine.setError(CmdLineMessages.NOT_ROOT);
            }
            FixWin32MouseBehavior.install(display);
            try {
                if (PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)this) == 1) {
                    result = IApplication.EXIT_RESTART;
                }
            }
            finally {
                display.dispose();
            }
        }
        return result;
    }

    public void stop() {
        if (this.mNeedShutdown && PlatformUI.isWorkbenchRunning()) {
            this.mNeedShutdown = false;
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.syncExec(() -> {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            });
        }
    }
}

