/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.utils.NullChecking;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PluginVersion {
    private final @NonNull String mBuildIdentifier;
    private final @NonNull String mCopyrightYears;
    private final @NonNull String mLocalizedBanner;
    private final @NonNull String mLocalizedFormatted;
    private final @NonNull String mName;
    private final @NonNull String mVendor;
    private final @NonNull String mVersion;

    public PluginVersion(Plugin plugin) {
        String buildVersion;
        String primaryVersion;
        Bundle pluginBundle = plugin.getBundle();
        Dictionary dict = pluginBundle.getHeaders();
        Version bundleVersion = pluginBundle.getVersion();
        this.mName = (String)NullChecking.neverNull((Object)((String)dict.get("Bundle-Name")));
        this.mCopyrightYears = (String)NullChecking.neverNull((Object)((String)dict.get("Copyright-Years")));
        this.mVendor = (String)NullChecking.neverNull((Object)((String)dict.get("Bundle-Vendor")));
        if (bundleVersion != null) {
            block17: {
                int major = bundleVersion.getMajor();
                int minor = bundleVersion.getMinor();
                int micro = bundleVersion.getMicro();
                String qualifier = bundleVersion.getQualifier();
                primaryVersion = micro != 0 ? String.format("%d.%d.%d", major, minor, micro) : String.format("%d.%d", major, minor);
                if (major == 0 && minor == 0 || qualifier != null && "qualifier".equals(qualifier)) {
                    buildVersion = "Development";
                    try {
                        Throwable throwable = null;
                        Object var12_15 = null;
                        try (@Nullable InputStream pluginResource = StreamlinePlugin.class.getResourceAsStream("/plugin.properties");){
                            String devBuildDate;
                            if (pluginResource == null) break block17;
                            Properties pluginProps = new Properties();
                            pluginProps.load(pluginResource);
                            String devPrimaryVersion = pluginProps.getProperty("dev_build_version");
                            if (devPrimaryVersion != null) {
                                primaryVersion = devPrimaryVersion;
                            }
                            if ((devBuildDate = pluginProps.getProperty("dev_build_date")) != null) {
                                buildVersion = devBuildDate;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Exception when trying to grab dev build number from plugin.properties");
                        exception.printStackTrace();
                    }
                } else {
                    @NonNull String suffix = qualifier != null && !qualifier.trim().isEmpty() ? String.format(".%s", qualifier) : "";
                    buildVersion = suffix.matches(".+-g[0-9a-f]+.*$") ? "Development" : String.format("%d.%d.%d%s", major, minor, micro, suffix);
                }
            }
            this.mVersion = primaryVersion;
        } else {
            this.mVersion = "Unknown";
            primaryVersion = PluginMessages.UNKNOWN;
            buildVersion = "Unknown";
        }
        this.mBuildIdentifier = String.format("Build %s", buildVersion);
        this.mLocalizedFormatted = MessageFormat.format("{0} ({1})", primaryVersion, MessageFormat.format(PluginMessages.BUILD_FORMAT, buildVersion));
        this.mLocalizedBanner = MessageFormat.format(PluginMessages.BANNER_FORMAT, this.mName, this.mLocalizedFormatted, this.mCopyrightYears, this.mVendor);
    }

    public final @NonNull String getBuildIdentifier() {
        return this.mBuildIdentifier;
    }

    public final @NonNull String getCopyrightYears() {
        return this.mCopyrightYears;
    }

    public final @NonNull String getLocalizedBanner() {
        return this.mLocalizedBanner;
    }

    public final @NonNull String getLocalizedFormatted() {
        return this.mLocalizedFormatted;
    }

    public final @NonNull String getName() {
        return this.mName;
    }

    public final @NonNull String getVendor() {
        return this.mVendor;
    }

    public final @NonNull String getVersionIdentifier() {
        return this.mVersion;
    }
}

