/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.session;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.report.model.ResolutionMode;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class SessionSettings {
    private long mDurationInNanosecs;
    private final @NonNull String mInput;
    private final @NonNull String mOutput;
    private final @NonNull ResolutionMode mResolutionMode;

    private static int @NonNull [] toScales(@NonNull ZoomLevel @NonNull [] scales) {
        int[] result = Arrays.stream(scales).mapToInt(ZoomLevel::getBps).toArray();
        Arrays.sort(result);
        int halfN = result.length / 2;
        int i = 0;
        int j = result.length - 1;
        while (i < halfN) {
            int tmp = result[i];
            result[i] = result[j];
            result[j] = tmp;
            ++i;
            --j;
        }
        return result;
    }

    public SessionSettings(@NonNull String input, @NonNull String output, @NonNull ResolutionMode resolutionMode) {
        this.mInput = input;
        this.mOutput = output;
        this.mResolutionMode = resolutionMode;
    }

    public long getDurationInNanosecs() {
        return this.mDurationInNanosecs;
    }

    public @NonNull String getInputPath() {
        return this.mInput;
    }

    public @NonNull ResolutionMode getResolutionMode() {
        return this.mResolutionMode;
    }

    public int @NonNull [] getTicksPerScale() {
        int @NonNull [] scale = this.getTimeScale();
        int largest = scale[0];
        int n = 0;
        while (n < scale.length) {
            assert (largest % scale[n] == 0) : String.format("largest=%d, scale=%d", largest, scale[n]);
            scale[n] = largest / scale[n];
            ++n;
        }
        return scale;
    }

    public @NonNull String getOutputPath() {
        return this.mOutput;
    }

    public String getOutputPathCounters() {
        return this.getOutputPath() + "/timeline/counters";
    }

    public String getOutputPathFocus() {
        return this.getOutputPath() + "/timeline/focus/";
    }

    public int getDensestBinsPerSecond() {
        return this.mResolutionMode.toDensestZoomLevel().getBps();
    }

    public long getNanosecondsPerDensestBin() {
        return this.mResolutionMode.toDensestZoomLevel().convertBinToNanoseconds(1L);
    }

    public int @NonNull [] getTimeScale() {
        return SessionSettings.toScales(this.mResolutionMode.toZoomLevels());
    }

    public void setDurationInNanosecs(long duration) {
        this.mDurationInNanosecs = duration;
    }
}

