/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.shared.io.IndexDataFile;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;

public class ThreadWaitEntry {
    private static final int DISCARD_ID = -1;
    private int[] mCurrentlyActiveUID;
    private final int mTickLimit;
    private int mTickCount;
    private long mAddTime;
    private long mTotalTime;
    private long mActiveTime;
    private long mUnusedTime;
    private int mReasonCode;
    private final @NonNull TIntSet mIdleUtids;
    private TIntLongHashMap mInfo;
    private TIntHashSet mReason;
    private TIntHashSet mRemove;
    private IndexDataFile mIndexDataFile;
    private boolean mOutput1;
    private boolean mOutput2;
    private boolean mEverWritten;

    public ThreadWaitEntry(int cores, String path, int limit, int reasonCode, @NonNull TIntSet idleUtids) throws IOException {
        this.mTickCount = this.mTickLimit = limit;
        this.mIndexDataFile = new IndexDataFile(path);
        this.mCurrentlyActiveUID = new int[cores];
        this.mInfo = new TIntLongHashMap();
        this.mReason = new TIntHashSet();
        this.mRemove = new TIntHashSet();
        this.mReasonCode = reasonCode;
        this.mIdleUtids = idleUtids;
        int i = 0;
        while (i < this.mCurrentlyActiveUID.length) {
            this.mCurrentlyActiveUID[i] = -1;
            ++i;
        }
    }

    public void addTime(long time) {
        int size = this.mReason.size();
        this.mAddTime += time;
        this.mTotalTime += time;
        this.mActiveTime += (long)size * time;
        if (size == 0) {
            this.mUnusedTime += time;
        }
    }

    public void close() throws IOException {
        this.mIndexDataFile.close();
    }

    public boolean hasData() {
        return this.mTickCount != this.mTickLimit;
    }

    public void output() throws IOException {
        if (this.mOutput2) {
            this.mOutput2 = this.mOutput1;
            this.mOutput1 = false;
            long totalTime = this.mTotalTime;
            long activeTime = this.mActiveTime;
            long unusedTime = this.mUnusedTime;
            long total = 0L;
            float percentage = (float)(totalTime - unusedTime) / (float)totalTime;
            this.mUnusedTime = 0L;
            this.mActiveTime = 0L;
            this.mTotalTime = 0L;
            this.commitTime();
            TIntLongIterator it = this.mInfo.iterator();
            while (it.hasNext()) {
                it.advance();
                int key = it.key();
                long value = it.value();
                if (value <= 0L) continue;
                float time = 10000.0f * percentage * (float)value / (float)activeTime;
                int calc = (int)time;
                if (time > 0.0f && calc == 0) {
                    calc = 1;
                } else if (time < 0.0f) {
                    calc = 0;
                }
                value = calc;
                this.mInfo.put(key, value);
                total += value;
            }
            if (unusedTime == 0L && total != 10000L) {
                int maxKey = -1;
                long maxValue = 0L;
                it = this.mInfo.iterator();
                while (it.hasNext()) {
                    it.advance();
                    int key = it.key();
                    long value = it.value();
                    if (value <= maxValue) continue;
                    maxKey = key;
                    maxValue = value;
                }
                if (maxKey >= 0) {
                    this.mInfo.adjustOrPutValue(maxKey, 10000L - total, 0L);
                }
            }
            boolean written = false;
            it = this.mInfo.iterator();
            while (it.hasNext()) {
                it.advance();
                int key = it.key();
                long value = it.value();
                if (value <= 0L) continue;
                this.mInfo.put(key, 0L);
                Compression.packInt((long)key, (OutputStream)this.mIndexDataFile);
                Compression.packInt((long)0L, (OutputStream)this.mIndexDataFile);
                Compression.packInt((long)value, (OutputStream)this.mIndexDataFile);
                written = true;
                this.mEverWritten = true;
            }
            if (!written && this.mEverWritten) {
                Compression.packInt((long)-1L, (OutputStream)this.mIndexDataFile);
                Compression.packInt((long)0L, (OutputStream)this.mIndexDataFile);
                Compression.packInt((long)0L, (OutputStream)this.mIndexDataFile);
            }
            if (!this.mRemove.isEmpty()) {
                TIntIterator ir = this.mRemove.iterator();
                while (ir.hasNext()) {
                    this.mInfo.remove(ir.next());
                }
                this.mRemove.clear();
            }
        } else {
            this.mUnusedTime = 0L;
            this.mActiveTime = 0L;
            this.mTotalTime = 0L;
            this.mAddTime = 0L;
            TIntLongIterator it = this.mInfo.iterator();
            while (it.hasNext()) {
                it.advance();
                int key = it.key();
                long value = it.value();
                if (value <= 0L) continue;
                this.mInfo.put(key, 0L);
            }
        }
        this.mIndexDataFile.writeIndex();
    }

    public boolean process() {
        if (--this.mTickCount > 0) {
            return false;
        }
        this.mTickCount = this.mTickLimit;
        return true;
    }

    public void threadFree(@NonNull OptionalInt oId) {
        int id = oId.orElse(-1);
        this.commitTime();
        this.mOutput2 = true;
        this.mOutput1 = true;
        this.mRemove.add(id);
        this.mReason.remove(id);
        int i = 0;
        while (i < this.mCurrentlyActiveUID.length) {
            if (this.mCurrentlyActiveUID[i] == id) {
                this.mCurrentlyActiveUID[i] = -1;
            }
            ++i;
        }
    }

    public void threadStop(int core) {
        this.commitTime();
        this.mOutput2 = true;
        this.mOutput1 = true;
        this.mReason.remove(this.mCurrentlyActiveUID[core]);
        this.mCurrentlyActiveUID[core] = -1;
    }

    public void threadSwitch(int core, int reason, @NonNull OptionalInt oId) {
        int id = oId.orElse(-1);
        int previouslyRunningTID = this.mCurrentlyActiveUID[core];
        this.commitTime();
        if (previouslyRunningTID >= 0 && !this.mIdleUtids.contains(previouslyRunningTID)) {
            if (reason == this.mReasonCode) {
                this.mOutput2 = true;
                this.mOutput1 = true;
                this.mReason.add(previouslyRunningTID);
            } else if (this.mReason.contains(previouslyRunningTID)) {
                this.mOutput2 = true;
                this.mOutput1 = true;
                this.mReason.remove(previouslyRunningTID);
            }
        }
        if (this.mReason.contains(id)) {
            this.mOutput2 = true;
            this.mOutput1 = true;
            this.mReason.remove(id);
        }
        this.mCurrentlyActiveUID[core] = id;
    }

    private void commitTime() {
        if (this.mAddTime != 0L) {
            long time = this.mAddTime;
            this.mAddTime = 0L;
            if (!this.mReason.isEmpty()) {
                for (int key : this.mReason) {
                    this.mInfo.adjustOrPutValue(key, time, time);
                }
            }
        }
    }
}

