/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.processor.timeline.ThreadWaitEntry;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.CounterRecordFile;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ThreadWait
extends AnalysisBase {
    public static final String CPU_WAIT_CONENTION_TYPE = "Linux_cpu_wait_contention";
    public static final String CPU_WAIT_IO_TYPE = "Linux_cpu_wait_io";
    public static final String CPU_WAIT_STRING = "_Wait_";
    private static final String[] mReasonCodeToType = new String[]{"", "Linux_cpu_wait_contention", "Linux_cpu_wait_io"};
    private final String mOutputPath;
    private final @NonNull TIntSet mIdleUtids;
    private final int[] mTicksPerScale;
    private final int[] mTimeScale;
    private ThreadWaitEntry[] mEntries;
    private long mLastTime;
    private final long mTimebase;
    private final int mReasonCode;
    private final boolean mDerived;
    private final ICaptureDetails mCaptureDetails;
    private final long mDuration;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream activityStream;

    public ThreadWait(String source, SessionSettings settings, @NonNull SessionProcessor sp, ICaptureDetails captureDetails, int reasonCode, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream activityStream) {
        super(sp);
        this.activityStream = activityStream;
        this.mIdleUtids = ((IUniqueIds)NullChecking.neverNull((Object)sp.getUniqueIds())).getIdleUIDSet();
        this.mDuration = settings.getDurationInNanosecs();
        this.progress(0);
        this.mDerived = captureDetails.hasDerivedCounterOfType(mReasonCodeToType[reasonCode]);
        if (this.mDerived) {
            this.mOutputPath = settings.getOutputPathCounters() + "/" + source + CPU_WAIT_STRING + Integer.valueOf(reasonCode).toString();
            this.mCaptureDetails = captureDetails;
            this.mTimebase = settings.getNanosecondsPerDensestBin();
            this.mTicksPerScale = settings.getTicksPerScale();
            this.mTimeScale = settings.getTimeScale();
            this.mReasonCode = reasonCode;
            this.setName(String.format("Trace[%s][%d]", source, reasonCode), settings.getInputPath(), settings.getOutputPath());
            this.setPriorityLower();
            this.start();
        } else {
            this.mOutputPath = null;
            this.mCaptureDetails = null;
            this.mTimebase = 0L;
            this.mTicksPerScale = null;
            this.mTimeScale = null;
            this.mReasonCode = 0;
        }
    }

    @Override
    public void close() {
        if (this.mEntries != null) {
            ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
            int n = this.mEntries.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    ThreadWaitEntry entry = threadWaitEntryArray[n2];
                    try {
                        try {
                            if (entry.hasData()) {
                                entry.output();
                            }
                        }
                        catch (IOException e) {
                            this.error(e);
                            try {
                                entry.close();
                            }
                            catch (IOException e2) {
                                this.error(e2);
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            entry.close();
                        }
                        catch (IOException e) {
                            this.error(e);
                        }
                        throw throwable;
                    }
                    try {
                        entry.close();
                    }
                    catch (IOException e) {
                        this.error(e);
                    }
                }
                ++n2;
            }
            this.mEntries = null;
        }
    }

    @Override
    protected void process() {
        try {
            try {
                CommonFileUtils.makeDirectory((String)this.mOutputPath);
                Throwable throwable = null;
                Object var2_4 = null;
                try (IAnalysisActivityReader eventsReader = this.activityStream.createReader();){
                    IAnalysisActivityReader.IValue eventValue;
                    int channelCount = eventsReader.getChannels().size();
                    try {
                        CounterRecord cr = (CounterRecord)NullChecking.neverNull((Object)this.mCaptureDetails.getDerivedCounter(mReasonCodeToType[this.mReasonCode]));
                        CounterRecordFile.writeCounterRecord((File)new File(this.mOutputPath), (CounterRecord)cr, (int)1);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                    this.mEntries = new ThreadWaitEntry[this.mTimeScale.length];
                    int i = 0;
                    while (i < this.mTimeScale.length) {
                        this.mEntries[i] = new ThreadWaitEntry(channelCount, this.mOutputPath + String.format("/average_%d.bin", this.mTimeScale[i]), this.mTicksPerScale[i], this.mReasonCode, this.mIdleUtids);
                        ++i;
                    }
                    while (!this.isInterrupted() && (eventValue = (IAnalysisActivityReader.IValue)eventsReader.read()) != null) {
                        final long time = eventValue.getTimestamp();
                        this.progress((int)(100L * time / this.mDuration));
                        if (time > this.mDuration) {
                            break;
                        }
                        final int channelIndex = eventValue.getChannelIndex();
                        assert (channelIndex >= 0);
                        eventValue.accept((IAnalysisActivityReader.IValueVisitor)new IAnalysisActivityReader.IValueVisitor<ProcessingElementReference>(){

                            public boolean free(long timestamp, int utid) throws IOException {
                                ThreadWait.this.threadFree(time, OptionalInt.of(utid));
                                return false;
                            }

                            public boolean stop(@NonNull ProcessingElementReference channel, long timestamp, int state) throws IOException {
                                ThreadWait.this.threadStop(time, channelIndex);
                                return false;
                            }

                            public boolean swtch(@NonNull ProcessingElementReference channel, long timestamp, @Nullable Integer utid, int activity, int state) throws IOException {
                                ThreadWait.this.threadSwitch(time, channelIndex, state, OptionalUtils.ofInteger((Integer)utid));
                                return false;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.error(e);
                this.progress(100);
            }
        }
        finally {
            this.progress(100);
        }
    }

    private void addTime(long time) throws IOException {
        if (this.mLastTime < time) {
            int timeTick = (int)(time / this.mTimebase);
            int lastTick = (int)(this.mLastTime / this.mTimebase);
            while (lastTick < timeTick) {
                long scanTime = (long)(++lastTick) * this.mTimebase;
                long deltaTime = scanTime - this.mLastTime;
                this.mLastTime = scanTime;
                ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
                int n = this.mEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    ThreadWaitEntry entry = threadWaitEntryArray[n2];
                    entry.addTime(deltaTime);
                    if (entry.process()) {
                        entry.output();
                    }
                    ++n2;
                }
            }
            long deltaTime = time - this.mLastTime;
            this.mLastTime = time;
            ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
            int n = this.mEntries.length;
            int n3 = 0;
            while (n3 < n) {
                ThreadWaitEntry entry = threadWaitEntryArray[n3];
                entry.addTime(deltaTime);
                ++n3;
            }
        }
    }

    protected final void threadFree(long time, @NonNull OptionalInt utid) throws IOException {
        this.addTime(time);
        ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
        int n = this.mEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadWaitEntry entry = threadWaitEntryArray[n2];
            entry.threadFree(utid);
            ++n2;
        }
    }

    protected final void threadStop(long time, int core) throws IOException {
        this.addTime(time);
        ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
        int n = this.mEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadWaitEntry entry = threadWaitEntryArray[n2];
            entry.threadStop(core);
            ++n2;
        }
    }

    protected final void threadSwitch(long time, int core, int reason, @NonNull OptionalInt utid) throws IOException {
        this.addTime(time);
        ThreadWaitEntry[] threadWaitEntryArray = this.mEntries;
        int n = this.mEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadWaitEntry entry = threadWaitEntryArray[n2];
            entry.threadSwitch(core, reason, utid);
            ++n2;
        }
    }
}

