/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.processing.binning.AnalysisAbsoluteBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.AnalysisDeltaBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.AnalysisIncidentBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisHardwareCounterSupplier;
import com.arm.streamline.analysis.processing.binning.PerThreadPersistantBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.WritingBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.zoomlevelgeneration.BaseZoomLevelGenerator;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.api.write.counters.IReportBinnedCounterWriter;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import com.arm.utils.text.BasicTextFilter;
import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LegacyBaseZoomLevelGeneratorFactory {
    private final @NonNull BinningDataMode @NonNull [] binningDataModes;
    private final long @NonNull [] channelExitTimes;
    private final int mChannelCount;
    private final @NonNull CounterRecord mCounterRecord;
    private final long mDuration;
    private final @NonNull SessionSettings mSettings;
    private final long mTimebase;
    private final boolean persist;
    private final @NonNull IReportWriterFactory reportWriterFactory;
    private final @NonNull UniqueThread @NonNull [] threadsByExitTime;

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor mapProcessor(@NonNull CounterRecord counterRecord, int channelCount) {
        switch (counterRecord.getCounterClass()) {
            case ABSOLUTE: 
            case CONSTANT: {
                return new AnalysisAbsoluteBinningThreadCounterReader.Processor();
            }
            case DELTA: {
                return new AnalysisDeltaBinningThreadCounterReader.Processor(channelCount);
            }
            case INCIDENT: 
            case ACTIVITY: {
                return new AnalysisIncidentBinningThreadCounterReader.Processor(channelCount);
            }
        }
        throw new AssertionError(counterRecord.getCounterClass());
    }

    public static @NonNull IAnalysisBinningThreadCounterReader mapReader(@NonNull CounterRecord counterRecord, @NonNull IAnalysisHardwareCounterReader reader) {
        switch (counterRecord.getCounterClass()) {
            case ABSOLUTE: 
            case CONSTANT: {
                return new AnalysisAbsoluteBinningThreadCounterReader((IAnalysisHardwareCounterSupplier)new IAnalysisHardwareCounterSupplier.AnalysisHardwareCounterReaderAdapter(reader));
            }
            case DELTA: {
                return new AnalysisDeltaBinningThreadCounterReader((IAnalysisHardwareCounterSupplier)new IAnalysisHardwareCounterSupplier.AnalysisHardwareCounterReaderAdapter(reader));
            }
            case INCIDENT: 
            case ACTIVITY: {
                return new AnalysisIncidentBinningThreadCounterReader((IAnalysisHardwareCounterSupplier)new IAnalysisHardwareCounterSupplier.AnalysisHardwareCounterReaderAdapter(reader));
            }
        }
        throw new AssertionError(counterRecord.getCounterClass());
    }

    public LegacyBaseZoomLevelGeneratorFactory(@NonNull SessionSettings settings, @NonNull IUniqueIds threads, @NonNull LongUnaryOperator vmExitTimeSupplier, @NonNull CounterRecord counterRecord, @NonNull String streamName, @NonNull IReportWriterFactory reportWriterFactory) throws IOException, XMLStreamException {
        this.reportWriterFactory = reportWriterFactory;
        this.mSettings = settings;
        this.mCounterRecord = counterRecord;
        @NonNull ProcessingElementReference @NonNull [] channels = (ProcessingElementReference[])NullChecking.neverNullOr((Object)this.mCounterRecord.getChannelDescriptions(), (Object)new ProcessingElementReference[0]);
        this.mChannelCount = channels.length;
        this.channelExitTimes = new long[this.mChannelCount];
        int i = 0;
        while (i < this.mChannelCount) {
            this.channelExitTimes[i] = vmExitTimeSupplier.applyAsLong(channels[i].vmUID);
            ++i;
        }
        this.mDuration = this.mSettings.getDurationInNanosecs();
        this.mTimebase = this.mSettings.getNanosecondsPerDensestBin();
        @NonNull String outputPath = this.mSettings.getOutputPathCounters() + "/" + this.mCounterRecord.getAlias();
        @NonNull List<@NonNull UniqueThread> threadsList = threads.getThreads().collect(Collectors.toList());
        this.threadsByExitTime = threadsList.toArray(new UniqueThread[threadsList.size()]);
        Arrays.sort(this.threadsByExitTime, (a, b) -> {
            int byExitTime = Long.compare(a.getNonUid().getEndTime(), b.getNonUid().getEndTime());
            if (byExitTime != 0) {
                return byExitTime;
            }
            return Integer.compare(a.uid, b.uid);
        });
        if (BasicTextFilter.isEmpty((String)this.mCounterRecord.getTitle()) || BasicTextFilter.isEmpty((String)this.mCounterRecord.getName())) {
            throw new XMLStreamException(MessageFormat.format(AnalysisMessages.INVALID_COUNTER_XML, this.mSettings.getInputPath() + ":" + streamName));
        }
        switch (this.mCounterRecord.getCounterClass()) {
            case ABSOLUTE: 
            case CONSTANT: {
                this.persist = true;
                this.binningDataModes = new BinningDataMode[]{BinningDataMode.MINIMUM, BinningDataMode.MAXIMUM, BinningDataMode.AVERAGE};
                break;
            }
            case DELTA: {
                this.persist = false;
                this.binningDataModes = new BinningDataMode[]{BinningDataMode.SUM};
                break;
            }
            case INCIDENT: 
            case ACTIVITY: {
                this.persist = false;
                this.binningDataModes = new BinningDataMode[]{BinningDataMode.SUM};
                break;
            }
            default: {
                throw new AssertionError(this.mCounterRecord.getCounterClass());
            }
        }
        if (!this.mCounterRecord.getCounterClass().isActivity()) {
            return;
        }
        CommonFileUtils.makeDirectory((String)outputPath);
    }

    public @Nullable Generator create() throws IOException {
        if (this.mCounterRecord.getCounterClass().isActivity()) {
            return null;
        }
        return (Generator)Throwing.closeIfThrows(tracker -> {
            int[] nameScale = this.mSettings.getTimeScale();
            int[] tickOriginal = this.mSettings.getTicksPerScale();
            IReportBinnedCounterWriter writer = (IReportBinnedCounterWriter)tracker.track((Closeable)this.reportWriterFactory.create(this.mCounterRecord, this.mChannelCount, this.binningDataModes, this.mTimebase, tickOriginal, nameScale, Integer::intValue));
            WritingBinningThreadCounterDataPointConsumer adapter = new WritingBinningThreadCounterDataPointConsumer(writer);
            WritingBinningThreadCounterDataPointConsumer consumer = this.persist ? new PerThreadPersistantBinningThreadCounterDataPointConsumer((IAnalysisBinningThreadCounterDataPointConsumer)adapter, this.mChannelCount, this.channelExitTimes, this.threadsByExitTime) : adapter;
            return new Generator(this.mTimebase, this.mDuration, (IReportBinnedCounterWriter<Integer>)writer, (IAnalysisBinningThreadCounterDataPointConsumer)consumer);
        });
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public @NonNull CounterRecord getCounterRecord() {
        return this.mCounterRecord;
    }

    public static class Generator
    implements Closeable {
        public final @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer;
        public final long duration;
        public final long timebase;
        private final @NonNull IReportBinnedCounterWriter<Integer> writer;

        public Generator(long timebase, long duration, @NonNull IReportBinnedCounterWriter<Integer> writer, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) {
            this.timebase = timebase;
            this.duration = duration;
            this.writer = writer;
            this.consumer = consumer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public @NonNull BaseZoomLevelGenerator makeBaseZoomLevelGenerator(@NonNull IAnalysisBinningThreadCounterReader channelsReader) throws IOException {
            return new BaseZoomLevelGenerator(this.timebase, this.duration, channelsReader, this.consumer);
        }
    }
}

