/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.api.profiling.IProfileEvent;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.model.ImageRecordMap;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.ICallPathsFileWriter;
import com.arm.streamline.analysis.processor.profile.IProfileProcessor;
import com.arm.streamline.analysis.processor.profile.IProfileWriterFactory;
import com.arm.streamline.analysis.processor.timeline.ICallpathsInstructions;
import com.arm.utils.MapUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProfileWriter {
    private boolean finished = false;
    private final @NonNull Set<@NonNull ProfileDataPoint> finishedDataPoints = new HashSet<ProfileDataPoint>();
    private final @NonNull IProfileProcessor profileProcessor;
    private final @NonNull IProfileWriterFactory writerFactory;

    public ProfileWriter(@NonNull IProfileProcessor profileProcessor1, @NonNull IProfileWriterFactory writerFactory) {
        this.profileProcessor = profileProcessor1;
        this.writerFactory = writerFactory;
    }

    public @NonNull Result finish() throws IOException, InterruptedException {
        if (this.finished) {
            throw new IllegalArgumentException("Already finished");
        }
        this.finished = true;
        Throwable throwable = null;
        Object var2_3 = null;
        try (ICallPathsFileWriter writer = this.writerFactory.createCommonCallpathsFileWriter();){
            Throwing.forEach(this.profileProcessor.getCommonLinks(), writer::add);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Throwing.forEach(this.profileProcessor.getFunctionLinksBySource(), (source, links) -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ICallPathsFileWriter writer = this.writerFactory.createCallpathsFileWriter((IProfileSource)source);){
                Throwing.forEach(this.profileProcessor.getCommonLinks(), writer::add);
                Throwing.forEach((Stream)((Stream)NullChecking.neverNull((Object)links)), writer::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        @NonNull TObjectLongHashMap imageSamplesOffset = new TObjectLongHashMap(10, 0.5f, 0L);
        @NonNull TObjectLongHashMap imageSamplesQuantity = new TObjectLongHashMap(10, 0.5f, 0L);
        long offset = 0L;
        long quantity = 0L;
        Throwable throwable3 = null;
        Object var8_10 = null;
        try (IProfileWriterFactory.ILinesBinWriter writer = this.writerFactory.createLinesBinWriter();){
            for (SourcefileRecord sfr : this.profileProcessor.getImageRecordMap().getAllSourcefileRecords()) {
                AnalysisBase.checkInterrupted();
                @Nullable TIntIntMap sourceLineFunctions = this.profileProcessor.getImageRecordMap().getSourcefileRecordFunctions(sfr);
                if (sourceLineFunctions != null) {
                    int[] sourceLines = sourceLineFunctions.keys();
                    Arrays.sort(sourceLines);
                    int[] nArray = sourceLines;
                    int n = sourceLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int line = nArray[n2];
                        if (line >= 1) {
                            int functionIndex = sourceLineFunctions.get(line);
                            writer.add(line, functionIndex);
                            ++quantity;
                        }
                        ++n2;
                    }
                }
                if (quantity > 0L) {
                    imageSamplesOffset.put((Object)sfr, offset);
                    imageSamplesQuantity.put((Object)sfr, quantity);
                }
                offset += quantity;
                quantity = 0L;
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        Throwing.forEach(this.finishedDataPoints.stream().map(d -> d.event).distinct(), event -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (IProfileWriterFactory.IInstructionCounterMetadataWriter writer = this.writerFactory.createEventMetadataWriter((IProfileEvent)event);){
                writer.write(event.getProfileEventMetadata());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        Throwing.forEach((Iterable)((Iterable)NullChecking.neverNull(this.profileProcessor.getFunctionLinksBySource().keySet())), source -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (IProfileWriterFactory.IInstructionCounterSourceMetadataWriter writer = this.writerFactory.createSourceMetadataWriter((IProfileSource)source);){
                writer.write(source.getProfileSourceMetadata());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        return new Result(arg_0 -> ((TObjectLongHashMap)imageSamplesOffset).get(arg_0), arg_0 -> ((TObjectLongHashMap)imageSamplesQuantity).get(arg_0));
    }

    public @NonNull ImageRecordMap getImageRecordMap() {
        return this.profileProcessor.getImageRecordMap();
    }

    public void processDatabase(@NonNull IntConsumer progressConsumer, @NonNull IAnalysisCodeProfilingReader codeProfilingReader) throws IOException, InterruptedException {
        if (this.finished) {
            throw new IllegalArgumentException("Already finished");
        }
        progressConsumer.accept(0);
        try {
            @NonNull HashMap<@NonNull K, @NonNull V> sampleConsumerByDataPoint = new HashMap();
            @NonNull HashMap<@NonNull K, @NonNull V> callpathSamplesByDataPoint = new HashMap();
            @NonNull HashMap<@NonNull K, @NonNull V> instructionSamplesByDataPoint = new HashMap();
            @NonNull IProfileProcessor.ISampleConsumer sampleConsumer = (time, dataPoint, callpathLinkId, instructionId, count) -> {
                ICallpathsInstructions writer = (ICallpathsInstructions)MapUtils.computeIfAbsentThrows((Map)sampleConsumerByDataPoint, (Object)dataPoint, this.writerFactory::createTimelineWriter);
                writer.write(time, callpathLinkId, instructionId, count);
                callpathSamplesByDataPoint.computeIfAbsent(dataPoint, k -> new TIntLongHashMap()).adjustOrPutValue(callpathLinkId, count, count);
                if (instructionId != null) {
                    instructionSamplesByDataPoint.computeIfAbsent(dataPoint, k -> new TIntLongHashMap()).adjustOrPutValue(instructionId.intValue(), count, count);
                }
            };
            try {
                this.profileProcessor.processDatabase(progressConsumer, codeProfilingReader, sampleConsumer);
            }
            catch (Throwable throwable) {
                Throwing.closeAll((Iterable[])new Iterable[]{sampleConsumerByDataPoint.values()});
                throw throwable;
            }
            Throwing.closeAll((Iterable[])new Iterable[]{sampleConsumerByDataPoint.values()});
            sampleConsumerByDataPoint.keySet().forEach(e -> {
                if (!this.finishedDataPoints.add((ProfileDataPoint)e)) {
                    throw new IllegalArgumentException("Already processed " + String.valueOf(e));
                }
            });
            Throwing.forEach(callpathSamplesByDataPoint, (dataPoint, samples) -> {
                Throwable throwable = null;
                Object var4_5 = null;
                try (IProfileWriterFactory.ICallpathsBinWriter writer = this.writerFactory.createCallpathsBinWriter((ProfileDataPoint)dataPoint);){
                    Throwing.forEach((TIntLongMap)samples, writer::add);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
            int length = this.profileProcessor.getImageRecordMap().getInstructionCount();
            Throwing.forEach(instructionSamplesByDataPoint, (dataPoint, samples) -> {
                Throwable throwable = null;
                Object var5_6 = null;
                try (IProfileWriterFactory.IInstructionsBinWriter writer = this.writerFactory.createInstructionsBinWriter((ProfileDataPoint)dataPoint);){
                    int i = 0;
                    while (i < length) {
                        writer.add(samples.get(i));
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        finally {
            progressConsumer.accept(100);
        }
    }

    public static class Result {
        public final @NonNull ToLongFunction<@NonNull SourcefileRecord> getSamplesOffset;
        public final @NonNull ToLongFunction<@NonNull SourcefileRecord> getSamplesQuantity;

        public Result(@NonNull ToLongFunction<@NonNull SourcefileRecord> getSamplesOffset, @NonNull ToLongFunction<@NonNull SourcefileRecord> getSamplesQuantity) {
            this.getSamplesOffset = getSamplesOffset;
            this.getSamplesQuantity = getSamplesQuantity;
        }
    }
}

