/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.IMonotonicRawToVmTimestamp;
import com.arm.streamline.analysis.model.ImageRecordMap;
import com.arm.streamline.analysis.processor.profile.CallpathLink;
import com.arm.streamline.analysis.processor.profile.FunctionHeaderFooter;
import com.arm.streamline.analysis.processor.profile.JITDumpStateBuilder;
import com.arm.streamline.analysis.processor.profile.ProfileProcessor;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.MapUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProfileProcessorFactory {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull ProfileProcessor create(@NonNull TIntObjectMap<List<@NonNull JITDumpStateBuilder.JITDumpState>> jitdumpFiles, @NonNull IUniqueIds uniqueIds, @NonNull BacktraceProcessing backtraceProcessing, long durationInNanoseconds, @NonNull TLongObjectMap<? extends IMonotonicRawToVmTimestamp> perVmTimestampAdjustmentFactor, @NonNull IThrowingFunction<@NonNull IFunctionRecord, @Nullable FunctionHeaderFooter, IOException> functionMap, @NonNull ImageRecordMap imageRecordMap, @NonNull AttachedApkEntries attachedApkEntries, @NonNull LongPredicate isAppTracingMode, boolean filterCallPaths) {
        int[] id = new int[]{uniqueIds.getNextUniqueId()};
        @NonNull TLongObjectHashMap vmUIDMap = new TLongObjectHashMap();
        @NonNull LongFunction<@NonNull CallpathLink> newVm = arg_0 -> ProfileProcessorFactory.lambda$0(id, (TLongObjectMap)vmUIDMap, arg_0);
        @NonNull Map<@NonNull UniqueProcess, @NonNull CallpathLink> processMap = uniqueIds.getProcesses().collect(Collectors.toMap(p -> p, p -> CallpathLink.createForProcess((CallpathLink)newVm.apply(((AbstractPerVmId.PerVmNonUniquePid)p.nonUid.getId()).vmUID), p)));
        @NonNull @NonNull Collection threadLinks = uniqueIds.getThreads().map(t -> CallpathLink.createForThread((CallpathLink)NullChecking.neverNull((Object)((CallpathLink)processMap.get(t.process))), t)).collect(Collectors.toList());
        return new ProfileProcessor(backtraceProcessing, durationInNanoseconds, perVmTimestampAdjustmentFactor, threadLinks, functionMap, imageRecordMap, attachedApkEntries, isAppTracingMode, arg_0 -> jitdumpFiles.get(arg_0), utid -> (UniqueThread)uniqueIds.findThread(utid).get(), filterCallPaths);
    }

    private static /* synthetic */ CallpathLink lambda$0(int[] nArray, TLongObjectMap tLongObjectMap, long vmUID) {
        return (CallpathLink)MapUtils.getOrCreate((TLongObjectMap)tLongObjectMap, (long)vmUID, () -> {
            int n = nArray[0];
            nArray[0] = n + 1;
            return CallpathLink.createForVmUID(n, vmUID);
        });
    }
}

