/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.ImageRecord;
import com.arm.streamline.analysis.model.ImageRecordMap;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.FunctionHeaderFooter;
import com.arm.streamline.analysis.processor.profile.IInstructionReader;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProfileFunctionMap
implements IThrowingFunction<IFunctionRecord, FunctionHeaderFooter, IOException> {
    private final @NonNull Map<@NonNull SourcefileRecord, @NonNull Ratio> fileRatios = new HashMap<SourcefileRecord, Ratio>();
    private final @NonNull IInstructionReader instructionReader;
    private final @NonNull TIntObjectMap<FunctionHeaderFooter> functionMap = new TIntObjectHashMap();
    private final boolean collectCallstackWarnings;

    public ProfileFunctionMap(@NonNull IInstructionReader instructionReader, boolean collectCallstackWarnings) {
        this.instructionReader = instructionReader;
        this.collectCallstackWarnings = collectCallstackWarnings;
    }

    public @Nullable FunctionHeaderFooter apply(@NonNull IFunctionRecord function) throws IOException {
        FunctionHeaderFooter oldFhf = (FunctionHeaderFooter)this.functionMap.get(function.getID());
        if (oldFhf != null) {
            return oldFhf;
        }
        @Nullable FunctionHeaderFooter fhf = function.createFunctionHeaderFooter(this.instructionReader);
        if (fhf != null) {
            SourcefileRecord sfr;
            this.functionMap.put(function.getID(), (Object)fhf);
            if (this.collectCallstackWarnings && (sfr = function.getFile()) != null) {
                Ratio ratio = this.fileRatios.computeIfAbsent(sfr, ignored -> new Ratio());
                ratio.add(fhf.getFrameHeader() != 0L);
            }
        }
        return fhf;
    }

    public void generateCallstackWarnings(@NonNull ImageRecordMap irm, @NonNull Consumer<@NonNull WarningItem> warningConsumer) {
        if (!this.collectCallstackWarnings) {
            return;
        }
        for (Map.Entry<String, ImageRecord<?>> entry : irm.entrySet()) {
            @NonNull List<@NonNull SourcefileRecord> sourcefiles = entry.getValue().getSourceFileRecords();
            Ratio ratio = new Ratio();
            for (SourcefileRecord sfr : sourcefiles) {
                @Nullable Ratio that = this.fileRatios.get(sfr);
                if (that == null) continue;
                ratio.add(that);
            }
            int result = ratio.calculate();
            if (result > 5) continue;
            warningConsumer.accept(new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.MEDIUM, AnalysisMessages.CALLSTACK_MISSING_TITLE, AnalysisMessages.CALLSTACK_MISSING_DESCRIPTION, "\"" + entry.getKey() + "\" (" + String.valueOf((Object)result) + "%)"));
        }
    }

    private static class Ratio {
        private int mHasFrame;
        private int mTotal;

        protected Ratio() {
        }

        protected void add(boolean hasFrame) {
            ++this.mTotal;
            if (hasFrame) {
                ++this.mHasFrame;
            }
        }

        protected void add(Ratio that) {
            this.mTotal += that.mTotal;
            this.mHasFrame += that.mHasFrame;
        }

        protected int calculate() {
            if (this.mTotal == 0) {
                return 100;
            }
            return 100 * this.mHasFrame / this.mTotal;
        }
    }
}

