/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.processor.profile.JITDumpParserException;
import com.arm.streamline.analysis.processor.profile.Messages;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiConsumer;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.io.ByteBufferUtils;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class JITDumpParser {
    private static final int FILE_HEADER_LENGTH = 40;
    private static final int JIT_CODE_CLOSE = 3;
    private static final int JIT_CODE_DEBUG_INFO = 2;
    private static final int JIT_CODE_LOAD = 0;
    private static final int JIT_CODE_MOVE = 1;
    private static final int JIT_CODE_UNWINDING_INFO = 4;
    private static final int MAGIC_BIG_ENDIAN = 1146382666;
    private static final int MAGIC_LITTLE_ENDIAN = 1248416836;
    private static final int RECORD_DEBUG_INFO_ENTRY_MIN_LENGTH = 16;
    private static final int RECORD_DEBUG_INFO_PAYLOAD_MIN_LENGTH = 16;
    private static final int RECORD_HEADER_LENGTH = 16;
    private static final int RECORD_LOAD_PAYLOAD_MIN_LENGTH = 40;
    private static final int RECORD_MOVE_PAYLOAD_LENGTH = 48;
    private static final int RECORD_UNWINDING_INFO_MIN_PAYLOAD_LENGTH = 24;

    public static @NonNull JITDump parse(@NonNull InputStream stream) throws IOException, JITDumpParserException {
        JITDump.JITDumpHeader[] header = new JITDump.JITDumpHeader[1];
        @NonNull ArrayList<@NonNull JITDump.JITDumpRecord> records = new ArrayList<JITDump.JITDumpRecord>();
        JITDumpParser.parse(stream, h -> {
            jITDumpHeaderArray[0] = h;
            return jITDumpHeaderArray[0];
        }, (d, r) -> {
            boolean bl = records.add((JITDump.JITDumpRecord)r);
        });
        return new JITDump((JITDump.JITDumpHeader)NullChecking.neverNull((Object)header[0]), records);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T parse(@NonNull InputStream stream, @NonNull IThrowingFunction<@NonNull JITDump.JITDumpHeader, T, E1> headerConsumer, @NonNull IThrowingBiConsumer<T, @NonNull JITDump.JITDumpRecord, E2> recordConsumer) throws IOException, JITDumpParserException, E1, E2 {
        JITDump.JITDumpRecord record;
        @NonNull JITDump.JITDumpHeader header = JITDumpParser.parseHeader(stream);
        Object param = headerConsumer.apply((Object)header);
        long offset = header.totalSize;
        while ((record = JITDumpParser.parseRecord(stream, header, offset)) != null) {
            offset += (long)record.totalSize;
            if (record.id == 3) break;
            recordConsumer.accept(param, (Object)record);
        }
        return (T)param;
    }

    private static @NonNull JITDump.JITDumpHeader parseHeader(@NonNull InputStream stream) throws IOException, JITDumpParserException {
        ByteBuffer buffer = ByteBuffer.allocate(40);
        int n = ByteBufferUtils.readFully((InputStream)stream, (ByteBuffer)buffer);
        if (n != buffer.limit()) {
            throw new JITDumpParserException(Messages.JITDumpParserException_NOT_A_JITDUMP_FILE);
        }
        buffer.rewind();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int magic = buffer.getInt();
        if (magic == 1146382666) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (magic != 1248416836) {
            throw new JITDumpParserException(Messages.JITDumpParserException_NOT_A_JITDUMP_FILE);
        }
        int version = buffer.getInt();
        int totalSize = buffer.getInt();
        if (version < 1 || version > 2 || totalSize != 40) {
            throw new JITDumpParserException(Messages.JITDumpParserException_NOT_A_RECOGNIZED_HEADER);
        }
        int elfMachine = buffer.getInt();
        buffer.getInt();
        int pid = buffer.getInt();
        long timestamp = buffer.getLong();
        long flags = buffer.getLong();
        return new JITDump.JITDumpHeader(buffer.order() == ByteOrder.LITTLE_ENDIAN, version, totalSize, elfMachine, pid, timestamp, flags);
    }

    private static @Nullable JITDump.JITDumpRecord parseRecord(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset) throws IOException, JITDumpParserException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(header.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        int n = ByteBufferUtils.readFully((InputStream)stream, (ByteBuffer)buffer);
        if (n < 0) {
            return null;
        }
        if (n < 16) {
            throw new JITDumpParserException(Messages.JITDumpParserException_FAILED_TO_READ_RECORD);
        }
        buffer.rewind();
        int id = buffer.getInt();
        int totalSize = buffer.getInt();
        long timestamp = buffer.getLong();
        int remaining = totalSize - 16;
        if (totalSize < 16 || remaining < 0) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        switch (id) {
            case 0: {
                return JITDumpParser.parseRecordLoad(stream, header, offset, totalSize, remaining, timestamp);
            }
            case 1: {
                return JITDumpParser.parseRecordMove(stream, header, offset, totalSize, remaining, timestamp);
            }
            case 2: {
                return JITDumpParser.parseRecordDebugInfo(stream, header, offset, totalSize, remaining, timestamp);
            }
            case 3: {
                return JITDumpParser.parseRecordClose(stream, header, offset, totalSize, remaining, timestamp);
            }
            case 4: {
                return JITDumpParser.parseRecordUnwindingInfo(stream, header, offset, totalSize, remaining, timestamp);
            }
        }
        throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
    }

    private static @NonNull JITDump.JITDumpRecordClose parseRecordClose(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset, int totalSize, int remaining, long timestamp) throws JITDumpParserException {
        if (remaining != 0) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        return new JITDump.JITDumpRecordClose(offset, totalSize, timestamp);
    }

    private static @NonNull JITDump.JITDumpRecordDebugInfo parseRecordDebugInfo(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset, int totalSize, int remaining, long timestamp) throws JITDumpParserException, IOException {
        if (remaining < 16) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        ByteBuffer buffer = JITDumpParser.readRecordPayload(stream, header, remaining);
        long codeAddr = buffer.getLong();
        long nrEntries = buffer.getLong();
        if (nrEntries < 0L || nrEntries > Integer.MAX_VALUE) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INT_TOO_BIG);
        }
        @NonNull ArrayList<@NonNull JITDump.JITDumpRecordDebugInfo.Entry> entries = new ArrayList<JITDump.JITDumpRecordDebugInfo.Entry>();
        int i = 0;
        while (i < (int)nrEntries) {
            entries.add(JITDumpParser.parseRecordDebugInfoEntry(buffer));
            ++i;
        }
        return new JITDump.JITDumpRecordDebugInfo(offset, totalSize, timestamp, codeAddr, entries);
    }

    private static @NonNull JITDump.JITDumpRecordDebugInfo.Entry parseRecordDebugInfoEntry(@NonNull ByteBuffer buffer) throws JITDumpParserException {
        if (buffer.remaining() < 16) {
            throw new JITDumpParserException(Messages.JITDumpParserException_FAILED_TO_READ_RECORD);
        }
        long codeAddr = buffer.getLong();
        int line = buffer.getInt();
        int descrim = buffer.getInt();
        @NonNull String name = JITDumpParser.readString(buffer);
        return new JITDump.JITDumpRecordDebugInfo.Entry(codeAddr, line, descrim, name);
    }

    private static @NonNull JITDump.JITDumpRecordLoad parseRecordLoad(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset, int totalSize, int remaining, long timestamp) throws JITDumpParserException, IOException {
        byte[] dataBytes;
        int headerLength = totalSize - remaining;
        if (remaining < 40) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        ByteBuffer buffer = JITDumpParser.readRecordPayload(stream, header, remaining);
        int pid = buffer.getInt();
        int tid = buffer.getInt();
        long vma = buffer.getLong();
        long codeAddr = buffer.getLong();
        long codeSize = buffer.getLong();
        long codeIndex = buffer.getLong();
        @NonNull String name = JITDumpParser.readString(buffer);
        if ((long)buffer.remaining() < codeSize || codeSize < 0L) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        int codeRelativeOffset = buffer.position() + headerLength;
        byte @NonNull [] codeBytes = new byte[(int)codeSize];
        buffer.get(codeBytes);
        if (buffer.remaining() > 0) {
            dataBytes = new byte[buffer.remaining()];
            buffer.get(dataBytes);
        } else {
            dataBytes = null;
        }
        return new JITDump.JITDumpRecordLoad(offset, totalSize, timestamp, codeIndex, pid, tid, vma, codeAddr, codeRelativeOffset, codeBytes, dataBytes, name);
    }

    private static @NonNull JITDump.JITDumpRecordMove parseRecordMove(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset, int totalSize, int remaining, long timestamp) throws JITDumpParserException, IOException {
        if (remaining != 48) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        ByteBuffer buffer = JITDumpParser.readRecordPayload(stream, header, remaining);
        int pid = buffer.getInt();
        int tid = buffer.getInt();
        long vma = buffer.getLong();
        long oldCodeAddr = buffer.getLong();
        long newCodeAddr = buffer.getLong();
        long codeSize = buffer.getLong();
        long codeIndex = buffer.getLong();
        return new JITDump.JITDumpRecordMove(offset, totalSize, timestamp, codeIndex, pid, tid, vma, oldCodeAddr, newCodeAddr, codeSize);
    }

    private static @NonNull JITDump.JITDumpRecordUnwindingInfo parseRecordUnwindingInfo(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, long offset, int totalSize, int remaining, long timestamp) throws IOException, JITDumpParserException {
        if (remaining < 24) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        ByteBuffer buffer = JITDumpParser.readRecordPayload(stream, header, remaining);
        long unwindDataSize = buffer.getLong();
        long ehFrameHdrSize = buffer.getLong();
        long mappedSize = buffer.getLong();
        if (unwindDataSize > (long)buffer.remaining() || unwindDataSize < 0L || ehFrameHdrSize < 0L || ehFrameHdrSize > unwindDataSize) {
            throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
        }
        byte @NonNull [] ehFrameHdrData = new byte[(int)ehFrameHdrSize];
        byte @NonNull [] ehFrameData = new byte[(int)(unwindDataSize - ehFrameHdrSize)];
        buffer.get(ehFrameHdrData);
        buffer.get(ehFrameData);
        return new JITDump.JITDumpRecordUnwindingInfo(offset, totalSize, timestamp, mappedSize, ehFrameHdrData, ehFrameData);
    }

    private static @NonNull ByteBuffer readRecordPayload(@NonNull InputStream stream, @NonNull JITDump.JITDumpHeader header, int length) throws IOException, JITDumpParserException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(header.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        int n = ByteBufferUtils.readFully((InputStream)stream, (ByteBuffer)buffer);
        if (n < length) {
            throw new JITDumpParserException(Messages.JITDumpParserException_FAILED_TO_READ_RECORD);
        }
        buffer.rewind();
        return buffer;
    }

    private static @NonNull String readString(@NonNull ByteBuffer buffer) throws JITDumpParserException {
        boolean seenZero = false;
        TByteArrayList nameBytes = new TByteArrayList();
        while (buffer.hasRemaining() && !seenZero) {
            byte b = buffer.get();
            if (b == 0) {
                seenZero = true;
                break;
            }
            nameBytes.add(b);
        }
        if (!seenZero) {
            throw new JITDumpParserException(Messages.JITDumpParserException_FAILED_TO_READ_RECORD);
        }
        return new String(nameBytes.toArray(), StandardCharsets.US_ASCII).intern();
    }

    public static class JITDump {
        public final @NonNull JITDumpHeader header;
        private final @NonNull List<@NonNull JITDumpRecord> records;

        JITDump(@NonNull JITDumpHeader header, @NonNull List<@NonNull JITDumpRecord> records) {
            this.header = header;
            this.records = records;
        }

        public @NonNull List<@NonNull JITDumpRecord> getRecords() {
            return Collections.unmodifiableList(this.records);
        }

        public @NonNull String toString() {
            StringBuilder recordsStr = new StringBuilder();
            if (this.records.isEmpty()) {
                recordsStr.append("[]");
            } else {
                recordsStr.append("[\n");
                for (JITDumpRecord record : this.records) {
                    recordsStr.append(record);
                    recordsStr.append(",\n");
                }
                recordsStr.append("]");
            }
            return String.format("%s = %s", this.header, recordsStr);
        }

        public void sort() {
            this.records.sort((a, b) -> UnsignedLong.compare((long)a.timestamp, (long)b.timestamp));
        }

        public static interface IJITDumpRecordVisitor<T, R, E extends Throwable> {
            public R visit(@NonNull JITDumpRecordClose var1, T var2) throws E;

            public R visit(@NonNull JITDumpRecordDebugInfo var1, T var2) throws E;

            public R visit(@NonNull JITDumpRecordLoad var1, T var2) throws E;

            public R visit(@NonNull JITDumpRecordMove var1, T var2) throws E;

            public R visit(@NonNull JITDumpRecordUnwindingInfo var1, T var2) throws E;
        }

        public static class JITDumpHeader {
            public final int elfMachine;
            public final long flags;
            public final boolean littleEndian;
            public final int pid;
            public final long timestamp;
            public final int totalSize;
            public final int version;

            public JITDumpHeader(boolean littleEndian, int version, int totalSize, int elfMachine, int pid, long timestamp, long flags) {
                this.littleEndian = littleEndian;
                this.version = version;
                this.totalSize = totalSize;
                this.elfMachine = elfMachine;
                this.pid = pid;
                this.timestamp = timestamp;
                this.flags = flags;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpHeader) {
                    JITDumpHeader that = (JITDumpHeader)obj;
                    return this.littleEndian == that.littleEndian && this.version == that.version && this.totalSize == that.totalSize && this.elfMachine == that.elfMachine && this.pid == that.pid && this.timestamp == that.timestamp && this.flags == that.flags;
                }
                return false;
            }

            public int hashCode() {
                return Long.hashCode(this.timestamp) * 31 + Integer.hashCode(this.pid);
            }
        }

        public static abstract class JITDumpRecord {
            public final int id;
            public final long offset;
            public final long timestamp;
            public final int totalSize;

            protected static final boolean equalsHeader(@NonNull JITDumpRecord a, @NonNull JITDumpRecord b) {
                return a.id == b.id && a.offset == b.offset && a.timestamp == b.timestamp && a.totalSize == b.totalSize;
            }

            protected JITDumpRecord(long offset, int id, int totalSize, long timestamp) {
                this.offset = offset;
                this.id = id;
                this.totalSize = totalSize;
                this.timestamp = timestamp;
            }

            public abstract <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> var1, T var2) throws E;

            public abstract boolean equals(Object var1);

            public final int hashCode() {
                return Long.hashCode(this.offset);
            }

            public abstract @NonNull String toString();
        }

        public static final class JITDumpRecordClose
        extends JITDumpRecord {
            public JITDumpRecordClose(long offset, int totalSize, long timestamp) {
                super(offset, 3, totalSize, timestamp);
            }

            @Override
            public <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> visitor, T data) throws E {
                return visitor.visit(this, data);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpRecordClose) {
                    JITDumpRecordClose that = (JITDumpRecordClose)obj;
                    return JITDumpRecordClose.equalsHeader(this, that);
                }
                return false;
            }

            @Override
            public @NonNull String toString() {
                return String.format("JIT_CODE_CLOSE{offset=0x%08x, totalSize=%d, timestamp=%d}", this.offset, this.totalSize, this.timestamp);
            }
        }

        public static final class JITDumpRecordDebugInfo
        extends JITDumpRecord {
            public final long codeAddr;
            private final @NonNull List<@NonNull Entry> entries;

            public JITDumpRecordDebugInfo(long offset, int totalSize, long timestamp, long codeAddr, @NonNull List<@NonNull Entry> entries) {
                super(offset, 2, totalSize, timestamp);
                this.codeAddr = codeAddr;
                this.entries = entries;
            }

            @Override
            public <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> visitor, T data) throws E {
                return visitor.visit(this, data);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpRecordDebugInfo) {
                    JITDumpRecordDebugInfo that = (JITDumpRecordDebugInfo)obj;
                    return JITDumpRecordDebugInfo.equalsHeader(this, that) && this.codeAddr == that.codeAddr && this.entries.equals(that.entries);
                }
                return false;
            }

            public @NonNull List<@NonNull Entry> getEntries() {
                return Collections.unmodifiableList(this.entries);
            }

            @Override
            public @NonNull String toString() {
                StringBuilder entriesStr = new StringBuilder();
                if (this.entries.isEmpty()) {
                    entriesStr.append("[]");
                } else {
                    entriesStr.append("[\n");
                    for (Entry entry : this.entries) {
                        entriesStr.append(entry);
                        entriesStr.append(",\n");
                    }
                    entriesStr.append("]");
                }
                return String.format("JIT_CODE_DEBUG_INFO{offset=0x%08x, totalSize=%d, timestamp=%d, codeAddr=0x%016x, entries=%s}", this.offset, this.totalSize, this.timestamp, this.codeAddr, entriesStr);
            }

            public static final class Entry {
                public final long codeAddr;
                public final int descrim;
                public final int line;
                public final @NonNull String name;

                public Entry(long codeAddr, int line, int descrim, @NonNull String name) {
                    this.codeAddr = codeAddr;
                    this.line = line;
                    this.descrim = descrim;
                    this.name = name;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj instanceof Entry) {
                        Entry that = (Entry)obj;
                        return this.codeAddr == that.codeAddr && this.line == that.line && this.descrim == that.descrim && this.name.equals(that.name);
                    }
                    return false;
                }

                public int hashCode() {
                    return Long.hashCode(this.codeAddr) * 31 + Integer.hashCode(this.line);
                }

                public @NonNull String toString() {
                    return String.format("    {codeAddr=0x%016x, line=%d, descrim=%d, name='%s'}", this.codeAddr, this.line, this.descrim, this.name);
                }
            }
        }

        public static final class JITDumpRecordLoad
        extends JITDumpRecord {
            public final long codeAddr;
            public final @NonNull SoftReference<byte[]> codeBytes;
            public final long codeIndex;
            public final int codeRelativeOffset;
            public final int codeSize;
            public final @NonNull SoftReference<byte[]> dataBytes;
            public final int dataSize;
            public final @NonNull String name;
            public final int pid;
            public final int tid;
            public final long vma;

            public JITDumpRecordLoad(long offset, int totalSize, long timestamp, long codeIndex, int pid, int tid, long vma, long codeAddr, int codeRelativeOffset, byte @NonNull [] codeBytes, byte @Nullable [] dataBytes, @NonNull String name) {
                super(offset, 0, totalSize, timestamp);
                this.codeIndex = codeIndex;
                this.pid = pid;
                this.tid = tid;
                this.vma = vma;
                this.codeAddr = codeAddr;
                this.codeRelativeOffset = codeRelativeOffset;
                this.name = name;
                this.codeBytes = new SoftReference<byte[]>(codeBytes);
                this.dataBytes = new SoftReference<byte[]>(dataBytes);
                this.codeSize = codeBytes.length;
                this.dataSize = dataBytes != null ? dataBytes.length : 0;
            }

            @Override
            public <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> visitor, T data) throws E {
                return visitor.visit(this, data);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpRecordLoad) {
                    JITDumpRecordLoad that = (JITDumpRecordLoad)obj;
                    return JITDumpRecordLoad.equalsHeader(this, that) && this.codeIndex == that.codeIndex && this.pid == that.pid && this.tid == that.tid && this.vma == that.vma && this.codeAddr == that.codeAddr && this.codeRelativeOffset == that.codeRelativeOffset && this.codeSize == that.codeSize && this.dataSize == that.dataSize && this.name.equals(that.name);
                }
                return false;
            }

            @Override
            public @NonNull String toString() {
                return String.format("JIT_CODE_LOAD{offset=0x%08x, totalSize=%d, timestamp=%d, codeIndex=%d, pid=%d, tid=%d, vma=0x%016x, codeAddr=0x%016x, codeSize=%d, dataSize=%d, name='%s'}", this.offset, this.totalSize, this.timestamp, this.codeIndex, this.pid, this.tid, this.vma, this.codeAddr, this.codeSize, this.dataSize, this.name);
            }
        }

        public static final class JITDumpRecordMove
        extends JITDumpRecord {
            public final long codeIndex;
            public final long codeSize;
            public final long newCodeAddr;
            public final long oldCodeAddr;
            public final int pid;
            public final int tid;
            public final long vma;

            public JITDumpRecordMove(long offset, int totalSize, long timestamp, long codeIndex, int pid, int tid, long vma, long oldCodeAddr, long newCodeAddr, long codeSize) {
                super(offset, 1, totalSize, timestamp);
                this.codeIndex = codeIndex;
                this.pid = pid;
                this.tid = tid;
                this.vma = vma;
                this.oldCodeAddr = oldCodeAddr;
                this.newCodeAddr = newCodeAddr;
                this.codeSize = codeSize;
            }

            @Override
            public <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> visitor, T data) throws E {
                return visitor.visit(this, data);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpRecordMove) {
                    JITDumpRecordMove that = (JITDumpRecordMove)obj;
                    return JITDumpRecordMove.equalsHeader(this, that) && this.codeIndex == that.codeIndex && this.pid == that.pid && this.tid == that.tid && this.vma == that.vma && this.oldCodeAddr == that.oldCodeAddr && this.newCodeAddr == that.newCodeAddr && this.codeSize == that.codeSize;
                }
                return false;
            }

            @Override
            public @NonNull String toString() {
                return String.format("JIT_CODE_MOVE{offset=0x%08x, totalSize=%d, timestamp=%d, codeIndex=%d, pid=%d, tid=%d, vma=0x%016x, oldCodeAddr=0x%016x, newCodeAddr=0x%016x, codeSize=%d}", this.offset, this.totalSize, this.timestamp, this.codeIndex, this.pid, this.tid, this.vma, this.oldCodeAddr, this.newCodeAddr, this.codeSize);
            }
        }

        public static final class JITDumpRecordUnwindingInfo
        extends JITDumpRecord {
            public final byte @NonNull [] ehFrameData;
            public final byte @NonNull [] ehFrameHdrData;
            public final long mappedSize;

            public JITDumpRecordUnwindingInfo(long offset, int totalSize, long timestamp, long mappedSize, byte @NonNull [] ehFrameHdrData, byte @NonNull [] ehFrameData) {
                super(offset, 4, totalSize, timestamp);
                this.mappedSize = mappedSize;
                this.ehFrameHdrData = ehFrameHdrData;
                this.ehFrameData = ehFrameData;
            }

            @Override
            public <T, R, E extends Throwable> R accept(@NonNull IJITDumpRecordVisitor<T, R, E> visitor, T data) throws E {
                return visitor.visit(this, data);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITDumpRecordUnwindingInfo) {
                    JITDumpRecordUnwindingInfo that = (JITDumpRecordUnwindingInfo)obj;
                    return JITDumpRecordUnwindingInfo.equalsHeader(this, that) && this.mappedSize == that.mappedSize && Arrays.equals(this.ehFrameData, that.ehFrameData) && Arrays.equals(this.ehFrameHdrData, that.ehFrameHdrData);
                }
                return false;
            }

            @Override
            public @NonNull String toString() {
                return String.format("JIT_CODE_UNWINDING_INFO{offset=0x%08x, totalSize=%d, timestamp=%d, mappedSize=%d, ehFrameData.length=%d, ehFrameHdrData.length=%d}", this.offset, this.totalSize, this.timestamp, this.mappedSize, this.ehFrameData.length, this.ehFrameHdrData.length);
            }
        }
    }
}

