/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ImageNameAndPath {
    public final @NonNull String baseName;
    public final @Nullable String filePath;
    public final @Nullable String zipPath;

    public ImageNameAndPath(@NonNull IExecutablePath executablePath) {
        switch (executablePath.getType()) {
            case FILE_OR_ZIP: {
                this.baseName = executablePath.getBaseName();
                this.filePath = executablePath.getFullPath();
                this.zipPath = executablePath.getEntryPath();
                break;
            }
            case SPECIAL_IDLE: 
            case SPECIAL_KERNEL: 
            case SPECIAL_NONE: {
                this.baseName = "kernel";
                this.filePath = null;
                this.zipPath = null;
                break;
            }
            default: {
                throw new AssertionError(executablePath);
            }
        }
    }

    public @NonNull String makeUserFacingName() {
        if (this.zipPath != null) {
            return String.format("%s:%s", this.baseName, this.zipPath);
        }
        return this.baseName;
    }
}

