/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public interface IInstructionReader {
    public @NonNull InstructionReaderEntry get(int var1) throws IOException;

    public static class InstructionReaderEntry {
        public final int index;
        public final long address;
        public final @NonNull Type type;
        public final int opcode;
        public final int sourceFileID;
        public final int sourceLine;
        public final int instructionLength;

        public InstructionReaderEntry(int index, @NonNull Type type, long address, int opcode, int instructionLength, int sourceFileID, int sourceLine) {
            assert (instructionLength == 0 || instructionLength == 2 || instructionLength == 4);
            this.index = index;
            this.type = type;
            this.address = address;
            this.opcode = opcode;
            this.instructionLength = instructionLength;
            this.sourceFileID = sourceFileID;
            this.sourceLine = sourceLine;
        }

        public String toString() {
            return "InstructionReaderEntry [index=" + this.index + ", address=0x" + Long.toHexString(this.address) + ", type=" + String.valueOf((Object)this.type) + ", opcode=0x" + Integer.toHexString(this.opcode) + ", sourceFileID=" + this.sourceFileID + ", sourceLine=" + this.sourceLine + ", instructionLength=" + this.instructionLength + "]";
        }

        public static enum Type {
            T32,
            A32,
            A64,
            MARKER;

        }
    }
}

