/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.processor.profile.IInstructionReader;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class FunctionHeaderFooter {
    private long mFrameFooterEnd;
    private long mFrameFooterStart;
    private long mFrameHeaderEnd = 0L;
    private boolean mFrameLeaf = true;
    private final @NonNull TLongIntMap mInstructions;
    private boolean mIsARM;
    private boolean mIsARM64;

    protected static int bit(int w, int b) {
        return w & 1 << b;
    }

    protected static int field(int w, int s, int e) {
        return FunctionHeaderFooter.bits(w, s, e) >>> e;
    }

    protected static boolean flag(int w, int f) {
        return FunctionHeaderFooter.bit(w, f) != 0;
    }

    private static int bits(int w, int s, int e) {
        return w & FunctionHeaderFooter.mask(s, e);
    }

    private static int mask(int s, int e) {
        return (2 << s) - 1 - ((1 << e) - 1);
    }

    public FunctionHeaderFooter(long frameHeaderEnd, long frameFooterStart, long frameFooterEnd, boolean frameLeaf, @NonNull TLongIntMap instructions, boolean isARM, boolean isARM64) {
        this.mFrameFooterEnd = frameFooterEnd;
        this.mFrameFooterStart = frameFooterStart;
        this.mFrameHeaderEnd = frameHeaderEnd;
        this.mFrameLeaf = frameLeaf;
        this.mInstructions = instructions;
        this.mIsARM = isARM;
        this.mIsARM64 = isARM64;
    }

    public FunctionHeaderFooter(@NonNull IFunctionRecord function, @NonNull IInstructionReader instructionReader) throws IOException {
        long offset;
        long address;
        IInstructionReader.InstructionReaderEntry entry;
        DecodeARM decodeARM = null;
        DecodeARM64 decodeARM64 = null;
        int startInstruction = function.getFirstInstruction();
        int lastInstruction = function.getLastInstruction();
        this.mFrameFooterEnd = -1L;
        this.mInstructions = new TLongIntHashMap(lastInstruction - startInstruction + 1);
        int i = startInstruction;
        while (i <= lastInstruction) {
            entry = instructionReader.get(i);
            switch (entry.type) {
                case MARKER: {
                    break;
                }
                case T32: 
                case A32: 
                case A64: {
                    address = entry.address;
                    offset = function.getOffsetInFile(address);
                    int opcode = entry.opcode;
                    this.mIsARM = this.mIsARM || entry.type == IInstructionReader.InstructionReaderEntry.Type.A32;
                    boolean bl = this.mIsARM64 = this.mIsARM64 || entry.type == IInstructionReader.InstructionReaderEntry.Type.A64;
                    if (this.mIsARM) {
                        if (decodeARM == null) {
                            decodeARM = new DecodeARM();
                        }
                        decodeARM.decodeArmOpcode(offset, opcode);
                    }
                    if (this.mIsARM64) {
                        if (decodeARM64 == null) {
                            decodeARM64 = new DecodeARM64();
                        }
                        decodeARM64.decodeArm64Opcode(offset, opcode);
                    }
                    this.mInstructions.put(offset, i);
                    break;
                }
                default: {
                    throw new AssertionError((Object)entry.type);
                }
            }
            ++i;
        }
        if (this.mIsARM64 && this.mFrameHeaderEnd == 0L && (function.getStack() == 0 && !function.hasStackFrame() || this.mFrameLeaf)) {
            i = startInstruction;
            while (i <= lastInstruction) {
                entry = instructionReader.get(i);
                switch (entry.type) {
                    case MARKER: {
                        break;
                    }
                    case T32: 
                    case A32: 
                    case A64: {
                        address = entry.address;
                        offset = function.getOffsetInFile(address);
                        if (this.mFrameHeaderEnd == 0L) {
                            this.mFrameHeaderEnd = offset;
                            break;
                        }
                        this.mFrameFooterEnd = this.mFrameFooterStart = offset;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)entry.type);
                    }
                }
                ++i;
            }
        }
        if (this.mIsARM && this.mFrameHeaderEnd == 0L && this.mFrameLeaf) {
            i = startInstruction;
            while (i <= lastInstruction) {
                entry = instructionReader.get(i);
                switch (entry.type) {
                    case MARKER: {
                        break;
                    }
                    case T32: 
                    case A32: 
                    case A64: {
                        address = entry.address;
                        this.mFrameFooterStart = this.mFrameHeaderEnd = (offset = function.getOffsetInFile(address));
                        this.mFrameFooterEnd = this.mFrameHeaderEnd;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)entry.type);
                    }
                }
                ++i;
            }
        }
    }

    public long getFrameFooter() {
        return this.mFrameFooterEnd;
    }

    public long getFrameFooterStart() {
        return this.mFrameFooterStart;
    }

    public long getFrameHeader() {
        return this.mFrameHeaderEnd;
    }

    public int getInstructionId(long offset) {
        return this.mInstructions.get(offset);
    }

    public boolean isARM64() {
        return this.mIsARM64;
    }

    public boolean isFrameLeaf() {
        return this.mFrameLeaf;
    }

    protected void frameFooterEnd() {
        if (this.mFrameFooterStart != 0L) {
            this.mFrameFooterEnd = this.mFrameFooterStart;
            this.mFrameFooterStart = 0L;
        }
    }

    protected void frameFooterEnd(long address) {
        this.mFrameFooterEnd = address;
    }

    protected void frameFooterStart(long address) {
        this.mFrameFooterStart = address;
    }

    protected void frameFooterStart_v8(long address) {
        if (this.mFrameFooterStart == 0L) {
            this.mFrameFooterStart = address;
        }
    }

    protected void frameHeaderEnd(long address) {
        this.mFrameHeaderEnd = address;
    }

    protected void frameHeaderStart(long address) {
        this.mFrameHeaderEnd = address;
    }

    protected void setFrameLeaf(boolean leaf) {
        this.mFrameLeaf = leaf;
    }

    private class DecodeARM {
        protected void decodeArmOpcode(long offset, int opcode) {
            block19: {
                block22: {
                    block23: {
                        block21: {
                            block20: {
                                int cond = FunctionHeaderFooter.field(opcode, 31, 28);
                                if (cond == 15 || (opcode & 0xFFFFFFF) == 27320335) break block19;
                                if ((opcode & 0xFFFFFFF) != 19922718 && (opcode & 0xFFFFFFF) != 77459460 && (opcode & 0xFFFFFFF) != 27324430) break block20;
                                FunctionHeaderFooter.this.frameFooterEnd();
                                break block19;
                            }
                            if ((opcode & 0xFFF0FFF) == 235343765 || (opcode & 0xE000090) == 144) break block19;
                            if ((opcode & 0xD000000) != 0) break block21;
                            this.decode_data_op(offset, opcode);
                            break block19;
                        }
                        if ((opcode & 0xF000000) != 0x1000000) break block22;
                        if ((opcode & 0x900000) != 0) break block23;
                        switch (FunctionHeaderFooter.field(opcode, 7, 4)) {
                            case 1: 
                            case 2: {
                                int rm;
                                if (FunctionHeaderFooter.field(opcode, 22, 21) == 1 && (rm = FunctionHeaderFooter.field(opcode, 3, 0)) == 14) {
                                    FunctionHeaderFooter.this.frameFooterEnd();
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block19;
                    }
                    this.decode_data_op(offset, opcode);
                    break block19;
                }
                if ((opcode & 0xF000000) == 0x3000000) {
                    if ((opcode & 0x900000) != 0) {
                        this.decode_data_op(offset, opcode);
                    }
                } else if ((opcode & 0xE000000) == 0x4000000) {
                    this.decode_load_store(offset, opcode);
                } else if ((opcode & 0xE000000) == 0x6000000) {
                    if (FunctionHeaderFooter.bit(opcode, 4) == 0) {
                        this.decode_load_store(offset, opcode);
                    }
                } else if ((opcode & 0xE000000) == 0x8000000) {
                    boolean load = FunctionHeaderFooter.flag(opcode, 20);
                    boolean write = FunctionHeaderFooter.flag(opcode, 21);
                    boolean s = FunctionHeaderFooter.flag(opcode, 22);
                    boolean add = FunctionHeaderFooter.flag(opcode, 23);
                    boolean pre = FunctionHeaderFooter.flag(opcode, 24);
                    int rn = FunctionHeaderFooter.field(opcode, 19, 16);
                    int list = FunctionHeaderFooter.field(opcode, 15, 0);
                    if (load) {
                        if ((list & 0x8000) != 0 && !pre && add && !s && write && rn == 13) {
                            FunctionHeaderFooter.this.frameFooterEnd();
                        } else if ((list & 0x800) != 0 && (list & 0x8000) == 0) {
                            FunctionHeaderFooter.this.frameFooterStart(offset);
                        }
                    } else if ((list & 0x4000) != 0) {
                        FunctionHeaderFooter.this.setFrameLeaf(false);
                    }
                }
            }
        }

        private void decode_data_op(long offset, int opcode) {
            int rd = FunctionHeaderFooter.field(opcode, 15, 12);
            if (rd == 11) {
                FunctionHeaderFooter.this.frameHeaderEnd(offset);
            }
        }

        private void decode_load_store(long offset, int opcode) {
            int rn = FunctionHeaderFooter.field(opcode, 19, 16);
            int rd = FunctionHeaderFooter.field(opcode, 15, 12);
            boolean writeback = FunctionHeaderFooter.flag(opcode, 21);
            boolean load = FunctionHeaderFooter.flag(opcode, 20);
            if (load) {
                if (rn == 13 && rd == 11) {
                    FunctionHeaderFooter.this.frameFooterStart(offset);
                }
            } else if (writeback && rn == 13) {
                switch (rd) {
                    case 11: {
                        FunctionHeaderFooter.this.frameHeaderStart(offset);
                        break;
                    }
                    case 14: {
                        FunctionHeaderFooter.this.setFrameLeaf(false);
                        break;
                    }
                }
            }
        }
    }

    private class DecodeARM64 {
        protected void decodeArm64Opcode(long offset, int opcode) {
            if ((opcode & 0x1F000000) == 0x11000000) {
                int rn = FunctionHeaderFooter.field(opcode, 9, 5);
                int rd = FunctionHeaderFooter.field(opcode, 4, 0);
                boolean sub = FunctionHeaderFooter.flag(opcode, 30);
                if (rn == 31 && rd == 29 && !sub) {
                    FunctionHeaderFooter.this.frameHeaderEnd(offset);
                    FunctionHeaderFooter.this.setFrameLeaf(false);
                }
            } else if ((opcode & 0xFE000000) == -704643072) {
                int opc = FunctionHeaderFooter.field(opcode, 24, 21);
                int op2 = FunctionHeaderFooter.field(opcode, 20, 16);
                int op3 = FunctionHeaderFooter.field(opcode, 15, 10);
                int op4 = FunctionHeaderFooter.field(opcode, 4, 0);
                if (opc == 2 && op2 == 31 && op3 == 0 && op4 == 0) {
                    FunctionHeaderFooter.this.frameFooterEnd(offset);
                }
            } else if ((opcode & 0x3B800000) == 0x28800000) {
                int opc = FunctionHeaderFooter.field(opcode, 31, 30);
                boolean v = FunctionHeaderFooter.flag(opcode, 26);
                boolean l = FunctionHeaderFooter.flag(opcode, 22);
                int rt2 = FunctionHeaderFooter.field(opcode, 14, 10);
                int rt = FunctionHeaderFooter.field(opcode, 4, 0);
                if (opc == 2 && !v && l && (rt2 == 29 || rt == 29)) {
                    FunctionHeaderFooter.this.frameFooterStart_v8(offset);
                }
            } else if ((opcode & 0x3B800000) == 0x29000000) {
                int opc = FunctionHeaderFooter.field(opcode, 31, 30);
                boolean v = FunctionHeaderFooter.flag(opcode, 26);
                boolean l = FunctionHeaderFooter.flag(opcode, 22);
                int rt2 = FunctionHeaderFooter.field(opcode, 14, 10);
                int rn = FunctionHeaderFooter.field(opcode, 9, 5);
                int rt = FunctionHeaderFooter.field(opcode, 4, 0);
                if (!(opc != 2 || v || l || rn != 31 || rt2 != 30 && rt != 30)) {
                    FunctionHeaderFooter.this.frameHeaderEnd(0L);
                    FunctionHeaderFooter.this.setFrameLeaf(false);
                } else if (opc == 2 && !v && l && rn == 31 && (rt2 == 30 || rt == 30)) {
                    FunctionHeaderFooter.this.frameFooterStart_v8(offset);
                }
            } else if ((opcode & 0x3B000000) == 0x39000000) {
                int size = FunctionHeaderFooter.field(opcode, 31, 30);
                boolean v = FunctionHeaderFooter.flag(opcode, 26);
                int opc = FunctionHeaderFooter.field(opcode, 23, 22);
                int rn = FunctionHeaderFooter.field(opcode, 9, 5);
                int rt = FunctionHeaderFooter.field(opcode, 4, 0);
                if (size == 3 && !v && opc == 0 && rn == 31 && rt == 30) {
                    FunctionHeaderFooter.this.frameHeaderEnd(0L);
                    FunctionHeaderFooter.this.setFrameLeaf(false);
                } else if (size == 3 && !v && opc == 1 && rn == 31 && rt == 30) {
                    FunctionHeaderFooter.this.frameFooterStart_v8(offset);
                }
            }
        }
    }
}

