/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.utils.StreamUtils;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CallpathLink {
    private @Nullable TIntObjectHashMap<CallpathLink> mChildrenByFunctionID;
    private final int mID;
    private final @Nullable CallpathLink mParent;
    private final @NonNull CallPathNodeType mType;
    private final long mValue;

    public static @NonNull CallpathLink createForProcess(@NonNull CallpathLink parent, @NonNull UniqueProcess uid) {
        assert (parent.mType == CallPathNodeType.VMUID && parent.mValue == ((AbstractPerVmId.PerVmNonUniquePid)uid.getNonUid().getId()).vmUID);
        return new CallpathLink(CallPathNodeType.UID, parent, uid.uid, uid.uid);
    }

    public static @NonNull CallpathLink createForThread(@NonNull CallpathLink parent, @NonNull UniqueThread uid) {
        assert (parent.mType == CallPathNodeType.UID && parent.mValue == (long)uid.process.uid);
        return new CallpathLink(CallPathNodeType.UID, parent, uid.uid, uid.uid);
    }

    public static @NonNull CallpathLink createForVmUID(int id, long vmUID) {
        return new CallpathLink(CallPathNodeType.VMUID, null, id, vmUID);
    }

    private CallpathLink(@NonNull CallPathNodeType type, @Nullable CallpathLink parent, int id, long value) {
        this.mType = type;
        this.mParent = parent;
        this.mID = id;
        this.mValue = value;
    }

    public @NonNull CallpathLink findOrAddChild(@NonNull IntSupplier idSupplier, int functionID) throws IOException {
        CallpathLink child;
        TIntObjectHashMap mChildrenByFunctionID = this.mChildrenByFunctionID;
        if (mChildrenByFunctionID == null) {
            this.mChildrenByFunctionID = mChildrenByFunctionID = new TIntObjectHashMap();
        }
        if ((child = (CallpathLink)mChildrenByFunctionID.get(functionID)) == null) {
            child = new CallpathLink(CallPathNodeType.FUNCTION, this, idSupplier.getAsInt(), functionID);
            mChildrenByFunctionID.put(functionID, (Object)child);
        }
        return child;
    }

    public @NonNull Stream<@NonNull CallpathLink> getStack() {
        return StreamUtils.whileNotNull((Object)this, CallpathLink::getParent);
    }

    public @NonNull Stream<@NonNull CallpathLink> getFunctionChildrenRecursive() {
        if (this.mChildrenByFunctionID != null) {
            return this.mChildrenByFunctionID.valueCollection().stream().flatMap(c -> StreamUtils.addFirst((Object)c, c.getFunctionChildrenRecursive()));
        }
        return Stream.empty();
    }

    public int getID() {
        return this.mID;
    }

    public @Nullable CallpathLink getParent() {
        return this.mParent;
    }

    public @NonNull CallPathNodeType getType() {
        return this.mType;
    }

    public long getValue() {
        return this.mValue;
    }

    public String toString() {
        return "CallpathLink [mID=" + this.mID + ", mType=" + String.valueOf(this.mType) + ", mValue=" + this.mValue + "]";
    }
}

