/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.processor.profile.CallpathLink;
import com.arm.streamline.analysis.processor.profile.ICallPathsFileWriter;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.streamline.report.model.CallPathNodeType;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CallPathsFileWriter
implements ICallPathsFileWriter {
    private final @NonNull LittleEndianDataOutputStream mCallchainsBIN;

    public CallPathsFileWriter(@NonNull File output) throws IOException {
        this.mCallchainsBIN = new LittleEndianDataOutputStream(output);
    }

    @Override
    public void add(@NonNull CallpathLink link) throws IOException {
        @NonNull CallPathNodeType type = link.getType();
        @Nullable CallpathLink parent = link.getParent();
        int linkID = link.getID();
        long value = link.getValue();
        this.mCallchainsBIN.writeLEInt(type.protocolValue);
        this.mCallchainsBIN.writeLEInt(linkID);
        this.mCallchainsBIN.writeLEInt(parent != null ? parent.getID() : -1);
        this.mCallchainsBIN.writeLELong(value);
    }

    @Override
    public void close() throws IOException {
        this.mCallchainsBIN.close();
    }
}

