/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.report.shared.io.IndexDataFile;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnnotateString {
    private AnnotateStringEntry[] mAnnotateStringEntry;

    public AnnotateString(SessionSettings settings, String path) throws IOException {
        int[] ticksScale = settings.getTicksPerScale();
        int[] timeScale = settings.getTimeScale();
        int length = timeScale.length;
        this.mAnnotateStringEntry = new AnnotateStringEntry[length];
        int i = 0;
        while (i < length) {
            this.mAnnotateStringEntry[i] = new AnnotateStringEntry(path, timeScale[i], ticksScale[i]);
            ++i;
        }
    }

    public void close(long tick) throws IOException {
        IOException firstException = null;
        AnnotateStringEntry[] annotateStringEntryArray = this.mAnnotateStringEntry;
        int n = this.mAnnotateStringEntry.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                AnnotateStringEntry ase = annotateStringEntryArray[n2];
                try {
                    ase.close(tick);
                }
                catch (IOException e) {
                    if (firstException != null) break block4;
                    firstException = e;
                }
            }
            ++n2;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void remove(long tick, @NonNull UniqueThread tid) throws IOException {
        AnnotateStringEntry[] annotateStringEntryArray = this.mAnnotateStringEntry;
        int n = this.mAnnotateStringEntry.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotateStringEntry ase = annotateStringEntryArray[n2];
            ase.remove(tick, tid);
            ++n2;
        }
    }

    public void write(long tick, @NonNull UniqueThread tid, int messageId, int channel) throws IOException {
        AnnotateStringEntry[] annotateStringEntryArray = this.mAnnotateStringEntry;
        int n = this.mAnnotateStringEntry.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotateStringEntry ase = annotateStringEntryArray[n2];
            ase.write(tick, tid, messageId, channel);
            ++n2;
        }
    }

    private static class AnnotateFrame {
        private static final int FRAME_START = 0x1000000;
        private static final int FRAME_STOP = 0x2000000;
        private long mTick;
        private TidChannelMidList mChangeLists;
        private TidChannelMid mStateList;
        private TidChannelSet mStop;
        private ByteArrayOutputStream mBuffer;
        private byte[] mScratch = new byte[4];

        public AnnotateFrame(long tick, TidChannelMidList changeLists) {
            this.mTick = tick;
            this.mChangeLists = changeLists;
            this.mBuffer = new ByteArrayOutputStream();
            this.mStateList = new TidChannelMid();
            this.mStop = new TidChannelSet();
        }

        public long getTick() {
            return this.mTick;
        }

        public boolean output(IndexDataFile toDisk, AnnotateFrame prev, AnnotateFrame next) throws IOException {
            boolean stop;
            boolean start;
            int channel;
            int n;
            int n2;
            int[] nArray;
            boolean hasStart = false;
            boolean hasStop = false;
            boolean hasNextStart = false;
            boolean empty = true;
            for (UniqueThread tid : this.mChangeLists.getThreadIDs()) {
                nArray = this.mChangeLists.getChannels(tid);
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    int messageId;
                    int[] messageIds;
                    channel = nArray[n];
                    TIntArrayList changeList = this.mChangeLists.getMids(tid, channel);
                    start = false;
                    stop = false;
                    empty = false;
                    int changeSize = changeList.size();
                    if (changeSize > 2) {
                        stop = true;
                        start = true;
                    } else if (changeSize == 2) {
                        start = true;
                        if (changeList.get(0) != 0) {
                            stop = true;
                        }
                    } else if (changeSize == 1) {
                        int message = changeList.get(0);
                        if (message > 0) {
                            start = true;
                        } else if (message == 0) {
                            stop = true;
                        }
                    }
                    if (prev != null && prev.mStop.hasChannel(tid, channel)) {
                        start = true;
                    }
                    if (next != null && next.mChangeLists.hasChanges(tid, channel) && !next.mChangeLists.isEndMessage(tid, channel)) {
                        stop = true;
                    }
                    int[] nArray2 = messageIds = changeList.toArray();
                    int n3 = messageIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        messageId = nArray2[n4];
                        this.add(messageId);
                        ++n4;
                    }
                    if (messageIds.length > 0) {
                        messageId = messageIds[messageIds.length - 1];
                        if (messageId > 0) {
                            this.mStateList.setMid(tid, channel, messageId);
                        } else {
                            this.mStateList.remove(tid, channel);
                            if (messageIds.length == 1 && prev != null) {
                                messageId = prev.mStateList.getMid(tid, channel);
                                this.add(messageId);
                            }
                        }
                    }
                    this.commit(toDisk, tid, channel, start, stop);
                    hasStart = hasStart || start;
                    hasStop = hasStop || stop;
                    ++n;
                }
            }
            if (prev != null) {
                for (UniqueThread tid : prev.mStateList.getThreadIDs()) {
                    nArray = prev.mStateList.getChannels(tid);
                    n2 = nArray.length;
                    n = 0;
                    while (n < n2) {
                        int messageId;
                        channel = nArray[n];
                        if (!this.mChangeLists.hasChanges(tid, channel) && !this.mStateList.hasChanges(tid, channel) && (messageId = prev.mStateList.getMid(tid, channel)) > 0) {
                            this.mStateList.setMid(tid, channel, messageId);
                        }
                        ++n;
                    }
                }
            }
            for (UniqueThread tid : this.mStateList.getThreadIDs()) {
                nArray = this.mStateList.getChannels(tid);
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    channel = nArray[n];
                    if (!this.mChangeLists.hasChanges(tid, channel)) {
                        int messageId = this.mStateList.getMid(tid, channel);
                        start = prev != null && prev.mStop.hasChannel(tid, channel);
                        stop = next != null && next.mChangeLists.hasChanges(tid, channel) && !next.mChangeLists.isEndMessage(tid, channel);
                        empty = false;
                        this.add(messageId);
                        this.commit(toDisk, tid, channel, start, stop);
                        hasStart = hasStart || start;
                        hasStop = hasStop || stop;
                    }
                    ++n;
                }
            }
            if (this.mChangeLists.getThreadIDs().size() == 0 && next != null && hasStop && !hasStart) {
                this.mTick = next.getTick() - 1L;
            }
            if (next != null && next.mChangeLists.hasChanges()) {
                hasNextStart = true;
            }
            if (empty) {
                toDisk.writeLEInt(-1);
            }
            toDisk.writeIndex(this.mTick);
            return hasStart || hasStop || hasNextStart;
        }

        private void add(int value) throws IOException {
            if (value <= 0) {
                return;
            }
            BufferUtils.writeLEInt((byte[])this.mScratch, (int)0, (int)value);
            this.mBuffer.write(this.mScratch);
        }

        private void commit(IndexDataFile toDisk, @NonNull UniqueThread tid, int channel, boolean start, boolean stop) throws IOException {
            assert ((tid.uid & 0xFF000000) == 0);
            int header = tid.uid & 0xFFFFFF;
            if (start) {
                header |= 0x1000000;
            }
            if (stop) {
                header |= 0x2000000;
                this.mStop.setChannel(tid, channel);
            }
            BufferUtils.writeLEInt((byte[])this.mScratch, (int)0, (int)header);
            toDisk.write(this.mScratch, 0, 4);
            BufferUtils.writeLEInt((byte[])this.mScratch, (int)0, (int)channel);
            toDisk.write(this.mScratch, 0, 4);
            BufferUtils.writeLEShort((byte[])this.mScratch, (int)0, (int)(this.mBuffer.size() / 4));
            toDisk.write(this.mScratch, 0, 2);
            this.mBuffer.writeTo((OutputStream)toDisk);
            this.mBuffer.reset();
        }
    }

    private static class AnnotateStringEntry {
        private TidChannelMidList mChangeLists = new TidChannelMidList();
        private TidChannelMid mActiveList = new TidChannelMid();
        private IndexDataFile mToDisk;
        private int mTimeScale;
        private long mTick;
        private AnnotateFrame mPrevFrame;
        private AnnotateFrame mCurrFrame;
        private AnnotateFrame mNextFrame;

        public AnnotateStringEntry(String path, int nameScale, int timeScale) throws IOException {
            String annotatePath = path + String.format("/data_%d.bin", nameScale);
            this.mToDisk = new IndexDataFile(annotatePath);
            this.mTimeScale = timeScale;
        }

        public void close(long tick) throws IOException {
            if (this.mActiveList != null) {
                @NonNull Set<@NonNull UniqueThread> threads = this.mActiveList.getThreadIDs();
                for (UniqueThread thread : threads) {
                    this.remove(tick, thread);
                }
            }
            this.output(tick / (long)this.mTimeScale, true);
            if (this.mToDisk != null) {
                this.mToDisk.close();
                this.mToDisk = null;
            }
        }

        public void remove(long tick, @NonNull UniqueThread tid) throws IOException {
            this.output(tick / (long)this.mTimeScale, false);
            int[] channels = this.mActiveList.getChannels(tid);
            if (channels != null) {
                int[] nArray = channels;
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    int channel = nArray[n2];
                    this.mChangeLists.setMidList(tid, channel, 0);
                    this.mActiveList.remove(tid, channel);
                    ++n2;
                }
            }
        }

        public void write(long tick, @NonNull UniqueThread tid, int messageId, int channel) throws IOException {
            this.output(tick / (long)this.mTimeScale, false);
            this.mActiveList.setMid(tid, channel, messageId);
            this.mChangeLists.setMidList(tid, channel, messageId);
        }

        private void output(long tick, boolean flush) throws IOException {
            boolean hasChanges = true;
            while (hasChanges && (this.mTick < tick || flush && (this.mNextFrame == null || this.mNextFrame.getTick() <= tick))) {
                this.mPrevFrame = this.mCurrFrame;
                this.mCurrFrame = this.mNextFrame;
                this.mNextFrame = new AnnotateFrame(this.mTick, this.mChangeLists);
                if (this.mCurrFrame != null) {
                    hasChanges = this.mCurrFrame.output(this.mToDisk, this.mPrevFrame, this.mNextFrame);
                }
                this.mChangeLists = new TidChannelMidList();
                ++this.mTick;
            }
            this.mTick = tick;
        }
    }

    private static class TidChannelMid {
        private Map<@NonNull UniqueThread, @NonNull TIntIntHashMap> mAnnotateMap = new HashMap<UniqueThread, TIntIntHashMap>();

        public @NonNull Set<@NonNull UniqueThread> getThreadIDs() {
            return this.mAnnotateMap.keySet();
        }

        protected int[] getChannels(@NonNull UniqueThread tid) {
            @Nullable TIntIntHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return null;
            }
            return channelList.keys();
        }

        protected int getMid(@NonNull UniqueThread tid, int channel) {
            TIntIntHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return 0;
            }
            return channelList.get(channel);
        }

        protected boolean hasChanges(@NonNull UniqueThread tid, int channel) {
            @Nullable TIntIntHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return false;
            }
            return channelList.containsKey(channel);
        }

        protected void remove(@NonNull UniqueThread tid, int channel) {
            @Nullable TIntIntHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList != null) {
                channelList.remove(channel);
            }
        }

        protected void setMid(@NonNull UniqueThread tid, int channel, int messageId) {
            TIntIntHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                channelList = new TIntIntHashMap();
                this.mAnnotateMap.put(tid, channelList);
            }
            channelList.put(channel, messageId);
        }
    }

    private static class TidChannelMidList {
        private final @NonNull Map<@NonNull UniqueThread, @NonNull TIntObjectHashMap<TIntArrayList>> mAnnotateMap = new HashMap<UniqueThread, TIntObjectHashMap<TIntArrayList>>();

        public @NonNull Set<@NonNull UniqueThread> getThreadIDs() {
            return this.mAnnotateMap.keySet();
        }

        protected int[] getChannels(@NonNull UniqueThread tid) {
            TIntObjectHashMap<TIntArrayList> channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return null;
            }
            return channelList.keys();
        }

        protected TIntArrayList getMids(@NonNull UniqueThread tid, int channel) {
            TIntObjectHashMap<TIntArrayList> channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return null;
            }
            TIntArrayList messageIds = (TIntArrayList)channelList.get(channel);
            if (messageIds == null) {
                return null;
            }
            return messageIds;
        }

        protected boolean hasChanges() {
            return !this.mAnnotateMap.isEmpty();
        }

        protected boolean hasChanges(@NonNull UniqueThread tid, int channel) {
            TIntObjectHashMap<TIntArrayList> channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return false;
            }
            return channelList.containsKey(channel);
        }

        protected boolean isEndMessage(@NonNull UniqueThread tid, int channel) {
            TIntArrayList list = this.getMids(tid, channel);
            if (list == null) {
                return false;
            }
            int[] nArray = list.toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int messageId = nArray[n2];
                if (messageId > 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected void setMidList(@NonNull UniqueThread tid, int channel, int messageId) {
            TIntArrayList messageIds;
            TIntObjectHashMap channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                channelList = new TIntObjectHashMap();
                this.mAnnotateMap.put(tid, (TIntObjectHashMap<TIntArrayList>)channelList);
            }
            if ((messageIds = (TIntArrayList)channelList.get(channel)) == null) {
                messageIds = new TIntArrayList();
                channelList.put(channel, (Object)messageIds);
            }
            messageIds.add(messageId);
        }
    }

    private static class TidChannelSet {
        private Map<UniqueThread, TIntHashSet> mAnnotateMap = new HashMap<UniqueThread, TIntHashSet>();

        protected boolean hasChannel(@NonNull UniqueThread tid, int channel) {
            TIntHashSet channelList = this.mAnnotateMap.get(tid);
            if (channelList == null) {
                return false;
            }
            return channelList.contains(channel);
        }

        protected void setChannel(@NonNull UniqueThread tid, int channel) {
            TIntHashSet setOfChannels = this.mAnnotateMap.get(tid);
            if (setOfChannels == null) {
                setOfChannels = new TIntHashSet();
                this.mAnnotateMap.put(tid, setOfChannels);
            }
            setOfChannels.add(channel);
        }
    }
}

