/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.utility.RGBUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AnnotateMarker
implements Closeable {
    private XMLGenerator mXml;

    public AnnotateMarker(String path) throws IOException {
        this.mXml = XMLGenerator.create((File)new File(path, "bookmarks.xml"));
        this.mXml.startDocument();
        this.mXml.startTag("bookmarks");
    }

    @Override
    public void close() throws IOException {
        this.mXml.endTag();
        this.mXml.endDocument();
        this.mXml.close();
    }

    public synchronized void write(List<Bookmark> bookmarks) throws IOException {
        for (Bookmark bookmark : bookmarks) {
            bookmark.save(this.mXml);
        }
    }

    public synchronized void write(long tick, int color, String text) throws IOException {
        Bookmark bookmark = new Bookmark(tick, RGBUtils.create(color), text);
        bookmark.save(this.mXml);
    }
}

