/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.model.AnalysisModel;
import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.ImageRecord;
import com.arm.streamline.analysis.model.ImageRecordMap;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.InstructionWriter;
import com.arm.streamline.analysis.processor.profile.JITFunctionRecord;
import com.arm.streamline.analysis.processor.profile.Profile;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.report.model.icounters.io.IFunctionsWriter;
import com.arm.streamline.report.model.icounters.io.structure.FunctionsWriter;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.utils.function.Throwing;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnalysisReportWriter {
    public static void write(@NonNull SessionSettings settings, @NonNull AnalysisModel model, @NonNull Profile profile, @NonNull IUniqueIds uniqueIds, boolean showProcesses, @NonNull ICaptureDetails captureDetails, String targetName, boolean is64bit, @Nullable TargetAddressString targetAddressStr, @Nullable SampleRate sampleRate, boolean applicationTracingMode) throws IOException {
        AnalysisReportWriter.writeImagesXML(settings, model, profile);
        AnalysisReportWriter.writeFunctionsXML(settings, model);
        AnalysisReportWriter.writeCallpathsXML(settings, uniqueIds, showProcesses);
        AnalysisReportWriter.writeStateXML(settings, model, targetAddressStr, sampleRate, targetName, captureDetails, is64bit, applicationTracingMode, captureDetails.getCaptureSubType());
        AnalysisReportWriter.writeAdditionalInstructions(settings, model);
    }

    private static void writeCallpathsXML(SessionSettings settings, @NonNull IUniqueIds uniqueIds, boolean showProcesses) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)new File(settings.getOutputPath(), "icounter/callpaths.xml"));){
            @NonNull TIntSet idleThreadUids = uniqueIds.getIdleUIDSet();
            xml.startDocument();
            xml.startTag("profile");
            xml.addAttribute("show_processes", showProcesses);
            Throwing.forEach((Stream)uniqueIds.getAllUniqueIdentifiers(), uid -> {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull AbstractPerVmId.PerVmNonUniquePidOrTid vmNonUniquePidOrTid = uid.getNonUid().getId();
                @Nullable UniqueProcess kernelProcess = uniqueIds.getKernelProcess(vmNonUniquePidOrTid.vmUID).orElse(null);
                xml.startEmptyTag("link");
                xml.addAttribute("id", uid.getUid());
                @Nullable @NonNull String nonUniqueName = uid.getNonUid().getName();
                @NonNull String name = idleThreadUids.contains(uid.uid) ? (nonUniqueName != null ? nonUniqueName : "idle") : (kernelProcess != null && kernelProcess.equals(uid) ? (nonUniqueName != null ? nonUniqueName : "kernel") : String.format("%s #%s", uid.getNonUid().getNameOrUnresolved(), Integer.toUnsignedString(vmNonUniquePidOrTid.id)));
                xml.addAttribute("name", name);
            });
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeDirectory(XMLGenerator xml, TObjectIntHashMap<String> directoryIndex, String name) throws IOException {
        if (!directoryIndex.containsKey((Object)name)) {
            directoryIndex.put((Object)name, directoryIndex.size());
            xml.startEmptyTag("dir");
            xml.addAttribute("name", name);
        }
    }

    private static void writeFile(@NonNull XMLGenerator xml, @NonNull String name, int dirID, int imageID, int fileID, long modified_time, long samples_offset, long samples_quantity) throws IOException {
        assert (!name.isEmpty());
        xml.startEmptyTag("file");
        xml.addAttribute("name", name);
        xml.addAttribute("dir", dirID);
        xml.addAttribute("image", imageID);
        xml.addAttribute("file", fileID);
        xml.addAttributeNot("modified_time", modified_time, 0L);
        xml.addAttribute("samples_offset", samples_offset);
        xml.addAttribute("samples_quantity", samples_quantity);
    }

    private static void writeFunctionsXML(SessionSettings settings, AnalysisModel model) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FunctionsWriter writer = new FunctionsWriter(settings.getOutputPath());){
            Throwing.forEachOrdered(model.getImageRecordMap().values().stream().flatMap(ImageRecord::getAllFunctionRecords).sorted(Comparator.comparing(IFunctionRecord::getID)), arg_0 -> AnalysisReportWriter.lambda$3((IFunctionsWriter)writer, arg_0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeImagesXML(SessionSettings settings, AnalysisModel model, Profile profile) throws IOException {
        ImageRecordMap irm = model.getImageRecordMap();
        Throwable throwable = null;
        Object var5_6 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)new File(settings.getOutputPath(), "/icounter/images.xml"));){
            TObjectIntHashMap directoryIndex = new TObjectIntHashMap(10, 0.5f, 0);
            xml.startDocument();
            xml.startTag("image_data");
            xml.startTag("dirs");
            AnalysisReportWriter.writeDirectory(xml, (TObjectIntHashMap<String>)directoryIndex, "");
            for (ImageRecord<?> ir : irm.values()) {
                @NonNull Set<@NonNull String> directories = ir.getSourceFileDirectories();
                for (String directory : directories) {
                    AnalysisReportWriter.writeDirectory(xml, (TObjectIntHashMap<String>)directoryIndex, directory);
                }
            }
            xml.endTag();
            xml.startTag("files");
            for (ImageRecord<?> ir : irm.values()) {
                @NonNull List<@NonNull SourcefileRecord> sourcefileRecords = ir.getSourceFileRecords();
                if (sourcefileRecords.isEmpty()) continue;
                int imageID = sourcefileRecords.get(0).getId();
                for (SourcefileRecord sfr : sourcefileRecords) {
                    String name = sfr.getName();
                    String directory = sfr.getDirectory();
                    long modified = sfr.created();
                    long samplesOffset = profile.getSamplesOffset(sfr);
                    long samplesQuantity = profile.getSamplesQuantity(sfr);
                    AnalysisReportWriter.writeFile(xml, name, directoryIndex.get((Object)directory), imageID, sfr.getId(), modified, samplesOffset, samplesQuantity);
                }
            }
            xml.endTag();
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeAdditionalInstructions(@NonNull SessionSettings settings, @NonNull AnalysisModel model) throws FileNotFoundException, IOException {
        @NonNull ImageRecordMap irm = model.getImageRecordMap();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InstructionWriter writer = new InstructionWriter(new File(settings.getOutputPath(), "icounter/instructions.bin"), false);){
            for (ImageRecord<?> ir : irm.values()) {
                for (JITFunctionRecord jfr : ir.getJITFunctionRecords()) {
                    jfr.writeInstructions(writer);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeStateXML(SessionSettings settings, AnalysisModel model, @Nullable TargetAddressString targetAddressStr, @Nullable SampleRate sampleRate, String targetName, @NonNull ICaptureDetails captureDetails, boolean is64bit, boolean applicationTracingMode, @NonNull CaptureSubType captureSubType) throws IOException {
        long duration = model.getDuration();
        Throwable throwable = null;
        Object var12_12 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)new File(settings.getOutputPath(), "state.xml"));){
            xml.startDocument();
            xml.startTag("state");
            xml.addAttribute("version", 20240408);
            xml.addAttribute("created", System.currentTimeMillis() / 1000L);
            xml.addAttribute("duration", duration);
            xml.addAttribute("resolution", settings.getResolutionMode().getStringValue());
            xml.addAttributeNot("mali_counters", model.hasMaliCounters(), false);
            xml.addAttributeNot("armnn_counters", model.hasArmNNCounters(), false);
            xml.addAttributeNot("arch64", is64bit, false);
            if (targetAddressStr != null) {
                xml.addAttribute("target_address", targetAddressStr.toString());
            }
            xml.addAttribute("target_name", targetName);
            if (sampleRate != null) {
                xml.addAttribute("sample_rate", sampleRate.name());
            }
            xml.addAttribute("protocol_type", captureDetails.getProtocolInfo().getType().xmlValue());
            xml.addAttributeNot("sub_type", captureSubType.xmlId, "");
            xml.addAttribute("gator_version", captureDetails.getProtocolInfo().getRawProtocolVersion());
            xml.addAttributeNot("application_mode", applicationTracingMode, false);
            xml.addAttribute("time_base_unit_short", captureDetails.getTimeUnit().getBaseSymbol());
            xml.addAttribute("time_base_unit_long", captureDetails.getTimeUnit().getBaseText());
            xml.addAttribute("time_base_unit_long_many", captureDetails.getTimeUnit().getBaseTextMany());
            xml.addAttribute("time_units_per_base", captureDetails.getTimeUnit().getNumberPerBase());
            @Nullable EventBasedSampleInfo ebsInfo = model.getEBSInfo();
            if (ebsInfo != null) {
                for (EventBasedSampleInfo.Event event : ebsInfo.getEvents()) {
                    xml.startEmptyTag("ebs");
                    xml.addAttribute("ebs_counter", event.getCounter());
                    xml.addAttribute("ebs_threshold", event.getThreshold());
                }
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$3(IFunctionsWriter iFunctionsWriter, IFunctionRecord fr) throws IOException {
        @Nullable SourcefileRecord sfr = fr.getFile();
        assert ("<anonymous>" != null);
        int fileId = sfr != null ? sfr.getId() : 0;
        iFunctionsWriter.write(fr.getID(), fr.getName(), fr.getSize(), fr.getStack(), fileId, fr.isScript(), fr.getFirstInstruction(), fr.getLastInstruction(), fr.getFirstSourceline(), fr.getLastSourceline(), fr.isUnknown());
    }
}

