/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.model.SourcefileRecordList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;

public final class JITSourcefileRecordList
implements SourcefileRecordList {
    private final @NonNull IntSupplier idSupplier;
    private final @NonNull List<@NonNull SourcefileRecord> sourcefileRecords = new ArrayList<SourcefileRecord>();
    private final @NonNull File captureDir;

    public JITSourcefileRecordList(@NonNull IntSupplier idSupplier, @NonNull File captureDir, @NonNull String imageName) {
        this.idSupplier = idSupplier;
        this.captureDir = captureDir;
        this.sourcefileRecords.add(new SourcefileRecord(idSupplier.getAsInt(), new File(imageName), Long.MIN_VALUE));
    }

    public @NonNull SourcefileRecord getOrCreate(@NonNull File sourceFile) {
        SourcefileRecord record2;
        for (SourcefileRecord record2 : this.sourcefileRecords) {
            if (!sourceFile.equals(record2.getFile())) continue;
            return record2;
        }
        record2 = new SourcefileRecord(this.idSupplier.getAsInt(), SourcefileRecordList.normalizeSourcePath(this.captureDir, sourceFile.getPath()), Long.MIN_VALUE);
        this.sourcefileRecords.add(record2);
        return record2;
    }

    @Override
    public @NonNull List<@NonNull SourcefileRecord> getList() {
        return Collections.unmodifiableList(this.sourcefileRecords);
    }
}

