/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.FunctionRecordMap;
import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.IdSuppliers;
import com.arm.streamline.analysis.model.ImageRecord;
import com.arm.streamline.analysis.model.JITSourcefileRecordList;
import com.arm.streamline.analysis.processor.profile.JITDumpStateBuilder;
import com.arm.streamline.analysis.processor.profile.JITFunctionRecord;
import com.arm.utils.function.IMultiIntSupplier;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;

public final class JITImageRecord
extends ImageRecord<JITSourcefileRecordList> {
    private final @NonNull Map< @NonNull JITDumpStateBuilder.JITCodeMapping, @NonNull JITFunctionRecord> jittedFunctions = new HashMap<JITDumpStateBuilder.JITCodeMapping, JITFunctionRecord>();
    private final @NonNull Map< @NonNull JITDumpStateBuilder.JITCode, @NonNull JITFunctionRecord.Shared> jittedFunctionsShared = new HashMap<JITDumpStateBuilder.JITCode, JITFunctionRecord.Shared>();

    public JITImageRecord(@NonNull File captureDir, @NonNull String name, @NonNull IdSuppliers idSuppliers) {
        super(idSuppliers);
        this.sourcefileList = new JITSourcefileRecordList((IntSupplier)idSuppliers.sourceFileIdSupplier, captureDir, name);
        this.functionMap = new FunctionRecordMap((IntSupplier)idSuppliers.functionIdSupplier);
    }

    @Override
    public @NonNull IFunctionRecord createJITFunctionRecordFor( @NonNull JITDumpStateBuilder.JITCodeMapping jittedCodeMapping) {
        boolean thumb = false;
        JITSourcefileRecordList sourcefileList = (JITSourcefileRecordList)this.sourcefileList;
        assert (sourcefileList != null);
        @NonNull JITFunctionRecord.Shared shared = this.jittedFunctionsShared.computeIfAbsent(jittedCodeMapping.code, d -> new JITFunctionRecord.Shared(sourcefileList, (JITDumpStateBuilder.JITCode)d, false));
        return this.jittedFunctions.computeIfAbsent(jittedCodeMapping, d -> new JITFunctionRecord((IntSupplier)this.idSuppliers.functionIdSupplier, (IMultiIntSupplier)this.idSuppliers.instructionIdSupplier, shared, (JITDumpStateBuilder.JITCodeMapping)d));
    }

    @Override
    public @NonNull List<@NonNull JITFunctionRecord> getJITFunctionRecords() {
        return new ArrayList<JITFunctionRecord>(this.jittedFunctions.values());
    }
}

