/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.FunctionRecord;
import com.arm.streamline.analysis.model.IdSuppliers;
import com.arm.streamline.analysis.model.ImageRecord;
import com.arm.streamline.analysis.model.ImageRecordName;
import com.arm.streamline.analysis.model.JITImageRecord;
import com.arm.streamline.analysis.model.NormalImageRecord;
import com.arm.streamline.analysis.model.ProfilerKernelModule;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.ImageNameAndPath;
import com.arm.streamline.analysis.processor.profile.InstructionWriter;
import com.arm.utils.collections.ObjLongPair;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TLongObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageRecordMap {
    private static final @NonNull String IDLE_NAME = "idle";
    private static final @NonNull String VM_LINUX_PREFIX = "vmlinux";
    private final @NonNull IdSuppliers idSuppliers;
    private final @NonNull File imagesDirectory;
    private @Nullable String mKernelName;
    private final @NonNull Map<@NonNull String, @NonNull ImageRecord<?>> imageRecords = new LinkedHashMap();
    private final @NonNull Set<@NonNull String> zipEntryEntities = new HashSet<String>();
    private final @NonNull Map<@NonNull String, @NonNull String> zipEntryEntitiesToKeys = new HashMap<String, String>();
    private final @NonNull File apcDirectory;

    public static boolean isKernel(String symbol) {
        return IDLE_NAME.equals(symbol) || "kernel".equals(symbol);
    }

    public ImageRecordMap(@NonNull String apcDirectory, @NonNull IdSuppliers idSuppliers) {
        this.idSuppliers = idSuppliers;
        this.apcDirectory = new File(apcDirectory).getAbsoluteFile();
        this.imagesDirectory = new File(apcDirectory, "/db/image-metadata");
        this.imageRecords.put("<anonymous>", new JITImageRecord(this.apcDirectory, "<anonymous>", idSuppliers));
    }

    public void close() {
        this.imageRecords.values().forEach(ImageRecord::close);
        this.imageRecords.clear();
    }

    public @NonNull List<@NonNull SourcefileRecord> getAllSourcefileRecords() {
        return this.imageRecords.values().stream().map(ImageRecord::getSourceFileRecords).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public @Nullable ObjLongPair<@NonNull FunctionRecord> getFunction(long vmUID, @Nullable ImageNameAndPath imageNameAndPath, long offsetOrAddress) {
        ImageRecord<?> ir = this.getImageRecord(imageNameAndPath);
        if (ir == null) {
            return null;
        }
        return ir.getFunction(vmUID, offsetOrAddress);
    }

    private @NonNull String getKernelName() {
        if (this.mKernelName == null) {
            if (this.imageRecords.containsKey(VM_LINUX_PREFIX)) {
                this.mKernelName = VM_LINUX_PREFIX;
            } else {
                for (String name : this.imageRecords.keySet()) {
                    if (!name.startsWith(VM_LINUX_PREFIX)) continue;
                    this.mKernelName = name;
                    break;
                }
            }
        }
        if (this.mKernelName == null) {
            this.mKernelName = "kernel";
        }
        return this.mKernelName;
    }

    public @NonNull ImageRecord<?> getOrCreateImageRecord(@NonNull String application) {
        String key = ImageRecordMap.isKernel(application) ? this.getKernelName() : application;
        return this.getOrCreateImageRecord(ImageRecordName.fromAppString(key, application));
    }

    public @NonNull ImageRecord<?> getOrCreateImageRecord(@NonNull ImageRecordName image) {
        String keyName = image.getKeyName();
        JITImageRecord imageRecord = this.getImageRecord(keyName, null, null);
        if (imageRecord != null) {
            return imageRecord;
        }
        String componentName = image.getComponentName();
        String entityName = image.getEntityName();
        imageRecord = new JITImageRecord(this.apcDirectory, keyName, this.idSuppliers);
        this.imageRecords.put(keyName, imageRecord);
        this.addZipEntryAlias(keyName, entityName);
        this.addZipEntryAlias(keyName, componentName);
        return imageRecord;
    }

    public @Nullable TIntIntMap getSourcefileRecordFunctions(@NonNull SourcefileRecord sfr) {
        for (ImageRecord<?> ir : this.imageRecords.values()) {
            @Nullable TIntIntMap result = ir.getSourcefileRecordFunctions(sfr);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void process(@NonNull ImageRecordName @NonNull [] images, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> modules, @NonNull InstructionWriter output) throws IOException, InterruptedException {
        Arrays.sort(images);
        ImageRecordName[] imageRecordNameArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            ImageRecordName image = imageRecordNameArray[n2];
            String keyName = image.getKeyName();
            String componentName = image.getComponentName();
            String entityName = image.getEntityName();
            File pathImages = image.getImagePath(this.imagesDirectory);
            String module = componentName.contentEquals("kernel") || componentName.startsWith(VM_LINUX_PREFIX) ? "" : (componentName.endsWith(".ko") ? componentName.substring(0, componentName.length() - 3) : componentName);
            this.imageRecords.put(keyName, new NormalImageRecord(this.apcDirectory, pathImages, modules, module, output, this.idSuppliers));
            this.addZipEntryAlias(keyName, entityName);
            this.addZipEntryAlias(keyName, componentName);
            ++n2;
        }
    }

    private void addZipEntryAlias(@NonNull String keyName, @Nullable String entityName) {
        if (entityName != null) {
            if (this.zipEntryEntities.add(entityName)) {
                this.zipEntryEntitiesToKeys.put(entityName, keyName);
            } else {
                this.zipEntryEntitiesToKeys.remove(entityName);
            }
        }
    }

    private @Nullable ImageRecord<?> getImageRecord(@Nullable ImageNameAndPath imageNameAndPath) {
        if (imageNameAndPath == null) {
            return this.getImageRecord(null, null, null);
        }
        return this.getImageRecord(imageNameAndPath.baseName, imageNameAndPath.filePath, imageNameAndPath.zipPath);
    }

    private @Nullable ImageRecord<?> getImageRecord(@Nullable String imageName, @Nullable String filePath, @Nullable String zipPath) {
        String keyName;
        String candidateImageName;
        ImageRecord<?> record;
        if (imageName == null || ImageRecordMap.isKernel(imageName)) {
            imageName = this.getKernelName();
        }
        if ((record = this.imageRecords.get(imageName)) == null) {
            record = this.imageRecords.get(imageName + ".ko");
        }
        if (record == null) {
            record = this.imageRecords.get(imageName + ".axf");
        }
        if (record == null && (candidateImageName = this.zipEntryEntitiesToKeys.get(keyName = zipPath != null ? zipPath : imageName)) != null) {
            record = this.imageRecords.get(candidateImageName);
        }
        return record;
    }

    public int getInstructionCount() {
        return this.idSuppliers.instructionIdSupplier.getCount();
    }

    public @NonNull Set<@NonNull Map.Entry<@NonNull String, @NonNull ImageRecord<?>>> entrySet() {
        return Collections.unmodifiableSet(this.imageRecords.entrySet());
    }

    public @NonNull Collection<@NonNull ImageRecord<?>> values() {
        return Collections.unmodifiableCollection(this.imageRecords.values());
    }

    public int size() {
        return this.imageRecords.size();
    }

    public @Nullable ImageRecord<?> get(@NonNull String key) {
        return this.imageRecords.get(key);
    }
}

