/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.FunctionRecord;
import com.arm.streamline.analysis.model.FunctionRecordMap;
import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.IdSuppliers;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.model.SourcefileRecordList;
import com.arm.streamline.analysis.processor.profile.JITFunctionRecord;
import com.arm.utils.StreamUtils;
import com.arm.utils.collections.ObjLongPair;
import gnu.trove.map.TIntIntMap;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ImageRecord<T extends SourcefileRecordList> {
    protected final @NonNull IdSuppliers idSuppliers;
    protected @Nullable FunctionRecordMap functionMap;
    protected @Nullable T sourcefileList;
    protected @Nullable FunctionRecord mUnknownFunctionRecord;

    protected ImageRecord(@NonNull IdSuppliers idSuppliers) {
        this.idSuppliers = idSuppliers;
    }

    public void close() {
        this.sourcefileList = null;
        this.functionMap = null;
    }

    public final @NonNull IFunctionRecord createUnknownFunctionRecord(@NonNull String name) {
        if (this.mUnknownFunctionRecord != null) {
            return this.mUnknownFunctionRecord;
        }
        this.mUnknownFunctionRecord = new FunctionRecord((IntSupplier)this.idSuppliers.functionIdSupplier, String.format("%s%s%s", "<unknown code in ", name, ">"));
        return this.mUnknownFunctionRecord;
    }

    public final @Nullable ObjLongPair<@NonNull FunctionRecord> getFunction(long vmUID, long offsetOrAddress) {
        @Nullable FunctionRecordMap functionMap = this.functionMap;
        assert (functionMap != null);
        return functionMap.findFunctionByOffset(vmUID, offsetOrAddress);
    }

    public final @NonNull FunctionRecordMap getFunctionRecordMap() {
        @Nullable FunctionRecordMap functionMap = this.functionMap;
        assert (functionMap != null);
        return functionMap;
    }

    public abstract @NonNull List<@NonNull JITFunctionRecord> getJITFunctionRecords();

    public final @NonNull Stream<@NonNull IFunctionRecord> getAllFunctionRecords() {
        List<JITFunctionRecord> jittedFunctions = this.getJITFunctionRecords();
        return StreamUtils.concat((Stream[])new Stream[]{StreamUtils.emptyIfNullOf((Object)this.mUnknownFunctionRecord), this.getFunctionRecordMap().getList().stream(), jittedFunctions.stream()});
    }

    public final @NonNull Set<@NonNull String> getSourceFileDirectories() {
        @Nullable T sourcefileList = this.sourcefileList;
        assert (sourcefileList != null);
        return sourcefileList.getList().stream().map(sfr -> sfr.getDirectory()).collect(Collectors.toSet());
    }

    public final @Nullable TIntIntMap getSourcefileRecordFunctions(@NonNull SourcefileRecord sfr) {
        @Nullable FunctionRecordMap functionMap = this.functionMap;
        assert (functionMap != null);
        return functionMap.getSourcelineFunctions(sfr);
    }

    public final @NonNull List<@NonNull SourcefileRecord> getSourceFileRecords() {
        @Nullable T sourcefileList = this.sourcefileList;
        assert (sourcefileList != null);
        return sourcefileList.getList();
    }

    public final @Nullable FunctionRecord getUnknownFunctionRecord() {
        return this.mUnknownFunctionRecord;
    }

    public abstract @NonNull IFunctionRecord createJITFunctionRecordFor( @NonNull JITDumpStateBuilder.JITCodeMapping var1);
}

