/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.FunctionHeaderFooter;
import com.arm.streamline.analysis.processor.profile.IInstructionReader;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionRecord
implements IFunctionRecord {
    private final long mAddress;
    private final @NonNull Map<@NonNull String, @Nullable String> mAliases;
    private @Nullable SourcefileRecord mSourceFile;
    private final @Nullable SourcefileRecord mImageFile;
    private int mFirstInstruction;
    private int mFirstSourceline;
    private final boolean mHasStackFrame;
    private final int mID;
    private int mLastInstruction;
    private int mLastSourceline;
    private final @NonNull String mName;
    private final long mOffset;
    private final int mSize;
    private final int mStack;

    public FunctionRecord() {
        this(() -> -1, 0L, 0L, 0, 0, false, "dummy", Collections.emptyMap(), null);
    }

    public FunctionRecord(@NonNull IntSupplier idSupplier, long address, long offset, int size, int stack, boolean hasStackFrame, @NonNull String name, @NonNull Map<@NonNull String, @Nullable String> aliasNames, @Nullable SourcefileRecord file) {
        this.mID = idSupplier.getAsInt();
        this.mAddress = address;
        this.mOffset = offset;
        this.mSize = size;
        this.mStack = stack;
        this.mHasStackFrame = hasStackFrame;
        this.mName = name;
        this.mAliases = aliasNames;
        this.mFirstInstruction = Integer.MAX_VALUE;
        this.mFirstSourceline = 0;
        this.mImageFile = file;
    }

    public FunctionRecord(@NonNull IntSupplier idSupplier, @NonNull String name) {
        this(idSupplier, 0L, 0L, 0, 0, false, name, Collections.emptyMap(), null);
    }

    public void addInstruction(int index, boolean isInlined, @Nullable SourcefileRecord file, int line) {
        if (index < this.mFirstInstruction) {
            this.mFirstInstruction = index;
        }
        if (index > this.mLastInstruction) {
            this.mLastInstruction = index;
        }
        if (isInlined || this.mSourceFile != null && !NullChecking.equalsNullable((Object)file, (Object)this.mSourceFile)) {
            return;
        }
        if (this.mFirstSourceline == 0 && line > 0) {
            this.mFirstSourceline = line;
        }
        if (line > this.mLastSourceline) {
            this.mLastSourceline = line;
        }
        if (this.mSourceFile == null) {
            this.mSourceFile = file;
        }
    }

    @Override
    public @NonNull FunctionHeaderFooter createFunctionHeaderFooter(@NonNull IInstructionReader instructionReader) throws IOException {
        return new FunctionHeaderFooter(this, instructionReader);
    }

    public long getAddress() {
        return this.mAddress;
    }

    @Override
    public @NonNull Map<@NonNull String, @Nullable String> getAliases() {
        return this.mAliases;
    }

    public long getEndOffset() {
        return this.mOffset + (long)this.mSize;
    }

    @Override
    public @Nullable SourcefileRecord getFile() {
        return this.mSourceFile != null ? this.mSourceFile : this.mImageFile;
    }

    @Override
    public int getFirstInstruction() {
        if (this.mFirstInstruction == Integer.MAX_VALUE) {
            return 0;
        }
        return this.mFirstInstruction;
    }

    @Override
    public int getFirstSourceline() {
        if (this.mFirstSourceline == Integer.MAX_VALUE) {
            return 0;
        }
        return this.mFirstSourceline;
    }

    @Override
    public int getID() {
        return this.mID;
    }

    @Override
    public int getLastInstruction() {
        return this.mLastInstruction;
    }

    @Override
    public int getLastSourceline() {
        return this.mLastSourceline;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public long getOffsetInFile(long address) {
        return address - this.mAddress + this.mOffset;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    @Override
    public int getStack() {
        return this.mStack;
    }

    public long getStartOffset() {
        return this.mOffset;
    }

    @Override
    public boolean hasStackFrame() {
        return this.mHasStackFrame;
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return this.mAddress == 0L && this.mSize == 0;
    }

    public String toString() {
        return "FunctionRecord [mAddress=0x" + Long.toHexString(this.mAddress) + ", mImageFile=" + String.valueOf(this.mImageFile) + ", mSourceFile=" + String.valueOf(this.mSourceFile) + ", mFirstInstruction=" + this.mFirstInstruction + ", mFirstSourceline=" + this.mFirstSourceline + ", mHasStackFrame=" + this.mHasStackFrame + ", mID=" + this.mID + ", mLastInstruction=" + this.mLastInstruction + ", mLastSourceline=" + this.mLastSourceline + ", mName=" + this.mName + ", mOffset=" + this.mOffset + ", mSize=" + this.mSize + ", mStack=" + this.mStack + "]";
    }
}

