/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.CAMTrackWriter;
import com.arm.streamline.model.cam.CAMTrack;
import com.arm.streamline.model.cam.CAM_Model;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class CAMViewData {
    public static final String CAM_REGEX_VIEW_NAME = "[^\\w\\-_ ]";
    public static final String CAM_REGEX_TRACK_NAME = "[^\\w\\-_ \\(\\)\\.:\\$\\^\\[\\]\\{\\}]";
    private final TIntObjectHashMap<CAMTrack> mTracks = new TIntObjectHashMap();
    private String mViewName;
    private int mIcon;
    private boolean mRestrictedHighlighting;
    private String mHotKey;

    public CAMViewData() {
    }

    public CAMViewData(String viewName, int icon, String hotkey, boolean restrictedHighlighting) {
        this.mViewName = viewName;
        this.mIcon = icon;
        this.mHotKey = hotkey;
        this.mRestrictedHighlighting = restrictedHighlighting;
    }

    public void addTrack(CAMTrack camTrack) {
        this.mTracks.put(camTrack.getId(), (Object)camTrack);
    }

    public String getHotKey() {
        return this.mHotKey;
    }

    public int getIcon() {
        return this.mIcon;
    }

    public TIntObjectIterator<CAMTrack> getTrackIterator() {
        return this.mTracks.iterator();
    }

    public String getViewName() {
        return this.mViewName;
    }

    public boolean isRestrictedHighlighting() {
        return this.mRestrictedHighlighting;
    }

    public void setHotKey(String hotKey) {
        this.mHotKey = hotKey;
    }

    public void setIcon(int icon) {
        this.mIcon = icon;
    }

    public void setRestrictedHighlighting(boolean restrictedHighlighting) {
        this.mRestrictedHighlighting = restrictedHighlighting;
    }

    public void setViewName(String viewName) {
        this.mViewName = viewName.replaceAll(CAM_REGEX_VIEW_NAME, "");
        if (this.mViewName.length() == 0) {
            this.mViewName = "-";
        }
    }

    public void write(@NonNull String dbDirectory, long vmUID) throws IOException {
        TIntObjectIterator<CAMTrack> tracks = this.getTrackIterator();
        String viewName = this.getViewName();
        if (tracks == null || !tracks.hasNext() || viewName == null) {
            throw new IOException(AnalysisMessages.INVALID_DATA_SET);
        }
        File viewDirectory = CAM_Model.getViewPath(new File(dbDirectory), vmUID, viewName);
        File tracksFile = new File(viewDirectory, "tracks.bin");
        CAMTrackWriter.write((File)tracksFile, tracks);
    }
}

