/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.analysis.model.IdSuppliers;
import com.arm.streamline.analysis.model.ImageRecordMap;
import com.arm.streamline.analysis.model.ImageRecordName;
import com.arm.streamline.analysis.model.ProfilerKernelModule;
import com.arm.streamline.analysis.processor.profile.InstructionWriter;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.utils.NullChecking;
import gnu.trove.map.TLongObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnalysisModel
extends AnalysisBase {
    private final @NonNull IAnalysisInputSettings mAnalysisInputSettings;
    private final @NonNull ICaptureDetails mCaptureDetails;
    private long mDuration;
    private @Nullable EventBasedSampleInfo mEBSInfo;
    private boolean mHasMaliCounters;
    private boolean mHasArmNNCounters;
    private @Nullable ImageRecordMap mImageRecordMap;
    private final @NonNull ImageRecordName @NonNull [] mImages;
    private final @NonNull String mInput;
    private final @NonNull String mOutput;
    private final @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> mModules;

    public AnalysisModel(@NonNull IAnalysisInputSettings analysisInputSettings, int durationLimitInSecs, @NonNull ImageRecordName @NonNull [] images, @NonNull String apcDirectory, @NonNull String output, @NonNull ICaptureDetails captureDetails, @NonNull SessionProcessor sp, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> modules) throws IOException {
        super(sp);
        long maxDuration;
        this.mAnalysisInputSettings = analysisInputSettings;
        this.mCaptureDetails = captureDetails;
        this.mImages = images;
        this.mInput = apcDirectory;
        this.mOutput = output;
        this.mModules = modules;
        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)new File(apcDirectory));
        @NonNull DBProperties dbProperties = DatabaseLayout.readDatabaseProperties((File)dbDirectory);
        this.mDuration = dbProperties.getDurationInNanosecs();
        ResolutionMode resolutionMode = analysisInputSettings.getResolutionMode();
        if (durationLimitInSecs > 0 && this.mDuration > (long)durationLimitInSecs * 1000000000L) {
            this.mDuration = (long)durationLimitInSecs * 1000000000L;
        }
        if (this.mDuration > (maxDuration = resolutionMode.toDensestZoomLevel().convertBinToNanoseconds(Integer.MAX_VALUE))) {
            switch (resolutionMode) {
                case SUMMARY: 
                case NORMAL: {
                    throw new IOException(AnalysisMessages.EXCEEDS_24_DAYS);
                }
                case HIGH: {
                    throw new IOException(AnalysisMessages.TOO_LONG_FOR_HI_RES);
                }
                case ULTRAHIGH: {
                    throw new IOException(AnalysisMessages.TOO_LONG_FOR_ULTRA_HI_RES);
                }
            }
            throw new AssertionError((Object)resolutionMode.getStringValue());
        }
        try {
            this.mHasMaliCounters = captureDetails.hasMaliCounters();
            this.mHasArmNNCounters = captureDetails.hasArmNNCounters();
            this.mEBSInfo = captureDetails.getEBSInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mImageRecordMap = new ImageRecordMap(this.mInput, new IdSuppliers());
        this.setName("AnalysisModel", output);
        this.setPriorityLower();
        this.start();
    }

    @Override
    public void close() {
        if (this.mImageRecordMap != null) {
            try {
                this.mImageRecordMap.close();
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }

    public @NonNull IAnalysisInputSettings getAnalysisInputSettings() {
        return this.mAnalysisInputSettings;
    }

    public @NonNull ICaptureDetails getCaptureDetails() {
        return this.mCaptureDetails;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public @Nullable EventBasedSampleInfo getEBSInfo() {
        return this.mEBSInfo;
    }

    public @NonNull ImageRecordMap getImageRecordMap() {
        return (ImageRecordMap)NullChecking.neverNull((Object)this.mImageRecordMap);
    }

    public boolean hasArmNNCounters() {
        return this.mHasArmNNCounters;
    }

    public boolean hasEBSCounter() {
        return this.mEBSInfo != null;
    }

    public boolean hasMaliCounters() {
        return this.mHasMaliCounters;
    }

    @Override
    protected void process() {
        try {
            @NonNull ImageRecordMap mImageRecordMap = (ImageRecordMap)NullChecking.neverNull((Object)this.mImageRecordMap);
            File output = new File(this.mOutput, "icounter/instructions.bin");
            ((File)NullChecking.neverNull((Object)output.getParentFile())).mkdirs();
            Throwable throwable = null;
            Object var4_7 = null;
            try (InstructionWriter writer = new InstructionWriter(output, true);){
                mImageRecordMap.process(this.mImages, this.mModules, writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            this.cancel();
        }
        catch (Exception e) {
            this.error(e);
        }
    }
}

