/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.emeter.EnergyType;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class EnergyMeterXML {
    private static final String TAG_CAPTURED = "captured";
    private static final String TAG_COUNTER = "counter";
    private static final String TAG_COUNTERS = "counters";
    private static final String TAG_TARGET = "target";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SAMPLE_RATE = "sample_rate";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_SOURCES = "sources";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CHANNEL = "channel";
    private IAnalysisHandler mHandler;
    private int mVersion;
    private int mSampleRate;
    private int mDataSources;
    private int mDataSize;
    private List<CounterRecord> mCounters = new ArrayList<CounterRecord>();
    private int mEnergyProbeCount;

    public EnergyMeterXML(byte[] xml, IAnalysisHandler handler) throws IOException {
        this.mHandler = handler;
        XMLParser in = null;
        try {
            in = XMLParser.create((InputStream)new ByteArrayInputStream(xml));
            this.parse(in);
        }
        catch (Throwable throwable) {
            CommonFileUtils.ignoredClose(in);
            throw throwable;
        }
        CommonFileUtils.ignoredClose((Closeable)in);
    }

    public EnergyMeterXML(@NonNull File apcPath, IAnalysisHandler handler) throws IOException {
        this.mHandler = handler;
        XMLParser in = null;
        try {
            in = XMLParser.create((File)new File(apcPath, "energy/captured.xml"));
            this.parse(in);
        }
        catch (Throwable throwable) {
            CommonFileUtils.ignoredClose(in);
            throw throwable;
        }
        CommonFileUtils.ignoredClose((Closeable)in);
    }

    public @NonNull CounterRecord createEnergyCounterRecord(int channel, int key) {
        EnergyType type = EnergyType.ENERGY;
        String counter = "Energy" + Integer.toString(this.mEnergyProbeCount++);
        String title = "Channel " + channel + " " + type.toString();
        String name = "Total";
        String description = "Total Energy";
        String units = type.getUnits();
        String expression = "";
        int source = key;
        CounterClass cclass = CounterClass.DELTA;
        CounterDisplay display = CounterDisplay.ACCUMULATE;
        boolean averageSelection = false;
        CounterRecord recordEnergy = new CounterRecord(counter, title, name, description, units, expression, Integer.valueOf(0xFF4F00), source, cclass, display, averageSelection, channel, type, 1.0E-6, SeriesComposition.OVERLAY, null);
        recordEnergy.setIgnore();
        recordEnergy.setAlignmentSupported(true);
        recordEnergy.setCores(1);
        return recordEnergy;
    }

    public List<CounterRecord> getArrayList() {
        return this.mCounters;
    }

    public CounterRecord[] getCounters() {
        return this.mCounters.toArray(new CounterRecord[0]);
    }

    public int getDataSize() {
        return this.mDataSize;
    }

    public int getDataSources() {
        return this.mDataSources;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getVersion() {
        return this.mVersion;
    }

    private void capturedCountersCountTag(XMLParser in) throws IOException {
        EnergyType type = EnergyType.get((String)in.getAttribute(ATTR_TYPE));
        String counter = "Energy" + Integer.toString(this.mEnergyProbeCount++);
        int source = in.getIntegerAttribute(ATTR_SOURCE, -1);
        int channel = in.getIntegerAttribute(ATTR_CHANNEL, -1);
        String title = "Channel " + channel + " " + type.toString();
        String name = "Average";
        String description = "Average";
        String units = type.getUnits();
        boolean averageSelection = true;
        CounterClass cclass = CounterClass.ABSOLUTE;
        CounterDisplay display = CounterDisplay.AVERAGE;
        String expression = "";
        if (source >= 0 && source < this.mDataSources) {
            CounterRecord cr = new CounterRecord(counter, title, name, description, units, expression, Integer.valueOf(15835136), source, cclass, display, averageSelection, channel, type, 0.001, SeriesComposition.OVERLAY, null);
            cr.setIgnore();
            cr.setAlignmentSupported(true);
            this.mCounters.add(cr);
        }
        in.skip();
    }

    private void capturedCountersTag(XMLParser in) throws IOException {
        String tag;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_COUNTER.equals(tag)) {
                this.capturedCountersCountTag(in);
                continue;
            }
            in.skip();
        }
    }

    private void capturedTag(XMLParser in) throws IOException {
        String tag;
        String marker = in.getMarker();
        this.mVersion = in.getIntegerAttribute(ATTR_VERSION, 1);
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_TARGET.equals(tag)) {
                this.capturedTargetTag(in);
                continue;
            }
            if (TAG_COUNTERS.equals(tag)) {
                this.capturedCountersTag(in);
                continue;
            }
            in.skip();
        }
    }

    private void capturedTargetTag(XMLParser in) throws IOException {
        this.mSampleRate = in.getIntegerAttribute(ATTR_SAMPLE_RATE, 0);
        this.mDataSources = in.getIntegerAttribute(ATTR_SOURCES, -1);
        this.mDataSize = in.getIntegerAttribute(ATTR_SIZE, -1);
        if (this.mDataSources >= 0 && this.mDataSize > 0) {
            if (this.mSampleRate <= 0) {
                WarningItem item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.HIGH, AnalysisMessages.EMETER_SAMPLE_RATE_UNDEFINED_TITLE, AnalysisMessages.EMETER_SAMPLE_RATE_UNDEFINED_DESCRIPTION);
                this.mHandler.warning(item);
                throw new IOException(AnalysisMessages.EMETER_SAMPLE_RATE_UNDEFINED_TITLE + "\n\n" + AnalysisMessages.EMETER_SAMPLE_RATE_UNDEFINED_DESCRIPTION);
            }
            if (this.mSampleRate % 1000 != 0) {
                WarningItem item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.HIGH, AnalysisMessages.EMETER_SAMPLE_RATE_INVALID_TITLE, AnalysisMessages.EMETER_SAMPLE_RATE_INVALID_DESCRIPTION);
                this.mHandler.warning(item);
                throw new IOException(AnalysisMessages.EMETER_SAMPLE_RATE_INVALID_TITLE + "\n\n" + AnalysisMessages.EMETER_SAMPLE_RATE_INVALID_DESCRIPTION);
            }
        }
        in.skip();
    }

    private void parse(XMLParser in) throws IOException {
        String tag;
        while ((tag = in.nextTag()) != null) {
            if (TAG_CAPTURED.equals(tag)) {
                this.capturedTag(in);
                continue;
            }
            in.skip();
        }
    }
}

