/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterCounter;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterXML;
import com.arm.streamline.analysis.processing.scheduler.AnalysisActivityActiveCounterAdapter;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.emeter.EnergyType;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.session.EnergyCaptureChannel;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.Throwing;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EnergyMeterCounters {
    private static final String ENERGY_WARNINGS_FILE = "/energy/warnings.xml";
    private static final String TAG_WARNINGS = "warnings";
    private static final String TAG_WARNING = "warning";
    private static final String ATTR_TEXT = "text";
    private static final double CORRELATION_FAILED = 0.3;
    private static final double CORRELATION_LOW = 0.5;
    private static final double CORRELATION_MODERATE = 0.7;
    private static final @NonNull ProcessingElementReference SYSTEM_WIDE_PEREF = ProcessingElementReference.create((DeviceType)DeviceType.SYSTEM_WIDE, (long)0L, (int)0);
    private double mCorrelationFactor = 0.0;
    private long mCorrelationOffset;
    private Integer mEnergyDelta;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void process(@NonNull IAnalysisReaderFactoryV2 analysisReaderFactory, @NonNull IThrowingFunction<@NonNull CounterRecord, @NonNull IAnalysisHardwareCounterWriter, IOException> counterWriterSupplier, @NonNull File apcPath, @NonNull IAnalysisHandler handler, EnergyCaptureSettings ecs, @Nullable Integer energyDelta, @NonNull TIntSet idleUtids, long stopTime) throws IOException {
        WarningItem item22;
        WarningItem item;
        block34: {
            this.mEnergyDelta = energyDelta;
            File warningsXML = CommonFileUtils.getFile((File)new File(apcPath, ENERGY_WARNINGS_FILE));
            if (warningsXML.exists()) {
                XMLParser in = null;
                try {
                    try {
                        String tag;
                        in = XMLParser.create((File)warningsXML);
                        while ((tag = in.nextTag()) != null) {
                            if (TAG_WARNINGS.equals(tag)) {
                                String marker = in.getMarker();
                                while ((tag = in.nextTag(marker)) != null) {
                                    if (TAG_WARNING.equals(tag) && in.hasAttribute(ATTR_TEXT)) {
                                        item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.LOW, AnalysisMessages.CAIMAN_WARNING_TITLE, (String)NullChecking.neverNullOr((Object)in.getAttribute(ATTR_TEXT), (Object)""));
                                        handler.warning(item);
                                    }
                                    in.skip();
                                }
                                continue;
                            }
                            in.skip();
                        }
                    }
                    catch (Exception e) {
                        if (!(e.getCause() instanceof XMLStreamException)) {
                            StreamlinePlugin.info(e);
                            item22 = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.LOW, AnalysisMessages.CAIMAN_WARNING_TITLE, (String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)""));
                            handler.warning(item22);
                        }
                        CommonFileUtils.ignoredClose((Closeable)in);
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    CommonFileUtils.ignoredClose((Closeable)in);
                    throw throwable;
                }
                CommonFileUtils.ignoredClose((Closeable)in);
            }
        }
        File emeterXML = new File(apcPath, "/energy/captured.xml");
        try {
            Throwable e = null;
            item22 = null;
            try (FileInputStream fis = new FileInputStream(emeterXML);){
                if (fis.getChannel().size() <= 0L) {
                    return;
                }
            }
            catch (Throwable item22) {
                if (e == null) {
                    e = item22;
                } else if (e != item22) {
                    e.addSuppressed(item22);
                }
                throw e;
            }
        }
        catch (Exception e) {
            return;
        }
        ArrayList<EnergyMeterCounter> counters = new ArrayList<EnergyMeterCounter>();
        try {
            IAnalysisActivityReader activityReader = analysisReaderFactory.getSchedulerTraceReaderStream().createReader();
            AnalysisActivityActiveCounterAdapter schedulerActivityCounterAdapter = new AnalysisActivityActiveCounterAdapter(stopTime, idleUtids, activityReader);
            counters.add(new EnergyMeterCounter(apcPath, handler, this, "Scheduler Trace Activity", (IAnalysisHardwareCounterReader)schedulerActivityCounterAdapter));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        @NonNull @NonNull Set counterStreams = analysisReaderFactory.enumerateCounterStreams();
        for (IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream stream : counterStreams) {
            @NonNull CounterRecord counter = stream.getCounterRecord();
            @NonNull DeviceType deviceType = counter.getDeviceTypeOrDefault();
            if (!deviceType.isCPU()) continue;
            String source = counter.getCounter();
            String title = counter.getTitle();
            String name = counter.getName();
            if (!source.endsWith("_ccnt") && (!"Clock".equals(title) || !"Cycles".equals(name))) continue;
            try {
                counters.add(new EnergyMeterCounter(apcPath, handler, this, source, stream.createReader()));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (EnergyMeterCounter counter : counters) {
            counter.join();
        }
        if (this.mCorrelationFactor < 0.3) {
            item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.MEDIUM, AnalysisMessages.CORRELATION, AnalysisMessages.FAILED_CORRELATION);
            handler.warning(item);
        } else if (this.mCorrelationFactor < 0.5) {
            item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.MEDIUM, AnalysisMessages.CORRELATION, AnalysisMessages.LOW_CORRELATION);
            handler.warning(item);
        } else if (this.mCorrelationFactor < 0.7) {
            item = new WarningItem(WarningType.ENERGY_METER, WarningSeverity.MEDIUM, AnalysisMessages.CORRELATION, AnalysisMessages.MODERATE_CORRELATION);
            handler.warning(item);
        }
        this.writeEnergyMeterCounters(apcPath, handler, ecs, counterWriterSupplier);
    }

    protected Integer getEnergyDelta() {
        return this.mEnergyDelta;
    }

    protected synchronized void updateCorrelation(double factor, long offset) {
        if (factor <= this.mCorrelationFactor || Double.isNaN(factor)) {
            return;
        }
        this.mCorrelationFactor = factor;
        this.mCorrelationOffset = offset;
    }

    private void writeEnergyMeterCounters(@NonNull File apcPath, IAnalysisHandler handler, EnergyCaptureSettings ecs, @NonNull IThrowingFunction<@NonNull CounterRecord, @NonNull IAnalysisHardwareCounterWriter, IOException> counterWriterSupplier) {
        block48: {
            CounterRecord[] allCounters = null;
            CounterRecord[] counters = null;
            ArrayList<CounterRecord> counterArray = new ArrayList<CounterRecord>();
            EnergyMeterXML emeterXML = null;
            TIntObjectHashMap counterWriters = new TIntObjectHashMap();
            TIntIntHashMap powerToEnergySourceMap = new TIntIntHashMap();
            try {
                try {
                    int n;
                    int n2;
                    Object object;
                    emeterXML = new EnergyMeterXML(apcPath, handler);
                    allCounters = emeterXML.getCounters();
                    int sources = emeterXML.getDataSources();
                    int scale = emeterXML.getSampleRate() / 1000;
                    int size = emeterXML.getDataSize();
                    int maxKey = 0;
                    CounterRecord[] counterRecordArray = allCounters;
                    int n3 = allCounters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CounterRecord cr = counterRecordArray[n4];
                        if (cr.getKey() > maxKey) {
                            maxKey = cr.getKey();
                        }
                        ++n4;
                    }
                    int baseEnergyKey = maxKey + 1;
                    EnergyCaptureChannel[] channels = ecs.getChannels();
                    if (channels != null && channels.length > 0) {
                        EnergyCaptureChannel[] energyCaptureChannelArray = channels;
                        int n5 = channels.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            EnergyCaptureChannel ecc = energyCaptureChannelArray[n6];
                            CounterRecord powerCR = null;
                            boolean powerCRadded = false;
                            object = allCounters;
                            n2 = allCounters.length;
                            n = 0;
                            while (n < n2) {
                                CounterRecord cr = object[n];
                                if (cr.getChannel() == ecc.getID()) {
                                    EnergyType type = cr.getEnergyType();
                                    if (type.equals((Object)EnergyType.POWER)) {
                                        powerCR = cr;
                                    }
                                    if (type.equals((Object)EnergyType.POWER) && ecc.isCollectPower() || type.equals((Object)EnergyType.CURRENT) && ecc.isCollectCurrent() || type.equals((Object)EnergyType.VOLTAGE) && ecc.isCollectVoltage()) {
                                        counterArray.add(cr);
                                        counterWriters.put(cr.getKey(), (Object)((IAnalysisHardwareCounterWriter)counterWriterSupplier.apply((Object)cr)));
                                        if (ecc.isCollectPower()) {
                                            powerCRadded = true;
                                        }
                                    }
                                }
                                ++n;
                            }
                            if (ecc.isCollectEnergy() && powerCR != null) {
                                CounterRecord energyCR = emeterXML.createEnergyCounterRecord(ecc.getID(), baseEnergyKey);
                                counterWriters.put(baseEnergyKey, (Object)((IAnalysisHardwareCounterWriter)counterWriterSupplier.apply((Object)energyCR)));
                                powerToEnergySourceMap.put(powerCR.getKey(), baseEnergyKey++);
                                if (!powerCRadded) {
                                    counterArray.add(powerCR);
                                }
                            }
                            ++n6;
                        }
                    }
                    counters = counterArray.toArray(new CounterRecord[0]);
                    long timeIncrement = 1000000L;
                    long time = 0L;
                    if (this.mCorrelationFactor >= 0.5) {
                        time -= this.mCorrelationOffset;
                    } else if (this.mEnergyDelta != null) {
                        time -= (long)this.mEnergyDelta.intValue() * 1000000L;
                    }
                    --time;
                    int fileCount = 0;
                    int[] keys = counterWriters.keys();
                    object = keys;
                    n2 = keys.length;
                    n = 0;
                    while (n < n2) {
                        CounterRecord key = object[n];
                        IAnalysisHardwareCounterWriter counterWriter = (IAnalysisHardwareCounterWriter)counterWriters.get((int)key);
                        counterWriter.consumerCounterValue(SYSTEM_WIDE_PEREF, time, null, 0L);
                        ++n;
                    }
                    while (!Thread.interrupted()) {
                        String energyFilename;
                        File energyFile;
                        if ((energyFile = new File(apcPath, energyFilename = String.format("energy/%010d", fileCount++))).exists() && energyFile.isFile()) {
                            int length = (int)(energyFile.length() / (long)sources / (long)size / (long)scale);
                            object = null;
                            Object var27_42 = null;
                            try (LittleEndianDataInputStream emeterInput = new LittleEndianDataInputStream(energyFile);){
                                int l = 0;
                                while (l < length) {
                                    long[] values = new long[sources];
                                    int sc = 0;
                                    while (sc < scale) {
                                        int s = 0;
                                        while (s < sources) {
                                            switch (size) {
                                                case 1: {
                                                    int n7 = s;
                                                    values[n7] = values[n7] + (long)emeterInput.read();
                                                    break;
                                                }
                                                case 2: {
                                                    int n8 = s;
                                                    values[n8] = values[n8] + (long)emeterInput.readLEShort();
                                                    break;
                                                }
                                                case 4: {
                                                    int n9 = s;
                                                    values[n9] = values[n9] + (long)emeterInput.readLEInt();
                                                    break;
                                                }
                                            }
                                            ++s;
                                        }
                                        ++sc;
                                    }
                                    time += timeIncrement;
                                    CounterRecord[] counterRecordArray2 = counters;
                                    int n10 = counters.length;
                                    int n11 = 0;
                                    while (n11 < n10) {
                                        int energySource;
                                        IAnalysisHardwareCounterWriter writer;
                                        CounterRecord counter = counterRecordArray2[n11];
                                        int key = counter.getKey();
                                        values[key] = (values[key] + (long)(scale / 2)) / (long)scale;
                                        IAnalysisHardwareCounterWriter writer2 = (IAnalysisHardwareCounterWriter)counterWriters.get(key);
                                        if (writer2 != null) {
                                            writer2.consumerCounterValue(SYSTEM_WIDE_PEREF, time, null, values[key]);
                                        }
                                        if (powerToEnergySourceMap.containsKey(key) && (writer = (IAnalysisHardwareCounterWriter)counterWriters.get(energySource = powerToEnergySourceMap.get(key))) != null) {
                                            writer.consumerCounterValue(SYSTEM_WIDE_PEREF, time, null, values[key]);
                                        }
                                        ++n11;
                                    }
                                    ++l;
                                }
                                continue;
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    handler.error((Throwable)e);
                    try {
                        Throwing.closeAll((Iterable[])new Iterable[]{(Iterable)NullChecking.neverNull((Object)counterWriters.valueCollection())});
                    }
                    catch (Exception e2) {
                        handler.error((Throwable)e2);
                    }
                    break block48;
                }
            }
            catch (Throwable throwable) {
                try {
                    Throwing.closeAll((Iterable[])new Iterable[]{(Iterable)NullChecking.neverNull((Object)counterWriters.valueCollection())});
                }
                catch (Exception e) {
                    handler.error((Throwable)e);
                }
                throw throwable;
            }
            try {
                Throwing.closeAll((Iterable[])new Iterable[]{(Iterable)NullChecking.neverNull((Object)counterWriters.valueCollection())});
            }
            catch (Exception e) {
                handler.error((Throwable)e);
            }
        }
    }
}

