/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterCorrelate;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterCounters;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterXML;
import com.arm.streamline.analysis.processing.binning.AnalysisDeltaBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisHardwareCounterSupplier;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class EnergyMeterCounter
extends AnalysisBase {
    private static final int LIVE_ENERGY_DELTA_FUDGE_FACTOR = 500;
    private final @NonNull EnergyMeterCounters mParent;
    private final @NonNull File apcPath;
    private final @NonNull List<@NonNull Task> mWorkerThreads = new ArrayList<Task>();
    private final @NonNull IAnalysisHardwareCounterReader counterChannelReader;

    public EnergyMeterCounter(@NonNull File apcPath, @NonNull IAnalysisHandler handler, @NonNull EnergyMeterCounters parent, @NonNull String counterName, @NonNull IAnalysisHardwareCounterReader counterChannelReader) {
        super(handler);
        this.apcPath = apcPath;
        this.mParent = parent;
        this.counterChannelReader = counterChannelReader;
        this.setName(String.format("Emeter Correlate[%s]", counterName), apcPath.getAbsolutePath());
        this.setPriorityLower();
        this.start();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process() {
        emeterXML = null;
        try {
            emeterXML = new EnergyMeterXML(this.apcPath, this.getHandler());
            energyFile = new File(this.apcPath, "energy/0000000000");
            sources = emeterXML.getDataSources();
            size = emeterXML.getDataSize();
            scale = emeterXML.getSampleRate() / 1000;
            length = (int)(energyFile.length() / (long)sources / (long)size / (long)scale);
            if (length > 61000) {
                length = 61000;
            }
            energyData = new long[length];
            var9_17 = null;
            var10_22 = null;
            try {
                emeterInput = new LittleEndianDataInputStream(energyFile);
                try {
                    i = 0;
                }
                finally {
                    if (i < energyData.length) {
                    }
                }
            }
            catch (Throwable var10_23) {
                if (var9_17 == null) {
                    var9_17 = var10_23;
                    throw var9_17;
                }
                if (var9_17 == var10_23) throw var9_17;
                var9_17.addSuppressed(var10_23);
                throw var9_17;
            }
        }
        catch (Exception e) {
            this.error(e);
            return;
        }
        position = 0;
        try {
            sources = null;
            size = null;
            try {
                binningReader = new AnalysisDeltaBinningThreadCounterReader((IAnalysisHardwareCounterSupplier)new IAnalysisHardwareCounterSupplier.AnalysisHardwareCounterReaderAdapter(IAnalysisBinningThreadCounterReader.toSystemWideAbsolute((IAnalysisHardwareCounterReader)this.counterChannelReader)));
                try {
                    length = energyData.length;
                    if (length >= 1000) {
                        length -= 1000;
                    }
                    gatorData = new long[length];
                    time = 1000000L;
                    lastCounterValues = new long[binningReader.getChannelCount()];
                    currentMax = new long[binningReader.getChannelCount()];
                }
                finally {
                    if (position < gatorData.length) {
                    }
                }
            }
            catch (Throwable size) {
                if (sources == null) {
                    sources = size;
                    throw sources;
                }
                if (sources == size) throw sources;
                sources.addSuppressed(size);
                throw sources;
            }
        }
        catch (Exception e) {
            this.error(e);
            return;
        }
        gatorDataTrimmed = new long[position];
        System.arraycopy(gatorData, 0, gatorDataTrimmed, 0, gatorDataTrimmed.length);
        try {
            deltaInt = this.mParent.getEnergyDelta();
            rangeStart = 0;
            rangeStop = 0;
            if (deltaInt == null) {
                rangeStart = -10000;
                rangeStop = 1000;
            } else {
                delta = deltaInt;
                rangeStart = delta - 500;
                rangeStop = delta + 500;
            }
            p = rangeStart;
            while (p < rangeStop) {
                if (this.isInterrupted()) {
                }
                this.mWorkerThreads.add(Task.callOnAnotherThread((Runnable)new EnergyMeterCorrelate(this.mParent, gatorDataTrimmed, energyData, (long)p * 1000000L, p)));
                ++p;
            }
        }
        finally {
            ** for (task : this.mWorkerThreads)
        }
lbl-1000:
        // 1 sources

        {
            task.join();
            continue;
        }
lbl90:
        // 1 sources

    }
}

