/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.gator.emeter.EnergyMeterCounters;

public class EnergyMeterCorrelate
implements Runnable {
    private EnergyMeterCounters mCounters;
    private long[] mGatorData;
    private long[] mEnergyData;
    private long mOffset;
    private int mIndex;

    private static double crossCorrelate(long[] x, long[] y, int index) {
        int yIndex;
        int xIndex = Math.max(0, -index);
        int n = Math.min(x.length - xIndex, y.length - (yIndex = Math.max(0, index)));
        if (n == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double mx = 0.0;
        double my = 0.0;
        int i = 0;
        while (i < n) {
            mx += (double)x[i + xIndex];
            my += (double)y[i + yIndex];
            ++i;
        }
        mx /= (double)n;
        my /= (double)n;
        double sx = 0.0;
        double sy = 0.0;
        i = 0;
        while (i < n) {
            sx += ((double)x[i + xIndex] - mx) * ((double)x[i + xIndex] - mx);
            sy += ((double)y[i + yIndex] - my) * ((double)y[i + yIndex] - my);
            ++i;
        }
        double denom = Math.sqrt(sx * sy);
        double sxy = 0.0;
        i = 0;
        while (i < n) {
            sxy += ((double)x[i + xIndex] - mx) * ((double)y[i + yIndex] - my);
            ++i;
        }
        double r = sxy / denom;
        return r;
    }

    public EnergyMeterCorrelate(EnergyMeterCounters counters, long[] gatorData, long[] energyData, long offset, int index) {
        this.mCounters = counters;
        this.mGatorData = gatorData;
        this.mEnergyData = energyData;
        this.mOffset = offset;
        this.mIndex = index;
    }

    @Override
    public void run() {
        double correlation = 0.0;
        try {
            correlation = EnergyMeterCorrelate.crossCorrelate(this.mGatorData, this.mEnergyData, this.mIndex);
            this.mCounters.updateCorrelation(correlation, this.mOffset);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

