/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterXML;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.GatorTarget;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;

public class EnergyMeterCapture
extends AnalysisBase {
    private static final int TIMEOUT = 3000;
    private static final String TAG_WARNINGS = "warnings";
    private static final String TAG_WARNING = "warning";
    private static final String ATTR_TEXT = "text";
    private final String mCapturePath;
    private Process mCaimanProcess;
    private GatorTarget mCaimanApplication;
    private EnergyMeterXML mEnergyMeterXML;
    private final OutputStream mOut;
    private final boolean mWriteToDisk;
    private long mStartTime;
    private boolean mCleanupRequested = false;

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "UNENCRYPTED_SOCKET"})
    public EnergyMeterCapture(@NonNull IAnalysisHandler handler, EnergyCaptureSettings settings, String capturePath, OutputStream os, boolean writeToDisk) throws IOException {
        super(handler);
        this.mCapturePath = capturePath;
        this.mOut = os;
        this.mWriteToDisk = writeToDisk;
        if (settings.shouldCapture()) {
            File energyExec = new File(settings.getResolvedCommandPath());
            if (!energyExec.isFile() || !energyExec.canExecute()) {
                throw new IOException(MessageFormat.format(AnalysisMessages.FAILED_TO_LAUNCH_EMETER, StreamlinePlugin.getCaimanReadmePath()));
            }
            File meterFile = new File(capturePath + "/energy");
            if (!meterFile.mkdirs()) {
                throw new IOException(MessageFormat.format(AnalysisMessages.FAILED_TO_LAUNCH_EMETER, StreamlinePlugin.getCaimanReadmePath()));
            }
            this.mCaimanProcess = Runtime.getRuntime().exec(settings.getCommandLine(meterFile.getAbsolutePath()));
            int MAX_RETRY_TIME_MS = 2000;
            int MAX_RETRY_GAP_MS = 250;
            int RETRY_COUNT = 8;
            Socket socket = null;
            boolean ipv6 = true;
            int i = 0;
            while (i < 8) {
                try {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipv6 ? "::1" : "localhost", settings.getPort()), 3000);
                    break;
                }
                catch (Exception e) {
                    ipv6 = !ipv6;
                    socket = null;
                    EnergyMeterCapture.sleep(250);
                    ++i;
                }
            }
            if (socket == null) {
                IOException error = this.readWarnings();
                if (error != null) {
                    throw error;
                }
                throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_COMMUNICATION_CAIMAN, StreamlinePlugin.getCaimanReadmePath()));
            }
            this.mCaimanApplication = new GatorTarget(socket, true, false);
            GatorProtocolVersion protocolVersion = new GatorProtocolVersion(this.mCaimanApplication.getProtocolVersionNumber());
            if (!protocolVersion.isCurrentVersion() && !protocolVersion.isCurrentDevBuild()) {
                throw new IOException(MessageFormat.format(AnalysisMessages.CAIMAN_MISMATCH, StreamlinePlugin.getCaimanReadmePath()));
            }
            byte[] xml = this.mCaimanApplication.requestXML("captured");
            Throwable throwable = null;
            Object var16_20 = null;
            try (FileOutputStream out = new FileOutputStream(new File(meterFile, "captured.xml"));){
                ((OutputStream)out).write(xml);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.mEnergyMeterXML = new EnergyMeterXML(xml, handler);
            this.mCaimanApplication.start();
            EnergyMeterCapture.sleep(100);
            this.setName("Caiman Socket", capturePath);
            this.start();
        }
    }

    public EnergyMeterXML getEnergyMeterXML() {
        return this.mEnergyMeterXML;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    @Override
    public void interrupt() {
        this.cleanup(false);
        super.interrupt();
    }

    @Override
    public void join() {
        this.cleanup(true);
        super.join();
    }

    @Override
    protected void process() {
        boolean readData;
        block19: {
            readData = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedOutputStream out = this.mWriteToDisk ? new BufferedOutputStream(new FileOutputStream(String.format("%s/energy/%010d", this.mCapturePath, 0))) : null;){
                        readData = this.processData(out);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.error(e);
                    this.cleanup(false);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                this.cleanup(false);
                throw throwable;
            }
            this.cleanup(false);
        }
        if (!this.isInterrupted() && !this.mCleanupRequested) {
            IOException error = this.readWarnings();
            if (readData) {
                if (error == null) {
                    this.warning(new WarningItem(WarningType.ENERGY_METER, WarningSeverity.HIGH, AnalysisMessages.CAIMAN_WARNING_TITLE, AnalysisMessages.CAIMAN_UNKNOWN_ERROR));
                }
                this.cancel();
            } else {
                if (error == null) {
                    error = new IOException(AnalysisMessages.CAIMAN_UNKNOWN_ERROR);
                }
                this.error(error);
            }
        }
    }

    private synchronized void cleanup(boolean graceful) {
        GatorTarget caimanApplication = this.mCaimanApplication;
        if (caimanApplication != null) {
            if (graceful) {
                this.mCleanupRequested = true;
            }
            try {
                caimanApplication.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mCaimanApplication = null;
        }
        if (this.mCaimanProcess != null) {
            if (graceful) {
                this.mCleanupRequested = true;
            }
            this.mCaimanProcess.destroy();
            this.mCaimanProcess = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processData(BufferedOutputStream diskOut) throws IOException {
        boolean firstData = true;
        while (!this.isInterrupted()) {
            byte[] buffer;
            block9: {
                try {
                    GatorTarget caimanApplication;
                    EnergyMeterCapture energyMeterCapture = this;
                    synchronized (energyMeterCapture) {
                        caimanApplication = this.mCaimanApplication;
                    }
                    if (caimanApplication == null) break;
                    buffer = caimanApplication.nextFrame();
                    if (!firstData) break block9;
                    firstData = false;
                    this.mStartTime = new Date().getTime();
                }
                catch (IOException e) {
                    break;
                }
            }
            if (buffer == null || buffer.length <= 0) break;
            if (this.mOut != null) {
                try {
                    this.mOut.write(buffer);
                }
                catch (IOException e) {
                    break;
                }
            }
            if (diskOut == null) continue;
            diskOut.write(buffer);
        }
        return !firstData;
    }

    private IOException readWarnings() {
        File warnings = new File(this.mCapturePath + "/energy/warnings.xml");
        if (!warnings.exists()) {
            return null;
        }
        XMLParser in = null;
        IOException error = null;
        try {
            try {
                String tag;
                in = XMLParser.create((File)warnings);
                String marker = in.getMarker();
                while ((tag = in.nextTag(marker)) != null) {
                    if (TAG_WARNINGS.equals(tag)) {
                        String warningsMarker = in.getMarker();
                        while ((tag = in.nextTag(warningsMarker)) != null) {
                            if (TAG_WARNING.equals(tag)) {
                                String text;
                                if (!in.hasAttribute(ATTR_TEXT) || error != null || (text = in.getAttribute(ATTR_TEXT)).startsWith("INFO: ")) continue;
                                error = new IOException(AnalysisMessages.CAIMAN_WARNING_TITLE + ":\n" + text);
                                continue;
                            }
                            in.skip();
                        }
                        continue;
                    }
                    in.skip();
                }
            }
            catch (IOException e) {
                if (error == null && !(e.getCause() instanceof XMLStreamException)) {
                    error = e;
                }
                CommonFileUtils.ignoredClose((Closeable)in);
            }
        }
        finally {
            CommonFileUtils.ignoredClose((Closeable)in);
        }
        return error;
    }
}

