/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator.emeter;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterXML;
import com.arm.streamline.analysis.model.CounterRecordUtils;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.emeter.EnergyType;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.model.live.ILiveAllBinDataProvider;
import com.arm.streamline.model.session.EnergyCaptureChannel;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.streamline.utility.RGBUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class EnergyConverter
extends AnalysisBase {
    public static final double ENERGY_SCALE = 0.001;
    public static final double ENERGY_SCALE_FOR_JOULES = 1.0E-6;
    private String mAPCPath;
    private EnergyCaptureSettings mECS;
    private ILiveAllBinDataProvider mAllBinDataProvider;
    private InputStream mIn;
    private int mSources;
    private int mCaimanSamplesPerMS;
    private int mSamplesPerBin;
    private int mSize;
    private CounterRecord[] mCounters;
    private TIntIntHashMap mPowerToEnergySourceMap = new TIntIntHashMap();

    private static int xmlSourceToLiveKey(int xmlSource) {
        return -3 - xmlSource;
    }

    public EnergyConverter(@NonNull IAnalysisHandler handler, String apcPath, EnergyCaptureSettings ecs, ILiveAllBinDataProvider liveData, EnergyMeterXML emeterXML, InputStream in) {
        super(handler);
        this.mIn = in;
        if (ecs.shouldCapture()) {
            try {
                this.mAPCPath = apcPath;
                this.mECS = ecs;
                this.mAllBinDataProvider = liveData;
                List<CounterRecord> allCounters = emeterXML.getArrayList();
                ArrayList<CounterRecord> subsetOfCounters = new ArrayList<CounterRecord>();
                this.mSources = emeterXML.getDataSources();
                this.mCaimanSamplesPerMS = emeterXML.getSampleRate() / 1000;
                this.mSamplesPerBin = this.mCaimanSamplesPerMS * 100;
                this.mSize = emeterXML.getDataSize();
                EnergyCaptureChannel[] channels = this.mECS.getChannels();
                if (channels == null || channels.length == 0) {
                    return;
                }
                Collections.sort(allCounters);
                int maxKey = 0;
                for (CounterRecord cr : allCounters) {
                    if (cr.getKey() <= maxKey) continue;
                    maxKey = cr.getKey();
                }
                int baseEnergyKey = maxKey + 1;
                EnergyCaptureChannel[] energyCaptureChannelArray = channels;
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    EnergyCaptureChannel ecc = energyCaptureChannelArray[n2];
                    CounterRecord powerCR = null;
                    boolean powerCRadded = false;
                    for (CounterRecord cr : allCounters) {
                        if (cr.getChannel() != ecc.getID()) continue;
                        EnergyType type = cr.getEnergyType();
                        if (type.equals((Object)EnergyType.POWER)) {
                            powerCR = cr;
                        }
                        if (!(type.equals((Object)EnergyType.POWER) && ecc.isCollectPower() || type.equals((Object)EnergyType.CURRENT) && ecc.isCollectCurrent()) && (!type.equals((Object)EnergyType.VOLTAGE) || !ecc.isCollectVoltage())) continue;
                        subsetOfCounters.add(cr);
                        if (ecc.isCollectPower()) {
                            powerCRadded = true;
                        }
                        RGB colorPeak = CounterRecordUtils.getColorRGB(cr);
                        RGB colorAverage = null;
                        if (colorPeak != null) {
                            colorAverage = RGBUtils.create(15835136);
                        }
                        if (this.mAllBinDataProvider == null) continue;
                        CounterRecord record = new CounterRecord(cr);
                        CounterRecordUtils.setColor(record, colorAverage);
                        record.setMultiplier(0.001);
                        record.setCounterClass(CounterClass.ABSOLUTE);
                        record.setDisplay(CounterDisplay.AVERAGE);
                        record.setCores(1);
                        record.setMode(CounterMode.SYSTEM_WIDE);
                        record.setAverageSelection(true);
                        record.setAverageCores(false);
                        record.setPercentage(false);
                        record.setSeriesComposition(SeriesComposition.OVERLAY);
                        record.setRenderingType(GraphRenderingType.FILLED);
                        record.setKey(EnergyConverter.xmlSourceToLiveKey(cr.getKey()));
                        this.mAllBinDataProvider.addEnergySource(record);
                    }
                    if (ecc.isCollectEnergy() && powerCR != null) {
                        CounterRecord energyCR = emeterXML.createEnergyCounterRecord(ecc.getID(), baseEnergyKey);
                        CounterRecord newEnergyCR = new CounterRecord(energyCR);
                        newEnergyCR.setKey(EnergyConverter.xmlSourceToLiveKey(baseEnergyKey));
                        this.mAllBinDataProvider.addEnergySource(newEnergyCR);
                        this.mPowerToEnergySourceMap.put(powerCR.getKey(), baseEnergyKey++);
                        if (!powerCRadded) {
                            subsetOfCounters.add(powerCR);
                        }
                    }
                    ++n2;
                }
                this.mCounters = subsetOfCounters.toArray(new CounterRecord[0]);
                this.setName("Energy Converter", this.mAPCPath);
                this.setPriorityLower();
                this.start();
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }

    @Override
    public void join() {
        this.interrupt();
        super.join();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void process() {
        try {
            try {
                int packetSize = this.mSources * this.mSize * this.mSamplesPerBin;
                byte[] packet = new byte[packetSize];
                long[] acc = new long[this.mSources];
                long[] max = new long[this.mSources];
                long[] min = new long[this.mSources];
                long[] oneMillisecondOfData = new long[this.mSources];
                while (!this.isInterrupted()) {
                    Arrays.fill(acc, 0L);
                    Arrays.fill(max, 0L);
                    Arrays.fill(min, Long.MAX_VALUE);
                    Arrays.fill(oneMillisecondOfData, 0L);
                    while (this.mIn.available() < packetSize && !this.isInterrupted()) {
                        Thread.sleep(10L);
                    }
                    if (this.isInterrupted()) continue;
                    int packetOffset = 0;
                    this.mIn.read(packet);
                    int millisecondBin = 0;
                    while (millisecondBin < 100) {
                        int sample = 0;
                        while (sample < this.mCaimanSamplesPerMS) {
                            int source = 0;
                            while (source < this.mSources) {
                                int value = 0;
                                switch (this.mSize) {
                                    case 1: {
                                        value = packet[packetOffset] & 0xFF;
                                        break;
                                    }
                                    case 2: {
                                        value = BufferUtils.readLEShort((byte[])packet, (int)packetOffset);
                                        break;
                                    }
                                    case 4: {
                                        value = BufferUtils.readLEInt((byte[])packet, (int)packetOffset);
                                        break;
                                    }
                                }
                                packetOffset += this.mSize;
                                int n = source++;
                                oneMillisecondOfData[n] = oneMillisecondOfData[n] + (long)value;
                            }
                            ++sample;
                        }
                        int source = 0;
                        while (source < this.mSources) {
                            long binValue = (oneMillisecondOfData[source] + (long)(this.mCaimanSamplesPerMS / 2)) / (long)this.mCaimanSamplesPerMS;
                            int n = source;
                            acc[n] = acc[n] + binValue;
                            if (binValue > max[source]) {
                                max[source] = binValue;
                            }
                            if (binValue < min[source]) {
                                min[source] = binValue;
                            }
                            oneMillisecondOfData[source] = 0L;
                            ++source;
                        }
                        ++millisecondBin;
                    }
                    if (this.mAllBinDataProvider == null) continue;
                    CounterRecord[] counterRecordArray = this.mCounters;
                    int n = this.mCounters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CounterRecord counter = counterRecordArray[n2];
                        int source = counter.getKey();
                        long avg = acc[source] / 100L;
                        if (this.mPowerToEnergySourceMap.containsKey(source)) {
                            int energySource = this.mPowerToEnergySourceMap.get(source);
                            this.mAllBinDataProvider.addData(CounterDisplay.ACCUMULATE, EnergyConverter.xmlSourceToLiveKey(energySource), acc[source]);
                        }
                        this.mAllBinDataProvider.addData(CounterDisplay.MAXIMUM, EnergyConverter.xmlSourceToLiveKey(source), max[source]);
                        this.mAllBinDataProvider.addData(CounterDisplay.MINIMUM, EnergyConverter.xmlSourceToLiveKey(source), min[source]);
                        this.mAllBinDataProvider.addData(CounterDisplay.AVERAGE, EnergyConverter.xmlSourceToLiveKey(source), avg);
                        ++n2;
                    }
                }
                return;
            }
            catch (InterruptedException packetSize) {
                if (this.mIn == null) return;
                try {
                    this.mIn.close();
                    return;
                }
                catch (Exception e) {
                    this.error(e);
                }
                return;
            }
            catch (Exception e) {
                this.error(e);
                if (this.mIn == null) return;
                try {
                    this.mIn.close();
                    return;
                }
                catch (Exception e2) {
                    this.error(e2);
                }
                return;
            }
        }
        finally {
            if (this.mIn != null) {
                try {
                    this.mIn.close();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
    }
}

