/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.gator.ICaptureRecordProtocol;
import com.arm.streamline.analysis.session.IFrameAddress;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;

public class Syncer<T extends IFrameAddress<T>> {
    private static final String TAG_MAX_TIME = "max_time";
    private static final String TAG_TIME_DELTA = "time_delta";
    private static final String TAG_SYNC_TIME = "sync_time";
    private static final String ATTR_VALUE = "value";
    private static final long MONOTONIC_DELTA_DEFAULT = Long.MIN_VALUE;
    private long mMonotonicDelta = Long.MIN_VALUE;
    private boolean mSyncMissing = false;
    private boolean mSyncFail = false;
    private final TLongArrayList mMaxTimes = new TLongArrayList();
    private final TLongArrayList mTimeDeltas = new TLongArrayList();
    private final TLongArrayList mSyncTime = new TLongArrayList();

    public long fixTime(ICaptureRecordProtocol<T> gpi, long time) {
        long jolt;
        if (this.mMonotonicDelta != Long.MIN_VALUE) {
            return time - this.mMonotonicDelta;
        }
        int i = 0;
        while (i < this.mMaxTimes.size()) {
            if (time <= this.mMaxTimes.get(i)) break;
            ++i;
        }
        if (i == this.mMaxTimes.size()) {
            if (!this.mSyncMissing && time - this.mMaxTimes.get(i - 2) > 10000000000L) {
                WarningItem item = new WarningItem(WarningType.CORRUPTION, WarningSeverity.LOW, AnalysisMessages.PERF_TIME_SYNC_FAIL_TITLE, AnalysisMessages.PERF_TIME_SYNC_MISSING_DESCRIPTION);
                gpi.warning(item);
                this.mSyncMissing = true;
            }
            this.mMaxTimes.set(i - 1, time);
            --i;
        }
        long fixedTime = (jolt = this.mTimeDeltas.get(i) - this.mTimeDeltas.get(i - 1)) > 0L && time < 2L * jolt + this.mMaxTimes.get(i - 1) ? time - this.mTimeDeltas.get(i - 1) - (time - this.mMaxTimes.get(i - 1) + 1L) / 2L : time - this.mTimeDeltas.get(i);
        return fixedTime < 0L ? 0L : fixedTime;
    }

    public boolean initialize() {
        if (this.initialized()) {
            return false;
        }
        if (this.mMonotonicDelta != Long.MIN_VALUE) {
            throw new RuntimeException("Invalid syncer state, trying to intiailize clock sync when using a monotonic offset");
        }
        this.mMaxTimes.add(Long.MIN_VALUE);
        this.mTimeDeltas.add(Long.MIN_VALUE);
        this.mSyncTime.add(Long.MIN_VALUE);
        this.mMaxTimes.add(Long.MIN_VALUE);
        this.mTimeDeltas.add(Long.MIN_VALUE);
        this.mSyncTime.add(Long.MIN_VALUE);
        return true;
    }

    public boolean initialized() {
        return !this.mTimeDeltas.isEmpty() || this.mMonotonicDelta != Long.MIN_VALUE;
    }

    public boolean read(XMLParser xml, String tag) {
        if (TAG_MAX_TIME.equals(tag)) {
            this.mMaxTimes.add(xml.getLongAttribute(ATTR_VALUE));
        } else if (TAG_TIME_DELTA.equals(tag)) {
            this.mTimeDeltas.add(xml.getLongAttribute(ATTR_VALUE));
        } else if (TAG_SYNC_TIME.equals(tag)) {
            this.mSyncTime.add(xml.getLongAttribute(ATTR_VALUE));
        } else {
            return false;
        }
        return true;
    }

    public boolean resyncTime(ICaptureRecordProtocol<T> gpi, long newTimeDelta, long time) {
        if (this.mMonotonicDelta != Long.MIN_VALUE) {
            return false;
        }
        if (time < this.mSyncTime.get(this.mSyncTime.size() - 1)) {
            return false;
        }
        if (this.mSyncTime.get(this.mSyncTime.size() - 1) > Long.MIN_VALUE && time - this.mSyncTime.get(this.mSyncTime.size() - 1) < 100000000L) {
            return false;
        }
        if (time - 1L > this.mMaxTimes.get(this.mMaxTimes.size() - 1)) {
            this.mMaxTimes.set(this.mMaxTimes.size() - 1, time - 1L);
        }
        this.mMaxTimes.add(this.mMaxTimes.get(this.mMaxTimes.size() - 1));
        this.mTimeDeltas.add(newTimeDelta);
        this.mSyncTime.add(time);
        if (!this.mSyncFail && this.mTimeDeltas.get(this.mTimeDeltas.size() - 2) > Long.MIN_VALUE && Math.abs(this.mTimeDeltas.get(this.mTimeDeltas.size() - 1) - this.mTimeDeltas.get(this.mTimeDeltas.size() - 2)) >= 100000000L) {
            WarningItem item = new WarningItem(WarningType.CORRUPTION, WarningSeverity.HIGH, AnalysisMessages.PERF_TIME_SYNC_FAIL_TITLE, AnalysisMessages.PERF_TIME_SYNC_FAIL_DESCRIPTION);
            gpi.warning(item);
            this.mSyncFail = true;
        }
        return true;
    }

    public void useDeltaInstead(long monotonicDelta) {
        if (!this.mTimeDeltas.isEmpty()) {
            throw new RuntimeException("Invalid syncer state, trying to initialize monotonic offset when using syncing clocks");
        }
        this.mMonotonicDelta = monotonicDelta;
    }

    public void write(XMLGenerator xml) throws IOException {
        int i = 0;
        while (i < this.mMaxTimes.size()) {
            xml.startEmptyTag(TAG_MAX_TIME);
            xml.addAttribute(ATTR_VALUE, this.mMaxTimes.getQuick(i));
            ++i;
        }
        i = 0;
        while (i < this.mTimeDeltas.size()) {
            xml.startEmptyTag(TAG_TIME_DELTA);
            xml.addAttribute(ATTR_VALUE, this.mTimeDeltas.getQuick(i));
            ++i;
        }
        i = 0;
        while (i < this.mSyncTime.size()) {
            xml.startEmptyTag(TAG_SYNC_TIME);
            xml.addAttribute(ATTR_VALUE, this.mSyncTime.getQuick(i));
            ++i;
        }
    }
}

