/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.UserFriendlyIOException;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.common.model.CommonModelMessages;
import com.arm.streamline.common.model.InvalidVersionException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;

public class GatorProtocolVerifier {
    public static final @NonNull IGatorProtocolVerificationExceptionFactory<InvalidVersionException> ANALYSIS_EXCEPTION_FACTORY = new IGatorProtocolVerificationExceptionFactory<InvalidVersionException>(){

        @Override
        public @NonNull InvalidVersionException getInvalidDevVersionException(@NonNull GatorProtocolVersion protocolVersion) {
            return InvalidVersionException.createGatorVersionTooOldException();
        }

        @Override
        public @NonNull InvalidVersionException getInvalidUnknownVersionException() {
            return InvalidVersionException.createGatorVersionTooOldException();
        }

        @Override
        public @NonNull InvalidVersionException getInvalidVersionExpectedCurrent() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return InvalidVersionException.createGatorVersionTooOldException();
        }

        @Override
        public @NonNull InvalidVersionException getInvalidVersionTooHighException(@NonNull GatorProtocolVersion protocolVersion) {
            return InvalidVersionException.createGatorVersionTooNewException();
        }

        @Override
        public @NonNull InvalidVersionException getInvalidVersionTooLowException(@NonNull GatorProtocolVersion protocolVersion) {
            return InvalidVersionException.createGatorVersionTooOldException();
        }
    };
    public static final @NonNull IGatorProtocolVerificationExceptionFactory<UserFriendlyIOException> LIVE_EXCEPTION_FACTORY = new IGatorProtocolVerificationExceptionFactory<UserFriendlyIOException>(){

        @Override
        public @NonNull UserFriendlyIOException getInvalidDevVersionException(@NonNull GatorProtocolVersion protocolVersion) {
            String protocolString = String.format("%08d", protocolVersion.getVersionNumber());
            return new UserFriendlyIOException(MessageFormat.format(AnalysisMessages.GATOR_DEV_BUILD, protocolString));
        }

        @Override
        public @NonNull UserFriendlyIOException getInvalidUnknownVersionException() {
            return new UserFriendlyIOException(AnalysisMessages.GATOR_MISMATCH_VERY_MIN);
        }

        @Override
        public @NonNull UserFriendlyIOException getInvalidVersionExpectedCurrent() {
            return new UserFriendlyIOException(CommonModelMessages.InvalidVersionException_LIVE_NOT_CURRENT);
        }

        @Override
        public @NonNull UserFriendlyIOException getInvalidVersionTooHighException(@NonNull GatorProtocolVersion protocolVersion) {
            String protocolString = String.format("%d", protocolVersion.getVersionNumber());
            return new UserFriendlyIOException(MessageFormat.format(AnalysisMessages.GATOR_MISMATCH_MAX, protocolString));
        }

        @Override
        public @NonNull UserFriendlyIOException getInvalidVersionTooLowException(@NonNull GatorProtocolVersion protocolVersion) {
            String protocolString = String.format("%d", protocolVersion.getVersionNumber());
            return new UserFriendlyIOException(MessageFormat.format(AnalysisMessages.GATOR_MISMATCH_MIN, protocolString));
        }
    };

    public static boolean isSuitableForLive(@NonNull GatorProtocolVersion protocolVersion) {
        return protocolVersion.isCurrentVersion() || protocolVersion.isCurrentDevBuild();
    }

    public static <T extends Throwable> void verifyProtocol(@NonNull ProtocolInfo info, @NonNull IGatorProtocolVerificationExceptionFactory<T> exceptionFactory) throws T {
        switch (info.getType()) {
            case PERF: {
                GatorProtocolVerifier.checkVersion(info.getGatorProtocolVersion(), exceptionFactory);
                break;
            }
            case UNKNOWN: {
                throw exceptionFactory.getInvalidUnknownVersionException();
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static <T extends Throwable> void checkVersion(@NonNull GatorProtocolVersion protocolVersion, @NonNull IGatorProtocolVerificationExceptionFactory<T> exceptionFactory) throws T {
        if (exceptionFactory.equals(LIVE_EXCEPTION_FACTORY)) {
            if (GatorProtocolVerifier.isSuitableForLive(protocolVersion)) {
                return;
            }
            throw exceptionFactory.getInvalidVersionExpectedCurrent();
        }
        if (!protocolVersion.isCompatible()) {
            if (protocolVersion.getVersionNumber() == 0) {
                throw exceptionFactory.getInvalidUnknownVersionException();
            }
            if (protocolVersion.isDevBuild()) {
                throw exceptionFactory.getInvalidDevVersionException(protocolVersion);
            }
            if (protocolVersion.compareTo(GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION) > 0) {
                throw exceptionFactory.getInvalidVersionTooHighException(protocolVersion);
            }
            throw exceptionFactory.getInvalidVersionTooLowException(protocolVersion);
        }
    }

    public static interface IGatorProtocolVerificationExceptionFactory<T extends Throwable> {
        public @NonNull T getInvalidDevVersionException(@NonNull GatorProtocolVersion var1);

        public @NonNull T getInvalidUnknownVersionException();

        public @NonNull T getInvalidVersionExpectedCurrent();

        public @NonNull T getInvalidVersionTooHighException(@NonNull GatorProtocolVersion var1);

        public @NonNull T getInvalidVersionTooLowException(@NonNull GatorProtocolVersion var1);
    }
}

