/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.common.model.counters.CounterRecord;
import org.eclipse.jdt.annotation.Nullable;

public class GatorCountersCE {
    private static final String[] SUPPORTED_COUNTERS = new String[]{"InstructionsExecuted", "ARM_Cortex-A5_cnt::8", "ARMv7_Cortex_A5_cnt::8", "ARM_Cortex-A7_cnt::8", "ARMv7_Cortex_A7_cnt::8", "ARM_Cortex-A8_cnt::8", "ARMv7_Cortex_A8_cnt::8", "ARM_Cortex-A9_cnt::104", "ARMv7_Cortex_A9_cnt::104", "ARM_Cortex-A12_cnt::8", "ARMv7_Cortex_A12_cnt::8", "ARM_Cortex-A15_cnt::8", "ARMv7_Cortex_A15_cnt::8", "ARM_Cortex-A53_cnt::8", "ARM_Cortex-A57_cnt::8", "Scorpion_cnt::8", "ScorpionMP_cnt::8", "Krait_cnt::8", "ARM_ARM11_cnt::7", "ARM_Cortex-A9_cnt::80", "ARMv7_Cortex_A9_cnt::80", "ARM_Cortex-A9_cnt::81", "ARMv7_Cortex_A9_cnt::81", "BranchMispredicted", "ARM_Cortex-A5_cnt::16", "ARMv7_Cortex_A5_cnt::16", "ARM_Cortex-A7_cnt::16", "ARMv7_Cortex_A7_cnt::16", "ARM_Cortex-A8_cnt::16", "ARMv7_Cortex_A8_cnt::16", "ARM_Cortex-A9_cnt::16", "ARMv7_Cortex_A9_cnt::16", "ARM_Cortex-A12_cnt::16", "ARMv7_Cortex_A12_cnt::16", "ARM_Cortex-A15_cnt::16", "ARMv7_Cortex_A15_cnt::16", "ARM_Cortex-A53_cnt::16", "ARM_Cortex-A57_cnt::16", "Scorpion_cnt::16", "ScorpionMP_cnt::16", "Krait_cnt::16", "ARM_ARM11_cnt::6", "ARM_ARM11MPCore_cnt::7", "UnalignedAccess", "ARM_Cortex-A5_cnt::15", "ARMv7_Cortex_A5_cnt::15", "ARM_Cortex-A7_cnt::15", "ARMv7_Cortex_A7_cnt::15", "ARM_Cortex-A8_cnt::15", "ARMv7_Cortex_A8_cnt::15", "ARM_Cortex-A9_cnt::15", "ARMv7_Cortex_A9_cnt::15", "ARM_Cortex-A9_cnt::15", "ARMv7_Cortex_A9_cnt::15", "Scorpion_cnt::15", "ScorpionMP_cnt::15", "Krait_cnt::15", "ARM_Cortex-A12_cnt::106", "ARMv7_Cortex_A12_cnt::106", "ARM_Cortex-A15_cnt::106", "ARMv7_Cortex_A15_cnt::106", "ARM_Cortex-A53_cnt::106", "ARM_Cortex-A57_cnt::106"};
    private static final String[] SUPPORTED_COUNTER_PATTERNS = new String[]{"^.*_ccnt::.*$", "^nonroot_.*$", "^.*ARM_Mali.*$", "^Linux_.*$", "^.*_system$", "^.*_user$", "^.*_irq$", "^.*_softirq$", "^.*_freq$", "^.*_switch$"};

    public static String getName(CounterRecord counter) {
        String name = counter.getCounter();
        @Nullable Long event = counter.getEvent();
        if (event != null) {
            int lastNumber = -1;
            int i = name.length() - 1;
            while (i > 0) {
                if (!Character.isDigit(name.charAt(i))) break;
                lastNumber = i--;
            }
            if (lastNumber > 0) {
                name = name.substring(0, lastNumber);
            }
            return String.format("%s::%d", name, event);
        }
        return name;
    }

    public static boolean isValid(CounterRecord counter) {
        String sc;
        String name = GatorCountersCE.getName(counter);
        String[] stringArray = SUPPORTED_COUNTERS;
        int n = SUPPORTED_COUNTERS.length;
        int n2 = 0;
        while (n2 < n) {
            sc = stringArray[n2];
            if (sc.contentEquals(name)) {
                return true;
            }
            ++n2;
        }
        stringArray = SUPPORTED_COUNTER_PATTERNS;
        n = SUPPORTED_COUNTER_PATTERNS.length;
        n2 = 0;
        while (n2 < n) {
            sc = stringArray[n2];
            if (name.matches(sc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

