/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.Messages;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesXMLParser;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicNumberUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorCapturedRawXML {
    private static final String ATTR_BACKTRACE_PROCESSING = "backtrace_processing";
    private static final String ATTR_CORES = "cores";
    private static final String ATTR_CPUID = "cpuid";
    private static final String ATTR_CREATED = "created";
    private static final String ATTR_ERROR = "error";
    private static final String ATTR_GATORD_BUILD_ID = "gatord_build_id";
    private static final String ATTR_GATORD_MD5 = "gatord_src_md5sum";
    private static final String ATTR_GPU_CORES = "gpu_cores";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ISPERFIMPORT = "is_perf_import";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_LIVE_ENERGY_DELTA = "live_energy_delta";
    private static final String ATTR_LOCAL_CAPTURE = "local_capture";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OFF_CPU_PROFILING = "off_cpu_profiling";
    private static final String ATTR_OS = "os";
    private static final String ATTR_OS_VERSION = "os_version";
    private static final String ATTR_PROCESS_NAME = "process_name";
    private static final String ATTR_PACKAGE_NAME = "package_name";
    private static final String ATTR_ACTIVITY_NAME = "activity_name";
    private static final String ATTR_ACTIVITY_ARGUMENTS = "activity_arguments";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_SAMPLE_RATE = "sample_rate";
    private static final String ATTR_SAMPLE_RATE_GPU = "sample_rate_gpu";
    private static final String ATTR_STREAMLINE_VERSION = "streamline_version";
    private static final String ATTR_SUPPORTS_LIVE = "supports_live";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_CAPTURED = "captured";
    private static final String TAG_COUNTER = "counter";
    private static final String TAG_COUNTERS = "counters";
    private static final String TAG_GPU = "gpu";
    private static final String TAG_GPUS = "gpus";
    private static final String TAG_PROCESS = "process";
    private static final String TAG_SPE = "spe";
    private static final String TAG_TARGET = "target";
    private static final String TAG_TEMPLATES = "templates";
    private static final int VERSION = 1;
    private final @Nullable String buildID;
    private final @Nullable String gdMd5Sum;
    private final @Nullable Integer gpuCoresCount;
    private final @NonNull BacktraceProcessing mBacktraceProcessing;
    private final int mCoreCount;
    private final @NonNull List<@NonNull CounterRecord> mCounterList;
    private final int mCpuId;
    private final long mCreated;
    private @Nullable String mError;
    private final boolean mIsPerfImport;
    private @Nullable Integer mLiveEnergyDelta;
    private final boolean mLocalCapture;
    private final @NonNull TIntSet mMaliGpuIds;
    private final @Nullable String mName;
    private final @Nullable String mOs;
    private final @Nullable String mOsVersion;
    private final @Nullable String mProcessName;
    private final @Nullable String mAndroidPackage;
    private final @Nullable String mAndroidActivity;
    private final @Nullable String mAndroidActivityFlags;
    private final @NonNull ProtocolInfo mProtocolInfo;
    private final int mSampleRate;
    private final int mSampleRateGpu;
    private final @NonNull TIntObjectMap<@NonNull String> mSpeKeys;
    private @NonNull GatorProtocolVersion mStreamlineVersion;
    private final boolean mSupportsLive;
    private final @NonNull List<@NonNull TemplateFile> mTemplateList;
    private final boolean offCpuProfiling;

    public static void createCountersFromCapturedAndEventsXml(boolean logMissing, @NonNull List<@NonNull CounterRecord> createdCounters, @NonNull Set<@NonNull SpeCaptureRecord> createdSpes, int coreCount, @NonNull Map<String, StockCounter> stockCounterMap, @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescriptions, @NonNull GatorCapturedRawXML capturedXML) throws IOException {
        if (coreCount <= 0) {
            throw new IOException(AnalysisMessages.INVALID_CORES_COUNT);
        }
        Iterator<CounterRecord> iterator = capturedXML.getCounterList().iterator();
        while (iterator.hasNext()) {
            CounterRecord capturedCounter;
            @NonNull CounterRecord counterToAppend = capturedCounter = iterator.next();
            if (GatorCapturedRawXML.isCounterClassConstant(capturedCounter.getCounterClass()) || stockCounterMap.isEmpty()) {
                GatorCapturedRawXML.addCounter(createdCounters, counterToAppend);
                continue;
            }
            String counterName = capturedCounter.getCounter();
            if (counterName == null) continue;
            @Nullable Long event = capturedCounter.getEvent();
            @NonNull String counterNameLookupValue = counterName.replaceAll("_cnt\\d+$", "_cnt0");
            @Nullable TargetCounter targetCounter = TargetCounter.find(stockCounterMap, (String)counterNameLookupValue, (Long)event);
            if (targetCounter != null) {
                String qualifiedName = targetCounter.getQualifiedName();
                StockCounter stockCounter = targetCounter.getDerivedFrom();
                counterToAppend = new CounterRecord(capturedCounter, stockCounter, qualifiedName);
            } else {
                if (logMissing) {
                    CommonPlugin.info((String)("Ignoring " + counterName + " as it is not found in events XML."));
                }
                if (capturedCounter.getTitle() == null || capturedCounter.getTitle().isBlank()) {
                    capturedCounter.setTitle(counterName);
                }
                if (capturedCounter.getName() == null || capturedCounter.getName().isBlank()) {
                    capturedCounter.setName(counterName);
                }
            }
            GatorCapturedRawXML.addCounter(createdCounters, counterToAppend);
        }
        @NonNull TIntObjectMap<@NonNull String> speKeys = capturedXML.getSpeKeys();
        int[] nArray = speKeys.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int key = nArray[n2];
            String speid = (String)speKeys.get(key);
            @NonNull Optional<@NonNull SpeTargetDescription> speTarget_found = speTargetDescriptions.stream().filter(spe -> spe.getId().equals(speid)).findFirst();
            if (!speTarget_found.isPresent()) {
                throw new IOException(AnalysisMessages.NO_SPE_TARGET_DESCRIPTION + " \"" + speid + "\"");
            }
            @NonNull SpeTargetDescription speTargetDescription = speTarget_found.get();
            SpeCaptureRecord speRecord = new SpeCaptureRecord(speTargetDescription, key);
            createdSpes.add(speRecord);
            ++n2;
        }
    }

    public static @NonNull CaptureSubType getCaptureSubType(@Nullable String os) {
        if (os == null) {
            return CaptureSubType.DEFAULT;
        }
        switch (os.toLowerCase()) {
            case "linux": {
                return CaptureSubType.LINUX;
            }
            case "android": {
                return CaptureSubType.ANDROID;
            }
        }
        return CaptureSubType.DEFAULT;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull GatorCapturedRawXML read(XMLParser in) throws IOException {
        Integer liveEnergyDelta = null;
        long created = 0L;
        BacktraceProcessing backtraceProcessing = BacktraceProcessing.get(null);
        GatorProtocolVersion streamlineVersion = null;
        ProtocolInfo protocolInfo = null;
        boolean isPerfImport = false;
        String error = null;
        String gdMd5Sum = null;
        String buildId = null;
        String name = null;
        String processName = null;
        String packageName = null;
        String activityName = null;
        String activityArguments = null;
        int sampleRate = 0;
        int sampleRateGpu = 0;
        int coreCount = 0;
        int gpuCoreCount = 0;
        int cpuId = 0;
        boolean supportsLive = false;
        boolean localCapture = false;
        boolean offCpuProfiling = false;
        String os = null;
        String osVersion = null;
        @NonNull ArrayList<@NonNull CounterRecord> counterList = new ArrayList<CounterRecord>();
        @NonNull ArrayList<@NonNull TemplateFile> templates = new ArrayList<TemplateFile>();
        @NonNull @NonNull TIntObjectHashMap speKeys = new TIntObjectHashMap();
        @NonNull TIntHashSet maliGpuIds = new TIntHashSet(10, 0.5f, 0);
        try {
            String tag;
            String marker = in.getMarker();
            while ((tag = in.nextTag(marker)) != null) {
                block46: {
                    if (!TAG_CAPTURED.equals(tag)) break block46;
                    if (in.getIntegerAttribute(ATTR_VERSION, 0) != 1) {
                        throw new IOException("Captured XML version is not v1");
                    }
                    liveEnergyDelta = in.hasAttribute(ATTR_LIVE_ENERGY_DELTA) ? Integer.valueOf(in.getIntegerAttribute(ATTR_LIVE_ENERGY_DELTA, 0)) : null;
                    created = in.getLongAttribute(ATTR_CREATED, System.currentTimeMillis() / 1000L);
                    backtraceProcessing = BacktraceProcessing.get(in.getAttribute(ATTR_BACKTRACE_PROCESSING));
                    streamlineVersion = new GatorProtocolVersion(in.getIntegerAttribute(ATTR_STREAMLINE_VERSION, 0));
                    @NonNull ProtocolType protocolType = (ProtocolType)NullChecking.neverNull((Object)ProtocolType.get((String)in.getAttribute(ATTR_TYPE)));
                    int protocolVersionNumber = in.getIntegerAttribute(ATTR_PROTOCOL, 0);
                    protocolInfo = new ProtocolInfo(protocolType, protocolVersionNumber);
                    isPerfImport = in.isAttributeSet(ATTR_ISPERFIMPORT);
                    error = in.hasAttribute(ATTR_ERROR) ? in.getAttribute(ATTR_ERROR) : null;
                    String capturedMarker = in.getMarker();
                    block24: while ((tag = in.nextTag(capturedMarker)) != null) {
                        switch (tag) {
                            case "gpus": {
                                String gpusMarker = in.getMarker();
                                while ((tag = in.nextTag(gpusMarker)) != null) {
                                    if (TAG_GPU.equals(tag)) {
                                        try {
                                            int id = BasicNumberUtils.decodeUnsignedInt((String)in.getAttribute(ATTR_ID, "0"));
                                            maliGpuIds.add(id);
                                            continue;
                                        }
                                        catch (NumberFormatException e) {
                                            throw new IOException(e);
                                        }
                                    }
                                    in.skip();
                                }
                                continue block24;
                            }
                            case "target": {
                                name = in.getAttribute(ATTR_NAME);
                                sampleRate = in.getIntegerAttribute(ATTR_SAMPLE_RATE, 0);
                                sampleRateGpu = in.getIntegerAttribute(ATTR_SAMPLE_RATE_GPU, 0);
                                coreCount = in.getIntegerAttribute(ATTR_CORES, 0);
                                gpuCoreCount = in.getIntegerAttribute(ATTR_GPU_CORES, -1);
                                cpuId = in.getIntegerAttribute(ATTR_CPUID, 0);
                                gdMd5Sum = in.getAttribute(ATTR_GATORD_MD5);
                                buildId = in.getAttribute(ATTR_GATORD_BUILD_ID);
                                supportsLive = in.isAttributeSet(ATTR_SUPPORTS_LIVE, false);
                                localCapture = in.isAttributeSet(ATTR_LOCAL_CAPTURE, false);
                                os = in.getAttribute(ATTR_OS);
                                osVersion = in.getAttribute(ATTR_OS_VERSION);
                                offCpuProfiling = in.isAttributeSet(ATTR_OFF_CPU_PROFILING, false);
                                in.skip();
                                break;
                            }
                            case "process": {
                                processName = in.getAttribute(ATTR_PROCESS_NAME);
                                packageName = in.getAttribute(ATTR_PACKAGE_NAME);
                                activityName = in.getAttribute(ATTR_ACTIVITY_NAME);
                                activityArguments = in.getAttribute(ATTR_ACTIVITY_ARGUMENTS);
                                in.skip();
                                break;
                            }
                            case "counters": {
                                String countersMarker = in.getMarker();
                                while ((tag = in.nextTag(countersMarker)) != null) {
                                    if (TAG_COUNTER.equals(tag)) {
                                        try {
                                            CounterRecord counterRecord = new CounterRecord(in);
                                            @NonNull List<@NonNull T> sameKey = counterList.stream().filter(c -> c.getKey() == counterRecord.getKey()).collect(Collectors.toList());
                                            if (!sameKey.isEmpty()) {
                                                throw new IOException(Messages.DUPLICATE_KEY_ERROR);
                                            }
                                            counterList.add(counterRecord);
                                        }
                                        catch (BadXmlException e) {
                                            StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)"Invalid XML in counter record", (Throwable)e);
                                        }
                                        continue;
                                    }
                                    if (TAG_SPE.equals(tag)) {
                                        int key;
                                        if (!in.hasAttribute(ATTR_ID)) {
                                            throw new IOException(Messages.MISSING_SPE_ID_ERROR);
                                        }
                                        String id = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_ID));
                                        if (in.hasAttribute(ATTR_KEY)) {
                                            String key_attribute = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_KEY));
                                            try {
                                                key = BasicNumberUtils.decodeUnsignedInt((String)key_attribute);
                                            }
                                            catch (NumberFormatException exception) {
                                                throw new IOException(Messages.INVALID_KEY_ERROR, exception);
                                            }
                                        } else {
                                            throw new IOException(Messages.MISSING_SPE_KEY_ERROR);
                                        }
                                        if (speKeys.containsKey(key)) {
                                            throw new IOException(Messages.DUPLICATE_KEY_ERROR);
                                        }
                                        speKeys.put(key, (Object)id);
                                        continue;
                                    }
                                    in.skip();
                                }
                                @NonNull List<T> counterKeys = counterList.stream().map(CounterRecord::getKey).collect(Collectors.toList());
                                @NonNull List<@NonNull T> speKeyValues = Arrays.stream(speKeys.keys()).boxed().collect(Collectors.toList());
                                if (counterKeys.stream().filter(speKeyValues::contains).collect(Collectors.toList()).isEmpty()) continue block24;
                                throw new IOException(Messages.DUPLICATE_KEY_ERROR);
                            }
                            case "templates": {
                                String templatesMarker = in.getMarker();
                                while ((tag = in.nextTag(templatesMarker)) != null) {
                                    if ("template".equals(tag)) {
                                        TemplateFile template = new TemplateFile();
                                        name = in.getAttribute(ATTR_NAME);
                                        if (name != null) {
                                            TemplatePath templatePath = new TemplatePath(name, false);
                                            template.setPath(templatePath);
                                        }
                                        template.addAllCharts(GatorCapturedRawXML.parseCapturedTemplateChartsXML(in));
                                        templates.add(template);
                                        continue;
                                    }
                                    in.skip();
                                }
                                continue block24;
                            }
                            default: {
                                in.skip();
                            }
                        }
                    }
                    continue;
                }
                in.skip();
            }
        }
        finally {
            CommonFileUtils.ignoredClose((Closeable)in);
        }
        if (streamlineVersion == null || protocolInfo == null) {
            throw new AssertionError();
        }
        return new GatorCapturedRawXML(liveEnergyDelta, created, backtraceProcessing, streamlineVersion, protocolInfo, error, isPerfImport, name, sampleRate, sampleRateGpu, coreCount, cpuId, supportsLive, localCapture, counterList, templates, (TIntObjectMap<String>)speKeys, (TIntSet)maliGpuIds, os, osVersion, gpuCoreCount == -1 ? null : Integer.valueOf(gpuCoreCount), gdMd5Sum, buildId, processName, offCpuProfiling, packageName, activityName, activityArguments);
    }

    public static @NonNull GatorCapturedRawXML readFromDir(@NonNull File directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLParser in = XMLParser.create((File)new File(directory, "captured.xml"));){
            return GatorCapturedRawXML.read(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addCounter(@NonNull List<@NonNull CounterRecord> createdCounters, @NonNull CounterRecord counter) {
        String title = counter.getTitle();
        String name = counter.getCounter();
        if (title != null && title.matches("ARM_Mali-.*_Filmstrip") || name != null && name.matches("^(ARM_Mali-.*_Filmstrip|[at]trace_).*")) {
            return;
        }
        createdCounters.add(counter);
    }

    private static boolean isCounterClassConstant(@Nullable CounterClass counterClass) {
        return counterClass != null && counterClass.isConstant();
    }

    private static @NonNull List<@NonNull ChartAndSeriesConfig> parseCapturedTemplateChartsXML(@NonNull XMLParser in) throws IOException {
        String tag;
        ArrayList<@NonNull ChartAndSeriesConfig> config = new ArrayList<ChartAndSeriesConfig>();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if ("chart".equals(tag)) {
                config.addAll(ChartAndSeriesXMLParser.load(in, false, Collections.emptyMap()));
                continue;
            }
            in.skip();
        }
        return config;
    }

    public GatorCapturedRawXML(@Nullable Integer liveEnergyDelta, long created, @NonNull BacktraceProcessing backtraceProcessing, @NonNull GatorProtocolVersion streamlineVersion, @NonNull ProtocolInfo protocolInfo, @Nullable String error, boolean isPerfImport, @Nullable String name, int sampleRate, int sampleRateGpu, int coreCount, int cpuId, boolean supportsLive, boolean localCapture, @NonNull List<@NonNull CounterRecord> counterList, @NonNull List<@NonNull TemplateFile> templateList, @NonNull TIntObjectMap<@NonNull String> speKeys, @NonNull TIntSet maliGpuIds, String os, String osVersion, @Nullable Integer gpuCoresCount, @Nullable String gdMd5Sum, @Nullable String buildID, @Nullable String processName, boolean offCpuProfiling, @Nullable String androidPackage, @Nullable String androidActivity, @Nullable String androidActivityFlags) {
        this.mLiveEnergyDelta = liveEnergyDelta;
        this.mCreated = created;
        this.mBacktraceProcessing = backtraceProcessing;
        this.mStreamlineVersion = streamlineVersion;
        this.mProtocolInfo = protocolInfo;
        this.mError = error;
        this.mIsPerfImport = isPerfImport;
        this.mName = name;
        this.mProcessName = processName;
        this.mAndroidPackage = androidPackage;
        this.mAndroidActivity = androidActivity;
        this.mAndroidActivityFlags = androidActivityFlags;
        this.mSampleRate = sampleRate;
        this.mSampleRateGpu = sampleRateGpu;
        this.mCoreCount = coreCount;
        this.mCpuId = cpuId;
        this.mSupportsLive = supportsLive;
        this.mLocalCapture = localCapture;
        this.mCounterList = counterList;
        this.mTemplateList = templateList;
        this.mSpeKeys = speKeys;
        this.mMaliGpuIds = maliGpuIds;
        this.mOs = os;
        this.mOsVersion = osVersion;
        this.gpuCoresCount = gpuCoresCount;
        this.gdMd5Sum = gdMd5Sum;
        this.buildID = buildID;
        this.offCpuProfiling = offCpuProfiling;
    }

    public GatorCapturedRawXML(@Nullable Integer liveEnergyDelta, long created, @NonNull BacktraceProcessing backtraceProcessing, @NonNull GatorProtocolVersion streamlineVersion, @NonNull ProtocolInfo protocolInfo, @Nullable String error, @Nullable String name, int sampleRate, int sampleRateGpu, int coreCount, int cpuId, boolean supportsLive, boolean localCapture, @NonNull List<@NonNull CounterRecord> counterList, @NonNull List<@NonNull TemplateFile> templateList, @NonNull TIntObjectMap<@NonNull String> speKeys, @NonNull TIntSet maliGpuIds, String os, String osVersion, @Nullable Integer gpuCoresCount, @Nullable String gdMd5Sum, @Nullable String buildID, @Nullable String processName, boolean offCpuProfiling, @Nullable String packageName, @Nullable String activityName, @Nullable String activityArguments) {
        this(liveEnergyDelta, created, backtraceProcessing, streamlineVersion, protocolInfo, error, false, name, sampleRate, sampleRateGpu, coreCount, cpuId, supportsLive, localCapture, counterList, templateList, speKeys, maliGpuIds, os, osVersion, gpuCoresCount, gdMd5Sum, buildID, processName, offCpuProfiling, packageName, activityName, activityArguments);
    }

    public void applyEventProperties(@NonNull Map<String, StockCounter> stockCounterMap, @NonNull Collection<@NonNull SpeTargetDescription> speTargetDescriptions) throws IOException {
        HashSet<SpeCaptureRecord> createdSpes = new HashSet<SpeCaptureRecord>();
        ArrayList<CounterRecord> createdCounters = new ArrayList<CounterRecord>();
        GatorCapturedRawXML.createCountersFromCapturedAndEventsXml(false, createdCounters, createdSpes, this.mCoreCount, stockCounterMap, speTargetDescriptions, this);
        this.mCounterList.clear();
        this.mCounterList.addAll(createdCounters);
    }

    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"})
    public boolean equals(Object obj) {
        @Nullable Integer mLiveEnergyDelta = this.mLiveEnergyDelta;
        @Nullable String mError = this.mError;
        @Nullable String mName = this.mName;
        @Nullable String mProcessName = this.mProcessName;
        @Nullable String mAndroidPackage = this.mAndroidPackage;
        @Nullable String mAndroidActivity = this.mAndroidActivity;
        @Nullable String mAndroidActivityFlags = this.mAndroidActivityFlags;
        @Nullable String mOs = this.mOs;
        @Nullable String mOsVersion = this.mOsVersion;
        @Nullable Integer gpuCoresCount = this.gpuCoresCount;
        @Nullable String gdMd5Sum = this.gdMd5Sum;
        @Nullable String buildID = this.buildID;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GatorCapturedRawXML other = (GatorCapturedRawXML)obj;
        if (!Objects.equals(buildID, other.buildID)) {
            return false;
        }
        if (!Objects.equals(gdMd5Sum, other.gdMd5Sum)) {
            return false;
        }
        if (!Objects.equals(gpuCoresCount, other.gpuCoresCount)) {
            return false;
        }
        if (this.mBacktraceProcessing != other.mBacktraceProcessing) {
            return false;
        }
        if (this.mCoreCount != other.mCoreCount) {
            return false;
        }
        if (!this.mCounterList.equals(other.mCounterList)) {
            return false;
        }
        if (this.mCpuId != other.mCpuId) {
            return false;
        }
        if (this.mCreated != other.mCreated) {
            return false;
        }
        if (!Objects.equals(mError, other.mError)) {
            return false;
        }
        if (!Objects.equals(mLiveEnergyDelta, other.mLiveEnergyDelta)) {
            return false;
        }
        if (this.mLocalCapture != other.mLocalCapture) {
            return false;
        }
        if (!this.mMaliGpuIds.equals((Object)other.mMaliGpuIds)) {
            return false;
        }
        if (!Objects.equals(mName, other.mName)) {
            return false;
        }
        if (!Objects.equals(mProcessName, other.mProcessName)) {
            return false;
        }
        if (!Objects.equals(mAndroidPackage, other.mAndroidPackage)) {
            return false;
        }
        if (!Objects.equals(mAndroidActivity, other.mAndroidActivity)) {
            return false;
        }
        if (!Objects.equals(mAndroidActivityFlags, other.mAndroidActivityFlags)) {
            return false;
        }
        if (!Objects.equals(mOs, other.mOs)) {
            return false;
        }
        if (!Objects.equals(mOsVersion, other.mOsVersion)) {
            return false;
        }
        if (!this.mProtocolInfo.equals(other.mProtocolInfo)) {
            return false;
        }
        if (this.mSampleRate != other.mSampleRate) {
            return false;
        }
        if (this.mSampleRateGpu != other.mSampleRateGpu) {
            return false;
        }
        if (!this.mSpeKeys.equals(other.mSpeKeys)) {
            return false;
        }
        if (!this.mStreamlineVersion.equals(other.mStreamlineVersion)) {
            return false;
        }
        if (this.mSupportsLive != other.mSupportsLive) {
            return false;
        }
        if (!this.mTemplateList.equals(other.mTemplateList)) {
            return false;
        }
        return this.offCpuProfiling == other.offCpuProfiling;
    }

    public @NonNull BacktraceProcessing getBacktraceProcessing() {
        return this.mBacktraceProcessing;
    }

    public @NonNull CaptureSubType getCaptureSubType() {
        return GatorCapturedRawXML.getCaptureSubType(this.mOs);
    }

    public int getCoreCount() {
        return this.mCoreCount;
    }

    public @NonNull List<@NonNull CounterRecord> getCounterList() {
        return this.mCounterList;
    }

    public int getCpuId() {
        return this.mCpuId;
    }

    public long getCreated() {
        return this.mCreated;
    }

    public @Nullable String getError() {
        return this.mError;
    }

    public @Nullable String getGatordBuildId() {
        return this.buildID;
    }

    public @Nullable String getGatordMd5Sum() {
        return this.gdMd5Sum;
    }

    public @Nullable Integer getGpuCoresCount() {
        return this.gpuCoresCount;
    }

    public @Nullable Integer getLiveEnergyDelta() {
        return this.mLiveEnergyDelta;
    }

    public @NonNull TIntSet getMaliGpuIds() {
        return TCollections.unmodifiableSet((TIntSet)this.mMaliGpuIds);
    }

    public @Nullable String getName() {
        return this.mName;
    }

    public @Nullable String getOs() {
        return this.mOs;
    }

    public @Nullable String getOsVersion() {
        return this.mOsVersion;
    }

    public @Nullable String getProcessName() {
        return this.mProcessName;
    }

    public @Nullable String getAndroidPackage() {
        return this.mAndroidPackage;
    }

    public @Nullable String getAndroidActivity() {
        return this.mAndroidActivity;
    }

    public @Nullable String getAndroidActivityFlags() {
        return this.mAndroidActivityFlags;
    }

    public @NonNull ProtocolInfo getProtocolInfo() {
        return (ProtocolInfo)NullChecking.neverNull((Object)this.mProtocolInfo);
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getSampleRateGpu() {
        return this.mSampleRateGpu;
    }

    public @NonNull TIntObjectMap<@NonNull String> getSpeKeys() {
        return this.mSpeKeys;
    }

    public @NonNull GatorProtocolVersion getStreamlineVersion() {
        return this.mStreamlineVersion;
    }

    public @NonNull List<@NonNull TemplateFile> getTemplates() {
        return Collections.unmodifiableList(this.mTemplateList);
    }

    public int hashCode() {
        @Nullable Integer mLiveEnergyDelta = this.mLiveEnergyDelta;
        @Nullable String mError = this.mError;
        @Nullable String mName = this.mName;
        @Nullable String mProcessName = this.mProcessName;
        @Nullable String mOs = this.mOs;
        @Nullable String mOsVersion = this.mOsVersion;
        @Nullable Integer gpuCoresCount = this.gpuCoresCount;
        @Nullable String gdMd5Sum = this.gdMd5Sum;
        @Nullable String buildID = this.buildID;
        int prime = 31;
        int result = 1;
        result = 31 * result + (buildID == null ? 0 : buildID.hashCode());
        result = 31 * result + (gdMd5Sum == null ? 0 : gdMd5Sum.hashCode());
        result = 31 * result + (gpuCoresCount == null ? 0 : gpuCoresCount.hashCode());
        result = 31 * result + this.mBacktraceProcessing.hashCode();
        result = 31 * result + this.mCoreCount;
        result = 31 * result + this.mCounterList.hashCode();
        result = 31 * result + this.mCpuId;
        result = 31 * result + (int)(this.mCreated ^ this.mCreated >>> 32);
        result = 31 * result + (mError == null ? 0 : mError.hashCode());
        result = 31 * result + (mLiveEnergyDelta == null ? 0 : mLiveEnergyDelta.hashCode());
        result = 31 * result + (this.mLocalCapture ? 1231 : 1237);
        result = 31 * result + this.mMaliGpuIds.hashCode();
        result = 31 * result + (mName == null ? 0 : mName.hashCode());
        result = 31 * result + (mProcessName == null ? 0 : mProcessName.hashCode());
        result = 31 * result + (mOs == null ? 0 : mOs.hashCode());
        result = 31 * result + (mOsVersion == null ? 0 : mOsVersion.hashCode());
        result = 31 * result + this.mProtocolInfo.hashCode();
        result = 31 * result + this.mSampleRate;
        result = 31 * result + this.mSampleRateGpu;
        result = 31 * result + this.mSpeKeys.hashCode();
        result = 31 * result + this.mTemplateList.hashCode();
        result = 31 * result + this.mStreamlineVersion.hashCode();
        result = 31 * result + (this.mSupportsLive ? 1231 : 1237);
        result = 31 * result + (this.offCpuProfiling ? 1231 : 1237);
        return result;
    }

    public boolean is64bit() {
        return (this.mCpuId & 0xFF0) == 3328;
    }

    public boolean isLocalCapture() {
        return this.mLocalCapture;
    }

    public boolean isOffCpuProfilingEnabled() {
        return this.offCpuProfiling;
    }

    public boolean isPerfImport() {
        return this.mIsPerfImport;
    }

    public void save(boolean writeEventProperties, @NonNull OutputStream stream) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = new XMLGenerator(stream);){
            xml.startDocument();
            xml.startTag(TAG_CAPTURED);
            xml.addAttribute(ATTR_VERSION, 1);
            if (this.mLiveEnergyDelta != null) {
                xml.addAttribute(ATTR_LIVE_ENERGY_DELTA, this.mLiveEnergyDelta.intValue());
            }
            xml.addAttributeNot(ATTR_CREATED, this.mCreated, 0L);
            xml.addAttributeNot(ATTR_STREAMLINE_VERSION, this.mStreamlineVersion.getVersionNumber(), 0);
            @NonNull ProtocolType type = this.getProtocolInfo().getType();
            xml.addAttribute(ATTR_TYPE, type.xmlValue());
            xml.addAttribute(ATTR_PROTOCOL, this.getProtocolInfo().getRawProtocolVersion());
            xml.addAttributeNot(ATTR_BACKTRACE_PROCESSING, this.mBacktraceProcessing.toXmlString(), BacktraceProcessing.GATOR.toXmlString());
            if (this.mError != null) {
                xml.addAttribute(ATTR_ERROR, this.mError);
            }
            xml.startEmptyTag(TAG_PROCESS);
            xml.addAttribute(ATTR_PROCESS_NAME, this.mProcessName);
            if (this.mAndroidPackage != null) {
                xml.addAttribute(ATTR_PACKAGE_NAME, this.mAndroidPackage);
            }
            if (this.mAndroidActivity != null) {
                xml.addAttribute(ATTR_ACTIVITY_NAME, this.mAndroidActivity);
                if (this.mAndroidActivityFlags != null) {
                    xml.addAttribute(ATTR_ACTIVITY_ARGUMENTS, this.mAndroidActivityFlags);
                }
            }
            xml.startEmptyTag(TAG_TARGET);
            xml.addAttribute(ATTR_NAME, this.mName);
            xml.addAttribute(ATTR_SAMPLE_RATE, this.mSampleRate);
            xml.addAttribute(ATTR_SAMPLE_RATE_GPU, this.mSampleRateGpu);
            xml.addAttribute(ATTR_CORES, this.mCoreCount);
            if (this.gpuCoresCount != null) {
                xml.addAttribute(ATTR_GPU_CORES, this.gpuCoresCount.intValue());
            }
            xml.addAttribute(ATTR_CPUID, "0x" + Integer.toHexString(this.mCpuId));
            if (this.mSupportsLive) {
                xml.addAttribute(ATTR_SUPPORTS_LIVE, true);
            }
            if (this.mLocalCapture) {
                xml.addAttribute(ATTR_LOCAL_CAPTURE, true);
            }
            if (this.offCpuProfiling) {
                xml.addAttribute(ATTR_OFF_CPU_PROFILING, true);
            }
            if (this.gdMd5Sum != null) {
                xml.addAttribute(ATTR_GATORD_MD5, this.gdMd5Sum);
            }
            if (this.buildID != null) {
                xml.addAttribute(ATTR_GATORD_BUILD_ID, this.buildID);
            }
            xml.addAttributeNot(ATTR_OS, this.mOs, null);
            xml.addAttributeNot(ATTR_OS_VERSION, this.mOsVersion, null);
            if (!this.mMaliGpuIds.isEmpty()) {
                xml.startTag(TAG_GPUS);
                for (int gpuId : this.mMaliGpuIds) {
                    xml.startEmptyTag(TAG_GPU);
                    xml.addAttribute(ATTR_ID, String.format("0x%x", gpuId));
                }
                xml.endTag();
            }
            if (!this.mCounterList.isEmpty() || !this.mSpeKeys.isEmpty()) {
                xml.startTag(TAG_COUNTERS);
                for (CounterRecord counter : this.mCounterList) {
                    xml.startTag(TAG_COUNTER);
                    counter.write(xml, writeEventProperties);
                    xml.endTag();
                }
                int[] nArray = this.mSpeKeys.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int spe_key = nArray[n2];
                    xml.startEmptyTag(TAG_SPE);
                    xml.addAttribute(ATTR_KEY, spe_key);
                    xml.addAttribute(ATTR_ID, (String)this.mSpeKeys.get(spe_key));
                    ++n2;
                }
                xml.endTag();
            }
            xml.startTag(TAG_TEMPLATES);
            for (TemplateFile template : this.mTemplateList) {
                xml.startTag("template");
                String name = template.getName();
                if (!name.isEmpty()) {
                    xml.addAttribute(ATTR_NAME, name);
                }
                ChartAndSeriesXMLParser.save(xml, template.getCharts());
                xml.endTag();
            }
            xml.endTag();
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(@NonNull File file, boolean writeEventProperties) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            this.save(writeEventProperties, stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setError(@Nullable String error) {
        this.mError = error;
    }

    public void setLiveEnergyDelta(@Nullable Integer liveEnergyDelta) {
        this.mLiveEnergyDelta = liveEnergyDelta;
    }

    public void setStreamlineVersion(@NonNull GatorProtocolVersion streamlineVersion) {
        this.mStreamlineVersion = streamlineVersion;
    }

    public boolean supportsLive() {
        return this.mSupportsLive;
    }
}

